from __future__ import absolute_import
from __future__ import print_function
from reflex import RecipeParameter


class Parameters(RecipeParameter):

    # This function specifies which are the parameters that should be presented
    # in the window to be edited.
    # Note that the parameter has to be also in the in_sop port (otherwise it 
    # won't appear in the window) 
    # The descriptions are used to show a tooltip. They should match one to one
    # with the parameter list 
    # Note also that parameters have to be prefixed by the 'recipe name:'

    def setGenParameters(self, paramList, rec_id, group):
        name1 = "lc_sw"
        help1 = "Correct for bad lines introduced by instrument software:. [FALSE]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

    def setCommonParameters(self, paramList, rec_id, group):
        name1 = "product_depth"
        help1 = "Specifies the product output depth instrument (>0 for auxillary products). [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "bpm.method"
        help2 = "Specifies the VLT instrument {2d,3d,2d3d}. <2d | 3d | 2d3d | none> [2d3d]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "collapse.method"
        help3 = "Method used for collapsing the data. <MEAN | WEIGHTED_MEAN | MEDIAN | SIGCLIP | MINMAX> [MEDIAN]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "collapse.sigclip.kappa-low"
        help4 = "Low kappa factor for kappa-sigma clipping algorithm. [3.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "collapse.sigclip.kappa-high"
        help5 = "High kappa factor for kappa-sigma clipping algorithm. [3.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "collapse.sigclip.niter"
        help6 = "Maximum number of clipping iterations for kappa-sigma clipping. [5]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "collapse.minmax.nlow"
        help7 = "Low number of pixels to reject for the minmax clipping algorithm. [1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

        name8 = "collapse.minmax.nhigh"
        help8 = "High number of pixels to reject for the minmax clipping algorithm. [1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group, description=help8))

    def set2DBadPixParameters(self, paramList, rec_id, group):
        name1 = "2dBadPix.method"
        help1 = "Method used. <FILTER | LEGENDRE> [FILTER]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "2dBadPix.legendre.kappa-low"
        help2 = "Low RMS scaling factor for image thresholding. [10.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "2dBadPix.legendre.kappa-high"
        help3 = "High RMS scaling factor for image thresholding. [10.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "2dBadPix.legendre.maxiter"
        help4 = "Maximum number of algorithm iterations. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "2dBadPix.legendre.steps-x"
        help5 = "Number of image sampling points in x-dir for fitting. [20]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "2dBadPix.legendre.steps-y"
        help6 = "Number of image sampling points in y-dir for fitting. [20]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "2dBadPix.legendre.filter-size-x"
        help7 = "X size of the median box around sampling points. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

        name8 = "2dBadPix.legendre.filter-size-y"
        help8 = "Y size of the median box around sampling points. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group, description=help8))

        name9 = "2dBadPix.legendre.order-x"
        help9 = "Order of x polynomial for the fit. [2]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group, description=help9))

        name10 = "2dBadPix.legendre.order-y"
        help10 = "Order of y polynomial for the fit. [2]"
        paramList.append(RecipeParameter(rec_id, displayName=name10, group=group, description=help10))

        name11 = "2dBadPix.filter.kappa-low"
        help11 = "Low RMS scaling factor for image thresholding. [10.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name11, group=group, description=help11))

        name12 = "2dBadPix.filter.kappa-high"
        help12 = "High RMS scaling factor for image thresholding. [10.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group, description=help12))

        name13 = "2dBadPix.filter.maxiter"
        help13 = "Maximum number of algorithm iterations. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group, description=help13))

        name14 = "2dBadPix.filter.filter"
        help14 = "Filter mode for image smooting. <AVERAGE | AVERAGE_FAST | MEDIAN> [MEDIAN]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group, description=help14))

        name15 = "2dBadPix.filter.border"
        help15 = "Border mode to use for the image smooting filter (only for MEDIAN filter). " \
                 "<FILTER | CROP | NOP | COPY> [NOP]"
        paramList.append(RecipeParameter(rec_id, displayName=name15, group=group, description=help15))

        name16 = "2dBadPix.filter.smooth-x"
        help16 = "Kernel y size of the smoothing filter. [5]"
        paramList.append(RecipeParameter(rec_id, displayName=name16, group=group, description=help16))

        name17 = "2dBadPix.filter.smooth-y"
        help17 = "Kernel y size of the image smoothing filter. [5]"
        paramList.append(RecipeParameter(rec_id, displayName=name17, group=group, description=help17))

    def set3DBadPixParameters(self, paramList, rec_id, group):
        name1 = "3dBadPix.kappa-low"
        help1 = "Low RMS scaling factor for image thresholding. [12.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "3dBadPix.kappa-high"
        help2 = "High RMS scaling factor for image thresholding. [12.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "3dBadPix.method"
        help3 = "Thresholdig method to use for bpm detection. <absolute | relative | error> [relative]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

    def setFlatParameters(self, paramList, rec_id, group):
        name1 = "flat_lo.filter-size-x"
        help1 = "Smoothing filter size in x-direction. [5]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "flat_lo.filter-size-y"
        help2 = "Smoothing filter size in y-direction. [5]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "flat_lo.method"
        help3 = "Method to use for the master flatfield calculation. <low | high> [low]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "flat_hi.filter-size-x"
        help4 = "Smoothing filter size in x-direction. [7]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "flat_hi.filter-size-y"
        help5 = "Smoothing filter size in y-direction. [7]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "flat_hi.method"
        help6 = "Method to use for the master flatfield calculation. <low | high> [high]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

    def setDistortionParameters(self, paramList, rec_id, group):
        name1 = "distortion.arcs.thresh_factor"
        help1 = "median_value(image)+ kappa*sigma is the minimum intensity threshold of accepted image pixels. " \
                "[0.33333]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "distortion.arcs.min_arclen_factor"
        help2 = "factor which sets minimum arc length (1.0-2). [1.19]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "distortion.arcs.window_size"
        help3 = "Size of window for low pass filter used in an horizontal low pass filter to remove unwanted arcs" \
                " (5-64). [14]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "distortion.smooth_rad"
        help4 = "Size of smoothing factor (1-11) used to prevent for possible intensity drops from detector " \
                "electronics on fibre illuminated slitlets (1-11). [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "wave.div"
        help5 = "Divide masterflat from subtracted wave frame. [TRUE]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

    def setDetlinParameters(self, paramList, rec_id, group):
        name1 = "degree"
        help1 = "Degree of polynomial to fit. [1]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "pval"
        help2 = "p-value threshold (in percent). Fits with a p-value below this threshold are considered bad pixels. " \
                "[-1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "rel-chi-low"
        help3 = "Relative chi threshold. Pixels with with a chi value smaller than " \
                "mean - rel-threshold * stdev-of-chi are considered bad pixels. [8.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "rel-chi-high"
        help4 = "Relative chi threshold. Pixels with with a chi value larger than " \
                "mean + rel-threshold * stdev-of-chi are considered bad pixels. [8.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "rel-coef-low"
        help5 = "Relative fit coefficient threshold. Pixels with with a coefficient value smaller than " \
                "mean +- rel-threshold * stdev-of-coeff are considered bad pixels. [-1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "rel-coef-high"
        help6 = "Relative fit coefficient threshold. Pixels with with a coefficient value larger than " \
                "mean +- rel-threshold * stdev-of-coeff are considered bad pixels. [-1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "pfx"
        help7 = "X Size of the post filtering kernel. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

        name8 = "pfy"
        help8 = "Y Size of the post filtering kernel. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group, description=help8))

        name9 = "pfm"
        help9 = "Post filtering mode. <closing | dilation> [closing]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group, description=help9))

    def setWaveCalParameters(self, paramList, rec_id, group):
        print("wavecal")

        name1 = "col_corr"
        help1 = "If TRUE raw exposure image column correction will be applied. [TRUE]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "crh_corr"
        help2 = "If TRUE raw exposure image cosmic ray hit correction will be applied. [FALSE]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "crh_detection"
        help3 = "If TRUE raw exposure image cosmic ray hit detection will be applied. [FALSE]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "crh.sigma_lim"
        help4 = "Poisson fluctuation threshold to flag cosmics(see van Dokkum, PASP,113,2001,p1420-27). [5.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "crh.f_lim"
        help5 = "Minimum contrast between the Laplacian image and the fine structure image that a point must have " \
                "to be flagged as cosmics. [2.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "crh.max_iter"
        help6 = "Maximum number of alghoritm iterations. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "pixel_saturation"
        help7 = "Pixel saturation level. [1.8e+04]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

    def setJitterParameters(self, paramList, rec_id, group):
        name1 = "line_corr"
        help1 = "If TRUE raw exposure image line correction will be applied. [TRUE]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "col_corr"
        help2 = "If TRUE raw exposure image column correction will be applied. [TRUE]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "crh_corr"
        help3 = "If TRUE raw exposure image cosmic ray hit correction will be applied. [FALSE]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "crh_detection"
        help4 = "If TRUE raw exposure image cosmic ray hit detection will be applied. [FALSE]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "cube.slitlet-detection"
        help5 = "Specifies the slitlet detection: 'DIST' slitlet distances as detected by distortion recipe or " \
                "'EDGE' slitlet edges as detected be wavecalrecipe. <DIST | EDGE | GRID> [DIST]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "cube.first-col"
        help6 = "Specifies the first column offset in case the cube.slitlet-detection parameter is set to 'DIST'. [1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "cube.fine-tune"
        help7 = "Specifies the row interpolation mode: 0 -> no interpolation, otherwise " \
                "see eris_ifu_1d_interpolation. [-1]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

        name8 = "cube.combine"
        help8 = "With multi-pointing observations combine cubes into a mosaic. [TRUE]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group, description=help8))

    def setSciRedParametersOld(self, paramList, rec_id, group):
        print("parameters rec id", rec_id)
        name1 = "ovsc_sigma_clipping_method"
        help1 = "method for sigma clipping in OVSC, can be mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "ovsc_ksigma"
        help2 = "ksigma for sigma clipping in OVSC, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "ovsc_max_iter"
        help3 = "maximal number of iterations in OVSC, must be between: 1 and 5000000. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "bias_correction_method"
        help4 = "method for BIAS correction, can be auto, master_bias or overscan, use master_bias only if " \
                "there is a permanent BIAS structure. [overscan]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "correct_dark_flag"
        help5 = "Switch on/off dark correction, 1=on 0=off. [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "science_fiber_name"
        help6 = "Science fibre name. [A]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "reference_fiber_name"
        help7 = "Reference fibre name. [A]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

        name8 = "background_subtraction"
        help8 = "if 1 (default value) then background is subtracted, 1=on 0=off. [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group, description=help8))

        name9 = "bkgr_grid_size_x"
        help9 = "Grid size in x used to calculate the background, between: 128 and 512. [256]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group, description=help9))

        name10 = "bkgr_grid_size_y"
        help10 = "Grid size in y used to calculate the background, between: 128 and 512. [128]"
        paramList.append(RecipeParameter(rec_id, displayName=name10, group=group, description=help10))

        name11 = "inter_order_backg_function"
        help11 = "Function/method used to estimate background. [BKGR_SCI]"
        paramList.append(RecipeParameter(rec_id, displayName=name11, group=group, description=help11))

        name12 = "detector_realdim_x"
        help12 = "Real dimensions of detector in x dimension. [4096]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group, description=help12))

        name13 = "extraction_window"
        help13 = "Half-size of the window, in spatial direction, used to perform the optimum extraction. [8]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group, description=help13))

        name14 = "ksig_extraction_sky"
        help14 = "K used as flag for extraction selection (>=0: Horne, -1:rectangular)  and " \
                 "sigma clipping extraction for Horne. [3.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group, description=help14))

        name15 = "ksig_extraction_wave"
        help15 = "K used as flag for extraction selection (>=0: Horne, -1:rectangular)  and sigma clipping " \
                 "extraction for Horne. [-1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name15, group=group, description=help15))

        name16 = "tolerance_rejection"
        help16 = "Tolerance for rejection profile extraction, in percentage. [0.01]"
        paramList.append(RecipeParameter(rec_id, displayName=name16, group=group, description=help16))

        name17 = "wave_cal_source"
        help17 = "Wavelength calibration source to be used on science fiber ('ThAr' or        'COMB'). [ThAr]"
        paramList.append(RecipeParameter(rec_id, displayName=name17, group=group, description=help17))

        name18 = "ref_fiber_source"
        help18 = "source of simultaneous reference fiber ('ThAr' or 'COMB' or 'FP' or   'SKY'). [ThAr]"
        paramList.append(RecipeParameter(rec_id, displayName=name18, group=group, description=help18))

        name19 = "emission_lines_fit_method"
        help19 = "method used to fit emission lines on reference fiber and tolerances on fitted line parameters. []"
        paramList.append(RecipeParameter(rec_id, displayName=name19, group=group, description=help19))

        name20 = "drift_method"
        help20 = "method used to compute drift on reference fiber ('Bouchy' or  'Line-by-line' or " \
                 "'Fourier' or 'CCF'). [Bouchy]"
        paramList.append(RecipeParameter(rec_id, displayName=name20, group=group, description=help20))

        name21 = "drift_correction_scale"
        help21 = "drift correction scale ('Global' or 'Local' or TBD). [Global]"
        paramList.append(RecipeParameter(rec_id, displayName=name21, group=group, description=help21))

        name22 = "log_lambda_ini"
        help22 = "Starting point on wavelength for the 1d merged spectra. [200.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name22, group=group, description=help22))

        name23 = "log_lambda_end"
        help23 = "Ending point on wavelength for the 1d merged spectra. [300.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name23, group=group, description=help23))

        name24 = "delta_log_lambda"
        help24 = "Step in wavelength for the 1d merged spectra. [5.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name24, group=group, description=help24))

        name25 = "cosmics_part"
        help25 = "max acceptable cosmics in sci_red, between: 0.0 and 0.01. [40.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name25, group=group, description=help25))

        name26 = "rv_center"
        help26 = "Approximate RV. [20.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name26, group=group, description=help26))

        name27 = "rv_range"
        help27 = "Range for the RV table. [0.25]"
        paramList.append(RecipeParameter(rec_id, displayName=name27, group=group, description=help27))

        name28 = "rv_step"
        help28 = "Range's step for the RV table. [0.82]"
        paramList.append(RecipeParameter(rec_id, displayName=name28, group=group, description=help28))

        name29 = "mask_width"
        help29 = "Width of mask holes in km/s. [2.5e-06]"
        paramList.append(RecipeParameter(rec_id, displayName=name29, group=group, description=help29))

        name30 = "mask_table_id"
        help30 = "ask table to be used, defined by it's spectral type Id ('G2' 'M2' or 'K5'. [G2]"
        paramList.append(RecipeParameter(rec_id, displayName=name30, group=group, description=help30))

        name31 = "load"
        help31 = "Set the parameters loading mode:      'AUTO', values comes from *_inst_config.fits file or " \
                 "   'MANUAL', values comes from recipe configuration file. [AUTO]"
        paramList.append(RecipeParameter(rec_id, displayName=name31, group=group, description=help31))

        name32 = "snr_averaging_window"
        help32 = "Window size for averaging SNR calculation. [200]"
        paramList.append(RecipeParameter(rec_id, displayName=name32, group=group, description=help32))

        name33 = "extraction_method"
        help33 = "Method used to extract orders. [horne]"
        paramList.append(RecipeParameter(rec_id, displayName=name33, group=group, description=help33))

    def setSciRedParameters(self, paramList, rec_id, group):
        print("parameters rec id", rec_id)
        name1 = "wave_cal_source"
        help1 = "Wavelength calibration source to be used on science fiber ('THAR' or        'COMB'). [THAR]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group, description=help1))

        name2 = "ksigma_sky"
        help2 = "ksigma for removing cosmics on fiber A or SKY, -1.0 - no cosmics removal. [3.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group, description=help2))

        name3 = "rv_center"
        help3 = "Approximate RV. [19.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group, description=help3))

        name4 = "rv_range"
        help4 = "Range for the RV table. [20.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group, description=help4))

        name5 = "rv_step"
        help5 = " Range's step for the RV table. [0.25]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group, description=help5))

        name6 = "mask_table_id"
        help6 = "Mask table to be used, defined by it's spectral type Id ('G2' 'M2' or 'K5'. [G2]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group, description=help6))

        name7 = "extraction_method"
        help7 = "Method used to extract orders. [horne]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group, description=help7))

        name8 = "background_sw"
        help8 = "Background measurement activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group, description=help8))

        name9 = "flux_correction_sw"
        help9 = "Flux correction activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group, description=help9))

        name10 = "drift_correction_sw"
        help10 = "Drift correction activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name10, group=group, description=help10))

        name11 = "MB_res_remove_flag"
        help11 = "Flag indicating to remove or not MB residuals. [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name11, group=group, description=help11))
