from .eris_utils import ErisSetupInfo
from adari_core.data_libs.master_std_star_img import MasterStdStarImg
from adari_core.plots.text import TextPlot

from .eris_utils import ErisReportMixin


class ErisImgStdReport(ErisReportMixin, MasterStdStarImg):
    
    def __init__(self):
        super().__init__("eris_img_std_star")

    def parse_sof(self):

        reduced = None
        for filename, catg in self.inputs:
            if catg == "IMG_STD_COMBINED":
                reduced = filename
        file_lists = []
        if reduced is not None:
            file_lists.append(
                {
                   "calib_std": reduced,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3
        ext = "DATA"
        
        new_panels = super().generate_panels(
            im_ext=ext,
            im_clipping="mad",
            im_n_clipping={"nmad":10},
            hist_raw=False,
            hist_clipping="val",
            hist_n_clipping={"low":-5000.,"high":70000.},
        )
            
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            calib_std = self.hdus[i]["calib_std"]
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = ErisSetupInfo.nix_on_sky(calib_std)
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

        panels = {**panels, **new_panels}

        return panels


rep = ErisImgStdReport()

