/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_JITTER_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_JITTER_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <time.h>
#include <math.h>
#include <gsl/gsl_interp2d.h>

#include <cpl.h>
#include <hdrl.h>
#include "eris_ifu_functions.h"
#include "eris_ifu_jitter_interface.h"
#include "eris_ifu_extract_spec_static.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

typedef enum {OBJECT_CUBE, STD_CUBE, PSF_CUBE, STD_FLUX_CUBE, SKY_OBJECT_CUBE,
	SKY_STD_CUBE, SKY_PSF_CUBE, SKY_STD_FLUX_CUBE, TWEAKED_CUBE, TWEAKED_STD_CUBE,
	DAR_CUBE, DAR_STD_CUBE, DAR_PSF_CUBE, DAR_STD_FLUX_CUBE, PUPIL_CUBE,
	JITTER_CUBE, BPM_CUBE, STD_CUBE_NOFLAT, STD_FLUX_CUBE_NOFLAT,
	OBJECT_CUBE_COADD, TWEAKED_CUBE_COADD, DAR_CUBE_COADD,DAR_STD_CUBE_COADD,
	DAR_PSF_CUBE_COADD, DAR_PUPIL_CUBE_COADD, STD_CUBE_COADD,
	PSF_CUBE_COADD, STD_FLUX_CUBE_COADD, PUPIL_CUBE_COADD,
	STD_FLUX_CUBE_COADD_NOFLAT, STD_CUBE_COADD_NOFLAT}
cubeType;

/*
struct cubesStruct {
        int                 cubeCnt;
        cpl_imagelist       **cube;
        cpl_propertylist    **header;
};
*/

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/

cpl_error_code eris_ifu_jitter_process_exposures(struct sofStruct *sof,
                                                 struct stdParamStruct stdParams,
                                                 struct paramStruct params,
                                                 cpl_frameset *frameset,
                                                 const cpl_parameterlist * parlist,
												 const char* recipe_name,
												 const char* context);

cpl_error_code eris_ifu_jitter_process_cubes(struct sofStruct *sof,
                                             struct stdParamStruct stdParams,
                                             struct paramStruct params,
                                             cpl_frameset *frameset,
                                             const cpl_parameterlist * parlist,
											 const char* recipe_name,
											 cubeType *obj_type);

cpl_imagelist *eris_ifu_jitter_reconstruct_cube(
        cpl_image *resampledDetImage,
        slitletDetectionModes mode,
        int fineTuneMode,
        double firstCol,
        cpl_vector  *distancesV,
        cpl_bivector *positionsVV);

hdrl_image *eris_ifu_jitter_subtract_background(
        skyTweakModes sky_tweak,
        int sofIdx,
        struct sofStruct *sof,
        productDepthType productDepth);

hdrl_imagelist *eris_ifu_jitter_build_cube(
        hdrl_image *image,
        int sofIdx,
        struct sofStruct *sof,
        struct paramStruct params,
        bool doVelocityCorrection,
        cpl_polynomial *ohLambdaCorrection,
        productDepthType productDepth);

cpl_error_code eris_ifu_extract_spec(
        const cpl_imagelist *data_in,
        const cpl_imagelist *noise_in,
        cpl_image     *mask,
        cpl_vector    **spec_data_out,
        cpl_vector    **spec_noise_out);

cubeType
eris_ifu_jitter_get_obj_type(sofModes mode);
cubeType
eris_ifu_jitter_get_sky_type(sofModes mode);
cubeType
eris_ifu_jitter_get_coadd_obj_type(cubeType type);
cpl_error_code
eris_ifu_jitter_get_procatg_and_filename(cubeType type, char **proCatg,
		char    **filenamePrefix);

void eris_ifu_jitter_free_sofStruct(struct sofStruct* sof_struct);

cpl_error_code
eris_ifu_jitter_extract(cpl_frameset  * frameset,
		const cpl_parameterlist * parlist, cubeType obj_type, const char* pcatg,
		struct stdParamStruct stdParams, const char* recipe_name,
		const char* context);
cpl_error_code
eris_ifu_jitter_extract_spec_processSof(
		cubeType obj_type,
        cpl_frameset* frames,
        struct esParamStruct params,
        struct esSofStruct *sof);

cpl_error_code eris_ifu_extract_spec_fetch_params(
		const cpl_parameterlist * parlist,
		struct esParamStruct *params,
		const char* context);

cpl_error_code eris_ifu_dar_correction(hdrl_imagelist *cube,
        cpl_propertylist *hdr,
        int method,
        double radius,
        int length);

cpl_error_code eris_ifu_dar_cpl_shift(
        cpl_image *inImg,
        cpl_image *out1Img,
        cpl_image *out2Img,
        double xShift,
        double yShift,
        cpl_kernel kernelType,
        double width,
        cpl_size kernelSize);

cpl_error_code eris_ifu_dar_gsl_shift(
        cpl_image *inImg,
        cpl_image *outImg,
        double xShift,
        double yShift,
        const gsl_interp2d_type *T);

void
eris_ifu_jitter_get_cube_type_string(cubeType type);

cpl_error_code
eris_frameset_duplicate_cube_tag(cpl_frameset* frameset, const char* pcatg, cpl_boolean apply_flat);
int
eris_frameset_count_tag(cpl_frameset * sof, const char*  tag);

cpl_error_code eris_ifu_update_wcs_with_OCS_keywords(
        struct sofStruct *sof);

#endif


