/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$:
 * $Date$:
 * $Rev$:
 */

/* 
 * This file defines methods useful for accessing catalogues.
 */

#ifndef ERIS_NIX_CATALOGUE_H
#define ERIS_NIX_CATALOGUE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "eris_nix_defs.h"

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code en_catalogue_conform_naming(cpl_frameset * frameset,
                                           const char * tag);

cpl_error_code en_catalogue_coverage(const located_imagelist * cal_jitters,
                                     double * ramin, double * ramax,
                                     double * decmin, double * decmax);


cpl_table * en_catalogue_load_from_file(const char * filename,
                                        const double ramin,
                                        const double ramax,
                                        const double decmin,
                                        const double decmax);

cpl_table * en_catalogue_load_from_frameset(cpl_frameset * frameset,
                                            const char * tag,
                                            const double ramin,
                                            const double ramax,
                                            const double decmin,
                                            const double decmax,
                                            cpl_frameset * used,
                                            const int required);

cpl_error_code en_catalogue_name_conformance(cpl_table * catalogue);

#endif /* ERIS_NIX_CATALOGUE_H */
