/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$
 * $Date$
 * $Rev$
 */

#ifndef ERIS_NIX_WAVECAL_UTILS_H
#define ERIS_NIX_WAVECAL_UTILS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "eris_nix_defs.h"
#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code enlu_divide_slit_response(located_imagelist * jitters);

cpl_error_code enlu_divide_slit_response_worker(hdrl_image * himage_2d,
                                                cpl_image * response_1d);

double enlu_linepos_1d(const cpl_vector * spectrum1d,
                       const double guess_pos,
                       const cpl_size half_width);

cpl_matrix * enlu_linepos_2d(const hdrl_image * spectrum2d,
                             const cpl_size slice_index,
                             const cpl_vector * guess_pos);

cpl_error_code enlu_trace_save(const char * pro_catg,
                               const hdrl_image * image,
                               const cpl_image * confidence,
                               const cpl_size ntraces,
                               const cpl_polynomial * traces[ntraces],
                               const cpl_size nspectra,
                               const cpl_vector * spectra[nspectra],
                               const cpl_size nlines,
                               const cpl_polynomial * lines[nlines],
                               cpl_frameset * frameset,
                               const cpl_parameterlist * parlist,
                               const char * filename,
                               const char * recipe_name);

cpl_polynomial * enlu_warp_poly_load_from_table(const cpl_table * poly_table);

cpl_table * enlu_warp_poly_save_to_table(const cpl_polynomial * polynomial);

#endif


