/* $Id: eris_pfits.h,v 1.11 2013-07-22 13:38:01 jtaylor Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2013-07-22 13:38:01 $
 * $Revision: 1.11 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ERIS_PFITS_H
#define ERIS_PFITS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

const char * eris_pfits_get_arcfile(const cpl_propertylist *);
double eris_pfits_get_dit(const cpl_propertylist *);
int eris_pfits_get_ndit(const cpl_propertylist * plist);
double eris_pfits_get_exptime(const char * filename);
int eris_pfits_get_naxis1(const cpl_propertylist * plist);
int eris_pfits_get_naxis2(const cpl_propertylist * plist);
double eris_pfits_get_crval3(const cpl_propertylist * plist);
double eris_pfits_get_cd33(const cpl_propertylist * plist);
double eris_pfits_get_cdelt3(const cpl_propertylist * plist);

cpl_error_code eris_ifu_plist_erase_wcs(cpl_propertylist* plist);
cpl_error_code
eris_pfits_erase_wcs2D(cpl_propertylist* applist);
cpl_error_code
eris_ifu_plist_erase_wcs3D(cpl_propertylist* applist);
cpl_propertylist* eris_ifu_plist_extract_wcs(cpl_propertylist* plist);
cpl_propertylist*
eris_ifu_plist_extract_wcs2D(const cpl_propertylist* applist);
cpl_propertylist*
eris_ifu_plist_extract_wcs3D(const cpl_propertylist* applist);
double eris_pfits_get_mjdobs(const cpl_propertylist *aHeaders);
long
eris_pfits_get_obsid(const cpl_propertylist *aHeaders);
const char *
eris_pfits_get_ancestor(const cpl_propertylist *aHeaders);
const char *
eris_pfits_get_progid(const cpl_propertylist *aHeaders);
double eris_pfits_get_airmass(const cpl_propertylist *aHeaders);
double eris_pfits_get_airmass_start(const cpl_propertylist *aHeaders);
double eris_pfits_get_airmass_end(const cpl_propertylist *aHeaders);
const char *
eris_pfits_get_raw_filename(const cpl_propertylist *aHeaders, unsigned int idx);
double
eris_pfits_get_ia_fwhmlin(const cpl_propertylist *aHeaders);
double eris_pfits_get_fwhm_start(const cpl_propertylist *aHeaders);
double eris_pfits_get_fwhm_end(const cpl_propertylist *aHeaders);
double eris_pfits_get_crpix1(const cpl_propertylist * plist);
double eris_pfits_get_crpix2(const cpl_propertylist * plist);
double eris_pfits_get_crpix3(const cpl_propertylist * plist);
const char* eris_pfits_get_pipefile(const cpl_propertylist *aHeaders);
const char* eris_pfits_get_datamd5(const cpl_propertylist *aHeaders);
cpl_error_code
eris_pfits_clean_header(cpl_propertylist *header, const cpl_boolean clean_extra);
cpl_error_code
eris_pfits_clean_header_ra_dec_mjd_obs(cpl_propertylist *header);
cpl_error_code
eris_pfits_clean_comment(cpl_propertylist *header);
cpl_error_code
eris_ifu_plist_erase_expmap_extra_keys(cpl_propertylist* applist);
#endif
