from edps import subworkflow, task, qc1calib, calchecker, ReportInput

from .eris_datasources import *
from .eris_task_function import set_persistence


@subworkflow("image_quality_spiffier", "")
def image_quality_spiffier(dark_ifu, distortion_ifu, flat_ifu, wave_ifu):
    # This subworkflow computes the PSF analysis and the strehl ratio for SPIFFIER observations.

    # Compute persistence correction.
    persistence_spiffier = (task('persistence_ifu')
                            .with_recipe('eris_persistence_monitor')
                            .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                            .with_main_input(raw_persistence_spiffier)
                            .with_associated_input(dark_ifu, [MASTER_DARK_IFU],
                                                   match_rules=match_dark_for_persistence)
                            .with_input_filter(MASTER_DARK_IFU, MASTER_DARK_IMG)
                            .with_job_processing(set_persistence)
                            .with_meta_targets([qc1calib])
                            .build())

    psf = (task('psf_ifu')
           .with_recipe('eris_ifu_stdstar')
           .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
           .with_report("eris_psf", ReportInput.RECIPE_INPUTS_OUTPUTS)
           .with_main_input(raw_psf)
           .with_associated_input(distortion_ifu, [DISTORTION])
           .with_associated_input(flat_ifu, [MASTER_FLAT_LAMP, BPM_FLAT])
           .with_associated_input(wave_ifu, [WAVE_MAP])
           .with_associated_input(oh_spectrum, min_ret=0)
           .with_input_filter(DISTORTION, MASTER_FLAT_LAMP, BPM_FLAT, WAVE_MAP)
           .with_meta_targets([qc1calib, calchecker])
           .build())

    strehl = (task('strehl_ifu')
              .with_recipe('eris_ifu_stdstar')
              .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
              .with_report("eris_psf", ReportInput.RECIPE_INPUTS_OUTPUTS)
              .with_main_input(raw_strehl)
              .with_associated_input(distortion_ifu, [DISTORTION])
              .with_associated_input(flat_ifu, [MASTER_FLAT_LAMP, BPM_FLAT])
              .with_associated_input(wave_ifu, [WAVE_MAP])
              .with_associated_input(oh_spectrum, min_ret=0)
              .with_input_filter(DISTORTION, MASTER_FLAT_LAMP, BPM_FLAT, WAVE_MAP)
              .with_meta_targets([qc1calib])
              .build())

    # Process PUPIL observations. Those observations need different association rules for the various calibrations.
    calib_for_pupil = (match_rules()
                       .with_match_keywords([kwd.seq_arm, kwd.ins3_spgw_name], time_range=ONE_MONTH, level=0)
                       .with_match_keywords([kwd.seq_arm, kwd.ins3_spgw_name], time_range=UNLIMITED, level=3))

    pupil_spiffier = (task('pupil_ifu')
                      .with_recipe('eris_ifu_pupil')
                      .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                      .with_main_input(raw_pupil_spiffier)
                      .with_associated_input(distortion_ifu, [DISTORTION], min_ret=1, match_rules=calib_for_pupil)
                      .with_associated_input(flat_ifu, [MASTER_FLAT_LAMP, BPM_FLAT], min_ret=1,
                                             match_rules=calib_for_pupil)
                      .with_associated_input(wave_ifu, [WAVE_MAP], min_ret=1, match_rules=calib_for_pupil)
                      .with_input_filter(DISTORTION, MASTER_FLAT_LAMP, BPM_FLAT, WAVE_MAP)
                      .with_associated_input(oh_spectrum, min_ret=0)
                      .with_associated_input(extcoeff_table, min_ret=0)
                      .with_meta_targets([qc1calib])
                      .build())

    return persistence_spiffier, psf, strehl, pupil_spiffier
