/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_DARK_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_DARK_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

cpl_error_code eris_ifu_dark_static(const cpl_parameterlist *parlist,
        hdrl_imagelist* darkImageList,
        hdrl_parameter* pdarkcollapse,
        hdrl_image **masterDarkHdrlImg,
        cpl_image  **qualityImage,
        cpl_image **masterBpm,
        cpl_image **contribMap,
        cpl_mask **bpm2dMask,
        cpl_mask **bpm3dMask,
        cpl_propertylist *qcParams);

cpl_image *eris_ifu_dark_noise(
		hdrl_imagelist* imageList);

cpl_error_code eris_ifu_dark_qc(const cpl_parameterlist *parlist,
        hdrl_image *masterDarkHdrlImg,
        hdrl_imagelist* darkImageList,
        const cpl_mask *masterBpm,
        const cpl_image *qualityImage,
        cpl_propertylist *qcParams);

cpl_image* eris_ifu_dark_get_dqi(
        const cpl_mask* masterBpmMask,
        const cpl_mask* bpm2dMask,
        const cpl_mask* bpm3dMask);

#endif /* ERISP_ERIS_ERIS_IFU_DARK_STATIC_H_ */
