/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$
 * $Date$
 * $Rev$
 */

#ifndef ERIS_NIX_MATCH_H
#define ERIS_NIX_MATCH_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "eris_nix_utils.h"

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code enm_associate_std(cpl_table * objtab,
                                 cpl_table * stdtab,
                                 const float srad,
                                 const int strict_classification,
                                 cpl_table ** associated_std);

cpl_error_code enm_correct_crpix(const char * wcs_method,
                                 const char * catalogue,
                                 cpl_table * matched_stds,
                                 located_image * limage,
                                 cpl_matrix ** xy_shift);

cpl_error_code enm_try_all_associations(cpl_table * objtab,
                                        cpl_table * stdtab,
                                        const double match_rad,
                                        cpl_table ** matchtab);

cpl_error_code enm_try_association(const double xstd[],
                                   const double ystd[],
                                   const cpl_size nstd,
                                   const double xobj[],
                                   const double yobj[],
                                   const cpl_size nobj,
                                   const cpl_size is,
                                   const cpl_size io,
                                   cpl_matrix ** distances);
#endif
