/* 
 *
 * This file is part of the KMOS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ERIS_IFU_SKY_TWEAK_H
#define ERIS_IFU_SKY_TWEAK_H

/*-----------------------------------------------------------------------------
 *                              Includes
 *----------------------------------------------------------------------------*/

#include <cpl.h>

/*------------------------------------------------------------------------------
 *                        Prototypes
 *----------------------------------------------------------------------------*/

cpl_imagelist * eris_ifu_sky_tweak(
        cpl_imagelist           *   obj,
        cpl_imagelist           *   sky,
        const cpl_propertylist  *   header,
        float                       min_frac,
        int                         tbsub,
        int                         skip_last,
        int                         stretch,
        int                         stretch_degree,
        int                         stretch_resampling,
        int                         plot,
        cpl_imagelist           **  new_sky) ;

int eris_ifu_plot_cube_background(cpl_imagelist * obj) ;

#endif
