/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2025 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERIS_NIX_IMG_SUPERSKY_H
#define ERIS_NIX_IMG_SUPERSKY_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

#define ERIS_NIX_IMG_SUPERSKY_RAW          "NIX_SCIENCE_REDUCED"
#define ERIS_NIX_IMG_SUPERSKY_BPM          "MASTER_BPM"
#define ERIS_NIX_IMG_SUPERSKY_SKYFLAT      "MASTER_SKYFLAT"
#define ERIS_NIX_IMG_SUPERSKY_SKYSUB       "SKYSUB_OBJECT_JITTER"

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code eris_nix_img_supersky_run(
    cpl_frameset            *   frameset,
    const cpl_parameterlist *   parlist,
	const char*                 rec_id,
    cpl_frameset            **  product_frames);

#endif /* ERIS_NIX_IMG_SUPERSKY_H */
