/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_SKYCORR_H_
#define ERISP_ERIS_ERIS_SKYCORR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

#include "eris_ifu_jitter_interface.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/



cpl_table* eris_ifu_skycorr_extract_spectrum(const hdrl_imagelist *cube,
                                      const cpl_propertylist *header,
                                      cpl_size x,
                                      cpl_size y);

cpl_table* eris_ifu_skycorr_create_nan_spectrum(const hdrl_imagelist *cube);

cpl_error_code eris_ifu_skycorr_insert_spectrum(hdrl_imagelist *cube,
                                        cpl_table *scspec,
                                        cpl_size x,
                                        cpl_size y);


cpl_error_code eris_ifu_skycorr_flatten_outliers(cpl_table *objspec,
                                                 cpl_table *skyspec,
                                                 int f);

cpl_error_code eris_ifu_skycorr_flatten_outliers2(cpl_table *objspec,
                                                 cpl_table *skyspec,
                                                 double min_frac);

cpl_parameterlist* eris_ifu_skycorr_create_parlist(const cpl_propertylist *sky_header);

#endif // ERIS_SKYCORR_H
