/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_DETLIN_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_DETLIN_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include <hdrl.h>
#define ERIS_QC_LIN_COEF_C  "Linearity coefficient value"
#define ERIS_QC_LIN_COEF_ERR_C   "Linearity coefficient error value"
cpl_error_code eris_ifu_detlin_load_frames(const cpl_frameset *frameset,
                                           int exposureCorrectionMode,
                                           hdrl_imagelist **hdrl_imglist_on,
                                           hdrl_imagelist **hdrl_imglist_off,
                                           cpl_vector **vec_dit_on,
                                           cpl_vector **vec_dit_off);

//cpl_table* eris_ifu_detlin_compute_linearity_old(
//                                        const hdrl_imagelist *hdrl_imglist_on,
//                                        const hdrl_imagelist *hdrl_imglist_off,
//                                        const cpl_vector *vec_dit);

cpl_image *eris_ifu_detlin_compute_linearity(const cpl_parameterlist *parlist,
                                             const hdrl_imagelist *imglist,
                                             const cpl_vector *vec_dit,
											 cpl_propertylist* qclog);

cpl_mask* eris_ifu_detlin_filter_mask(const cpl_mask *bpm,
                                      const cpl_parameterlist *parlist);

cpl_table* eris_compute_gain(cpl_frameset* frameset);
#endif /* ERISP_ERIS_ERIS_IFU_DETLIN_STATIC_H_ */
