/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_IFU_EFFICIENCY_RESPONSE_H_
#define ERISP_ERIS_IFU_EFFICIENCY_RESPONSE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>

int eris_can_compute_response(cpl_frameset* sof);

int eris_can_flux_calibrate(cpl_frameset* sof);

int eris_can_compute_efficiency(cpl_frameset* sof);

cpl_boolean eris_can_extract(cpl_frameset* sof);

cpl_table*
eris_efficiency_compute(cpl_frame* frm_sci, cpl_frame* frm_cat,
		cpl_frame* frm_atmext, cpl_frameset* frameset,
		const cpl_parameterlist* parlist, const char* recipe_name);

cpl_error_code
eris_response_compute(const char* plugin_id, const cpl_parameterlist* config,
		cpl_frameset* ref_set,cpl_frameset* sof);

cpl_error_code eris_ifu_efficiency_response(
		cpl_frameset            * frameset,
		const cpl_parameterlist * parlist,
		const char* recipe_name);

cpl_error_code
eris_flux_calibrate_spectra(const char* pipefile_prefix, const char* plugin_id,
		const cpl_parameterlist* config, cpl_frameset* ref_set,
		cpl_frameset* sof);

cpl_error_code
eris_flux_calibrate_cube( const char* procatg, const char* pipefile_prefix,
		const char* plugin_id, const cpl_parameterlist* config,
        /*cpl_frameset* ref_set, */cpl_frameset* sof);
cpl_error_code
eris_flux_calibrate_cube2(const char* procatg, const char* pipefile_prefix,
		const char* plugin_id, const cpl_parameterlist* parlist,
        /*cpl_frameset* ref_set, */cpl_frameset* sof);
#endif
