/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_FLAT_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_FLAT_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <eris_ifu_constants.h>
/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

typedef enum {
    FLAT_MODE_NONE,
    FLAT_MODE_SEGMENT,
    FLAT_MODE_HDRL,
    FLAT_MODE_FAST
} flatMode;

static const char * const flatModes[] = {
    "segment",
    "hdrl",
    "fast"
};

cpl_error_code eris_ifu_flat_static(cpl_frameset   *fs,
                    const cpl_parameterlist *parlist,
                    const flatMode          mode,
                    int                     productDepth,
                    const char              *procatg,
                    const char              *recipe_name,
                    const char              *procatg_prefix,
                    const char              *instrument,
                    cpl_propertylist        **qc_list,
                    hdrl_image              **masterFlatHdrlImg_lo,
                    cpl_image               **qualityImage);

double eris_ifu_getThreshold(hdrl_image *img);

int eris_ifu_matchRow(int blocksize, int rx);

cpl_error_code eris_ifu_calc_flat(const cpl_parameterlist *parlist,
                    const char              *recipe_name,
                    const flatMode          mode,
                    const hdrl_imagelist    *hdrl_imagelist_on,
                    const hdrl_imagelist    *hdrl_imagelist_off,
                    int                     productDepth,
					ifsBand                 band,
                    hdrl_image              **masterFlatHdrlImg_lo,
                    hdrl_image              **masterFlatHdrlImg_hi,
                    cpl_image               **contrib_map);

cpl_error_code eris_ifu_flat_load_frames(const cpl_frameset  *fs,
                    double                  *gain,
                    double                  *exptime,
                    hdrl_imagelist          **hdrlImgListOn,
                    hdrl_imagelist          **hdrlImgListOff);

int eris_ifu_get_qc_saturated(const hdrl_imagelist *dataHdrl);

cpl_error_code eris_ifu_flat_calc_qc_pre(
                    const cpl_parameterlist *parlist,
                    const char              *recipe_name,
                    const hdrl_imagelist    *hdrl_imglist_on,
                    const hdrl_imagelist    *hdrl_imglist_off,
                    cpl_propertylist        *qc_list);

cpl_error_code eris_ifu_flat_calc_qc_post(const cpl_parameterlist *parlist,
                    const char              *recipe_name,
                    const int               productDepth,
                    const char              *procatg_prefix,
                    const hdrl_image        *masterFlatHdrlImg_hi,
                    const hdrl_image        *masterFlatHdrlImg_lo,
                    const hdrl_imagelist    *hdrl_imglist_on,
                    const hdrl_imagelist    *hdrl_imglist_off,
                    const cpl_image         *contrib_map,
                    const cpl_mask          *bpm2dMask,
                    const cpl_mask          *bpm3dMask,
                    cpl_frameset            *fs,
                    cpl_propertylist        *qc_list,
                    cpl_image               **qualityImage);

cpl_error_code eris_ifu_column_tilt(hdrl_image *hdrl_img, double sigma);

cpl_error_code eris_ifu_flat_thresh_mask(hdrl_image *hdrl_img,
                                         double lo_cut,
                                         double hi_cut);

cpl_error_code eris_ifu_flat_pixel_qsort(double *pix_arr, int npix);

void eris_ifu_my_fit(double x[], double y[], int ndata, double sig[], int mwt,
                     double *a, double *b, double *siga, double *sigb,
                     double *chi2, double *q);

cpl_error_code eris_ifu_flat_stats_rectangle(const hdrl_image *hdrl_img,
                                             double    loReject,
                                             double    hiReject,
                                             int       llx,
                                             int       lly,
                                             int       urx,
                                             int       ury,
                                             double    *cleanmean,
                                             double    *cleanstdev);

cpl_error_code eris_ifu_flat_clean_mean(double *array,
                                        int    n_elements,
                                        double throwaway_low,
                                        double throwaway_high,
                                        double *cleanmean);

hdrl_image* eris_ifu_flat_median_image(const hdrl_image *hdrl_img_in,
                                       double fmedian);

cpl_error_code eris_ifu_sinfo_compare_images(const hdrl_image *hdrl_img1,
                                            const hdrl_image *hdrl_img2,
                                            hdrl_image *hdrl_img_orig);

cpl_error_code eris_ifu_flat_fast_bpm(hdrl_image *master_flat,
                                      const cpl_parameterlist *parlist,
                                      int productDepth);

/* ---- Data collector ---- */
struct structFlatData {
    int      blocksize;
    cpl_size cnt;
    cpl_vector  *ry,
                *borderAleft,
                *borderAright,
                *borderBleft,
                *borderBright,
                *borderCleft,
                *borderCright,
                *borderDleft,
                *borderDright;
};
void eris_ifu_free_structFlatData(struct structFlatData* sfd);
cpl_error_code eris_ifu_flat_data_init(struct structFlatData *self, int blocksize);

cpl_error_code eris_ifu_flat_data_setBorders(struct structFlatData *self, int ry,
                                             int leftEdgeA, int rightEdgeA,
                                             int leftEdgeB, int rightEdgeB,
                                             int leftEdgeC, int rightEdgeC,
                                             int leftEdgeD, int rightEdgeD);

cpl_vector* eris_ifu_flat_data_getBorderInterpolated(struct structFlatData *self,
                                                     int row);

#endif /* ERISP_ERIS_ERIS_IFU_FLAT_STATIC_H_ */
