/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set sw=2 sts=2 et cin: */
/*
 * This file is part of the MUSE Instrument Pipeline
 * Copyright (C) 2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef ERIS_IFU_SDP_H
#define ERIS_IFU_SDP_H

/*----------------------------------------------------------------------------*
 *                              Includes                                      *
 *----------------------------------------------------------------------------*/
#include <cpl.h>
#include <eris_ifu_sdp.h>
#include <eris_ifu_resample.h>
/*
#include <eris_ifu_processing.h>
#include <eris_ifu_datacube.h>
*/

/*----------------------------------------------------------------------------*
 *                              Defines                                       *
 *----------------------------------------------------------------------------*/

/* IDP unit strings */
static const char kMuseIdpFluxDataUnit[] = "10**(-20)erg.s**(-1).cm**(-2).angstrom**(-1)";
static const char kMuseIdpFluxStatUnit[] = "10**(-40)erg**2.s**(-2).cm**(-4).angstrom**(-2)";
static const char kMuseIdpWavelengthUnit[] = "angstrom";
static const char kErisIdpFluxDataUnit[] = "erg.s**(-1).cm**(-2).angstrom**(-1)";

/*----------------------------------------------------------------------------*
 *                           Data structures                                  *
 *----------------------------------------------------------------------------*/
/* JIRA-10635 comments/TODO
 *
 * 1. The primary header contains the WCS keywords, please remove them since the PHU doesn't contain data

2. Missing keywords:
PRODCATG = 'SCIENCE.CUBE.IFS' in the primary header
mandatory keyword OBSTECH is undefined.
mandatory keyword MJD-END is undefined.
mandatory keyword PROCSOFT is undefined.
mandatory keyword REFERENC is undefined.
mandatory keyword PROG_ID is undefined.
mandatory keyword FLUXCAL is undefined.
mandatory keyword PROV1 is undefined.
mandatory keyword ASSON1 is undefined, the white light image needs to be provided
mandatory keyword TEXPTIME is undefined.
mandatory keyword NCOMBINE is undefined.
mandatory keyword WAVELMIN is undefined.
mandatory keyword WAVELMAX is undefined.
mandatory keyword SPEC_RES is undefined.
mandatory keyword SPECSYS is undefined.
mandatory keyword OBID1 is undefined.
mandatory keyword PIXNOISE is undefined.
mandatory keyword SKY_RES is undefined.
mandatory keyword ABMAGLIM is undefined.
mandatory keyword ext:HDUCLASS is undefined in HDU0.
mandatory keyword ext:HDUCLASS is undefined in HDU1.
mandatory keyword ext:HDUCLASS is undefined in HDU2.
mandatory keyword ext:HDUDOC is undefined in HDU0.
mandatory keyword ext:HDUDOC is undefined in HDU1.
mandatory keyword ext:HDUDOC is undefined in HDU2.
mandatory keyword ext:HDUVERS is undefined in HDU0.
mandatory keyword ext:HDUVERS is undefined in HDU1.
mandatory keyword ext:HDUVERS is undefined in HDU2.
mandatory keyword ext:HDUCLAS1 is undefined in HDU0.
mandatory keyword ext:HDUCLAS1 is undefined in HDU1.
mandatory keyword ext:HDUCLAS1 is undefined in HDU2.

3. The keywords CDELT are not supported by the SDP standard. They are in every extension.

4. ORIGFILE must be recorded in the primary header, and not duplicated in any extension.

5. CUNIT3 = 'MICRON ' has a wrong value, in each extension, to be replaced with 'um'

6. CTYPE3 = 'WAVELENGTH' has a wrong value, in each extension, to be replaced with 'WAVE'
 *
 *
 */
// XXX: Should this just be implemented as a property list?
typedef struct eris_ifu_sdp_properties eris_ifu_sdp_properties;

struct eris_ifu_sdp_properties {
    unsigned int ncombine;
    double exptime;
    double texptime;
    double mjd_end;
    double fovcenter[2];
    double wlenrange[2]; /* WLENMIN/MAX ? */
    double wlerror;
    double specres;
    double skyrerr;
    double pixnoise;
    double abmaglimit;
    double skyres;
    cpl_array *obid;
    cpl_array *progid;
    cpl_propertylist *prov;  /* PROV1? */
    cpl_array *asson;
    cpl_array *assoc;     /* deprecated */
    cpl_array *assom;     /* deprecated */
    cpl_boolean fluxcal;
    cpl_size nobj;
    const char *prodcatg;
    const char *procsoft;
    const char *obstech;
    const char *referenc;
    const char *specsys;
};

/*----------------------------------------------------------------------------*
 *                           Function prototypes                              *
 *----------------------------------------------------------------------------*/

eris_ifu_sdp_properties *eris_ifu_sdp_properties_new(void);
void eris_ifu_sdp_properties_delete(eris_ifu_sdp_properties *aProperties);
eris_ifu_sdp_properties *eris_ifu_sdp_properties_collect(hdrl_resample_result *aCube,
		cpl_frameset* set, const cpl_parameterlist* parlist, const char* recipe_name);
cpl_error_code eris_ifu_sdp_properties_update(cpl_propertylist *aHeader,
                                          const eris_ifu_sdp_properties *aProperties);

/*
eris_ifu_idp_properties *eris_ifu_idp_properties_collect(eris_ifu_processing *aProcessing,
                                                 const eris_ifu_datacube *aCube,
                                                 const char *aTag);
cpl_error_code eris_ifu_idp_properties_update(cpl_propertylist *aHeader,
                                          const eris_ifu_idp_properties *aProperties);
cpl_error_code eris_ifu_idp_properties_update_fov(eris_ifu_image *fov);
*/


#endif /* ERIS_IFU_SDP_H */
