/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$:
 * $Date$:
 * $Rev$:
 */

#ifndef ERIS_NIX_DEFS_H
#define ERIS_NIX_DEFS_H

#include <hdrl.h>

#define CASU_2MASS_PSC 1
#define CASU_USNOB     2
#define CASU_PPMXL     3
#define CASU_LANDOLT   4
#define CASU_WISE      5
#define CASU_APASS     6

#define ERIS_NIX_SATURATION_DEFAULT         5000.0

CPL_BEGIN_DECLS

typedef struct {
    hdrl_image            * himage;    //Current jitter image result if not a cube
    hdrl_imagelist        * himagelist; //Cube planes if the data is a cube
    cpl_image             * confidence; //Confidence array associated with the image
    hdrl_image            * bkg;        //Sky background subtracted from the image
    cpl_image             * bkg_confidence; //Confidence array associated with the sky background
    cpl_propertylist      * plist;    //Propertylist associated with the image
    hdrl_catalogue_result * objects;  //Objects catalogued in the image
    cpl_mask              * object_mask; //The object mask derived from the catalogued objects
    hdrl_catalogue_result * matchstd_wcs; //Catalogue of objects matched with wcs standards
    hdrl_catalogue_result * matchstd_phot; // Catalogue of objects matched with photometric standards
    cpl_frame             * frame; //CPL frame of original image
} located_image;

typedef struct {
    located_image ** limages;
    cpl_size         size;
} located_imagelist;

#define ERIS_NIX_MEF_MASK     1
#define ERIS_NIX_MEF_IMAGE    2

typedef struct {
    char                  * name;
    void                  * data;
    const char            * data_type;
    cpl_propertylist      * plist;
} mef_extension;

typedef struct {
    mef_extension ** mef;
    cpl_size         size;
} mef_extension_list;

CPL_END_DECLS

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

#define enu_check_error_code(...) \
  cpl_error_ensure(cpl_error_get_code()==CPL_ERROR_NONE,\
                   cpl_error_get_code(), goto cleanup, __VA_ARGS__)

#define enu_check(BOOL, CODE, ...) \
  cpl_error_ensure(BOOL, CODE, goto cleanup, __VA_ARGS__)


#endif /* ERIS_NIX_DEFS_H */


