/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$
 * $Date$
 * $Rev$
 */

#ifndef ERIS_NIX_DETECTOR_H
#define ERIS_NIX_DETECTOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "eris_nix_gain_linearity.h"
#include "eris_nix_master_dark.h"
#include "eris_nix_utils.h"
#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

#define LINEARIZE_MAXITER 5

/*-----------------------------------------------------------------------------
                                   Declarations
 -----------------------------------------------------------------------------*/

typedef struct {
    cpl_size            nr;
    cpl_image        ** samples;
} eris_nix_samples;

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

eris_nix_samples * end_calculate_samples(const cpl_image * start_intensity,
                                         const cpl_image * ramp_intensity,
                                         cpl_size nr,
                                         const double dit,
                                         const cpl_image * f);

void end_samples_delete(eris_nix_samples * samples);

cpl_error_code end_linearize_and_variance(const gain_linearity * gain_linearity,
                                          const master_dark * master_dark,
                                          located_imagelist * limlist,
                                          cpl_size x_probe,
                                          cpl_size y_probe);

hdrl_image *
end_linearize_and_variance_detmon(const gain_linearity * gain_linearity,
                                  const master_dark * master_dark,
                                  const hdrl_image * himage,
                                  const cpl_propertylist * plist,
                                  const cpl_size x_probe,
                                  const cpl_size y_probe)
    CPL_ATTR_ALLOC;

cpl_error_code end_linearize_image(cpl_image * data,
                                   const gain_linearity * gain_linearity,
                                   const cpl_size rot,
                                   const cpl_size strx,
                                   const cpl_size stry,
                                   const cpl_size x_probe,
                                   const cpl_size y_probe);

cpl_image * end_uptheramp_reduce(eris_nix_samples * samples, 
                                 const double dit);

cpl_image * end_vacca_linearize_cds(cpl_image * intensity,
                                    const gain_linearity * gain_linearity,
                                    const double dit,
                                    const cpl_size nr,
                                    const cpl_image * f,
                                    cpl_size rot,
                                    cpl_size strx,
                                    cpl_size stry,
                                    cpl_size x_probe,
                                    cpl_size y_probe);

cpl_image * end_vacca_linearize_ramp(cpl_image * intensity,
                                     const gain_linearity * gain_linearity,
                                     const double dit,
                                     const cpl_size nr,
                                     const cpl_image * f,
                                     const cpl_size rot,
                                     const cpl_size strx,
                                     const cpl_size stry,
                                     const cpl_size x_probe,
                                     const cpl_size y_probe);

double engl_lin_correct(const double,
                        const cpl_size,
                        const double *,
                        const cpl_binary,
                        const double,
                        cpl_binary *, 
                        cpl_binary *, 
                        const int);

double engl_lin_find(const double,
                     double,
                     double,
                     const cpl_size,
                     const double *);

#endif
