/* $Id: eris_dfs.h,v 1.14 2013-07-22 13:38:01 jtaylor Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2013-07-22 13:38:01 $
 * $Revision: 1.14 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ERIS_NIX_SCIRED_H
#define ERIS_NIX_SCIRED_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code
eris_nix_scired_cal_det(cpl_frameset * frameset,
		const cpl_parameterlist * parlist,
		const char* recipe_name,
		const char* context);

cpl_error_code
eris_nix_scired_skysub(cpl_frameset * frameset,
		const cpl_parameterlist * parlist,
		const char* recipe_name,
		const char* context);

cpl_error_code
eris_nix_scired_cal_wcs(cpl_frameset * frameset,
		const cpl_parameterlist * parlist,
		const char* recipe_name,
		const char* context);

cpl_error_code
eris_nix_scired_cal_phot(cpl_frameset * frameset,
		const cpl_parameterlist * parlist,
		const char* recipe_name,
		const char* context);


cpl_error_code
eris_nix_scired_hdrl_stack(cpl_frameset * frameset,
		const cpl_parameterlist * parlist,
		const char* recipe_name,
		const char* context);

/* recipe parameters definition functions */
cpl_error_code
eris_nix_pixel_coord_diagnostic_param_set(const char* context,
		cpl_parameterlist* parlist);

cpl_error_code
eris_nix_skysub_param_set(const char* context,
		cpl_parameterlist* parlist);

cpl_error_code
eris_nix_catalogue_param_set(const char* context,
		cpl_parameterlist* parlist,
		int obj_min_pixels, double obj_threshold, cpl_boolean obj_deblending,
		double obj_core_radius, cpl_boolean bkg_estimate, int bkg_mesh_size,
		double bkg_smooth_fwhm, double det_eff_gain, double det_saturation,
		hdrl_catalogue_options resulttype);

cpl_error_code
eris_nix_astrometric_param_set(const char* context,
		cpl_parameterlist* parlist);

cpl_error_code
eris_nix_photom_param_set(const char* context,
		cpl_parameterlist* parlist);

cpl_error_code
eris_nix_hdrl_stack_param_set(const char* context,
		cpl_parameterlist* parlist);
#endif
