from edps import subworkflow, task, qc1calib, calchecker, ReportInput

from .eris_datasources import *
from .eris_task_function import (
    set_persistence,
    is_nix_slow, is_nix_fast, is_pupil_nix_lamp,
    is_JHK_short, is_LM_short, is_long, is_long_bra,
    which_mode, which_speed, which_band,
    which_nxcw, which_nxfw, which_pupil
)


@subworkflow("image_quality_nix", "")
def image_quality_nix(dark_nix, linearity_nix, nix_flat_lamp, nix_flat_twilight, nix_flat_sky):
    # Compute persistence correction.
    persistence_nix = (task('persistence_nix')
                       .with_recipe('eris_persistence_monitor')
                       .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                       .with_dynamic_parameter("which_mode", which_mode)
                       .with_dynamic_parameter("which_speed", which_speed)
                       .with_main_input(raw_persistence_nix)
                       .with_associated_input(dark_nix, [MASTER_DARK_IMG], condition=is_nix_slow,
                                              match_rules=match_nix_dark_persistence_slow)
                       .with_associated_input(dark_nix, [MASTER_DARK_IMG], condition=is_nix_fast,
                                              match_rules=match_nix_dark_persistence_fast)
                       .with_input_filter(MASTER_DARK_IFU, MASTER_DARK_IMG)
                       .with_job_processing(set_persistence)
                       .with_meta_targets([qc1calib])
                       .build())

    # --- Reduce NIX pupil frames ----------------------------------------------------------------------
    # There are special conditions and rules when attaching twilight and lamp flats.

    match_LM_short = (match_rules()
                      .with_match_function(rules.is_assoc_flat_to_LM_short_dit, time_range=ONE_DAY, level=-1)
                      .with_match_function(rules.is_assoc_flat_to_LM_short, time_range=ONE_DAY, level=0)
                      .with_match_function(rules.is_assoc_flat_to_LM_short, time_range=UNLIMITED, level=3))

    pupil_nix = (task('pupil_nix')
                 .with_recipe('eris_nix_pupil')
                 .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                 .with_main_input(raw_pupil_nix)
                 .with_associated_input(raw_pupil_nix_background, min_ret=0, max_ret=100, condition=is_pupil_nix_lamp)
                 .with_associated_input(linearity_nix, [GAIN_INFO, COEFFS_CUBE, BP_MAP_NL])
                 .with_associated_input(dark_nix, [MASTER_DARK_IMG])
                 .with_dynamic_parameter("band_used", which_band)
                 .with_dynamic_parameter("NXCW", which_nxcw)
                 .with_dynamic_parameter("NXFW", which_nxfw)
                 .with_dynamic_parameter("which_pupil", which_pupil)
                 .with_dynamic_parameter("which_mode", which_mode)
                 .with_associated_input(nix_flat_twilight, [MASTER_FLAT_TWILIGHT_LOFREQ], condition=is_JHK_short)
                 .with_associated_input(nix_flat_lamp,
                                        [MASTER_FLAT_LAMP_HIFREQ, MASTER_FLAT_LAMP_LOFREQ, MASTER_BPM_LAMP],
                                        min_ret=1, condition=is_JHK_short)
                 .with_associated_input(nix_flat_twilight, [MASTER_FLAT_TWILIGHT_LOFREQ], condition=is_LM_short,
                                        match_rules=match_LM_short)
                 .with_associated_input(nix_flat_lamp,
                                        [MASTER_FLAT_LAMP_HIFREQ, MASTER_FLAT_LAMP_LOFREQ, MASTER_BPM_LAMP],
                                        min_ret=1, condition=is_LM_short, match_rules=match_LM_short)
                 .with_associated_input(nix_flat_sky,
                                        [MASTER_FLAT_SKY_HIFREQ, MASTER_SKY_LOFREQ, MASTER_BPM_SKY],
                                        min_ret=1, condition=is_long, match_rules=match_nix_skyflat)
                 .with_associated_input(nix_flat_sky,
                                        [MASTER_FLAT_SKY_HIFREQ, MASTER_SKY_LOFREQ, MASTER_BPM_SKY],
                                        min_ret=1, condition=is_long_bra, match_rules=match_skyflat_long_bra)
                 .with_input_filter(GAIN_INFO, COEFFS_CUBE, BP_MAP_NL, MASTER_FLAT_LAMP_HIFREQ, MASTER_FLAT_LAMP_LOFREQ,
                                    MASTER_BPM_LAMP, MASTER_DARK_IMG, MASTER_FLAT_TWILIGHT_LOFREQ,
                                    MASTER_FLAT_SKY_HIFREQ, MASTER_SKY_LOFREQ, MASTER_BPM_SKY)
                 .with_associated_input(nix_wcs_matched_catalogue)
                 .with_associated_input(nix_wcs_refine)
                 .with_meta_targets([qc1calib, calchecker])
                 .build())

    pupil_monitor_nix = (task('pupil_monitor_nix')
                         .with_recipe('eris_nix_pupil_monitor')
                         .with_main_input(pupil_nix)
                         .with_associated_input(nix_pupil_reference)
                         .with_associated_input(nix_sam_info, min_ret=0)
                         .with_meta_targets([qc1calib])
                         .build())

    return persistence_nix, pupil_nix, pupil_monitor_nix
