from edps import subworkflow, task, qc1calib, calchecker, ReportInput

from .eris_datasources import *


@subworkflow("flat_nix", "")
def compute_flats_nix(linearity_nix, nix_dark):
    nix_flat_lamp = (task('flat_lamp_nix')
                     .with_recipe('eris_nix_flat_lamp')
                     .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                     .with_report("eris_img_flat", ReportInput.RECIPE_INPUTS_OUTPUTS)
                     .with_main_input(raw_lamp_flat_nix)
                     .with_associated_input(linearity_nix, [GAIN_INFO, COEFFS_CUBE,
                                                            BP_MAP_NL])
                     .with_associated_input(nix_dark, [MASTER_DARK_IMG])
                     .with_meta_targets([qc1calib, calchecker])
                     .build())

    nix_flat_twilight = (task('flat_twilight_nix')
                         .with_recipe('eris_nix_flat_twilight')
                         .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                         .with_report("eris_img_flat", ReportInput.RECIPE_INPUTS_OUTPUTS)
                         .with_main_input(raw_twilight_flat)
                         .with_associated_input(linearity_nix, [GAIN_INFO, COEFFS_CUBE,
                                                                BP_MAP_NL])
                         .with_associated_input(nix_dark, [MASTER_DARK_IMG])
                         .with_associated_input(nix_flat_lamp, [MASTER_BPM_LAMP])
                         .with_meta_targets([qc1calib, calchecker])
                         .build())

    nix_flat_sky = (task('flat_sky_nix')
                    .with_recipe('eris_nix_flat_sky')
                    .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                    .with_report("eris_img_flat", ReportInput.RECIPE_INPUTS_OUTPUTS)
                    .with_main_input(raw_sky_flat)
                    .with_associated_input(linearity_nix, [GAIN_INFO, COEFFS_CUBE,
                                                           BP_MAP_NL])
                    .with_associated_input(nix_dark, [MASTER_DARK_IMG])
                    .with_meta_targets([qc1calib, calchecker])
                    .build())

    # nix_flat_sky_lss = (task('flat_sky_lss')
    #                    .with_recipe('eris_nix_flat_sky')
    #                    .with_main_input(raw_sky_flat_lss)
    #                    .with_associated_input(linearity_nix, [GAIN_INFO, COEFFS_CUBE,
    #                                                           BP_MAP_NL])
    #                    .with_associated_input(nix_dark, [MASTER_DARK_IMG])
    #                    .with_meta_targets([qc1calib])
    #                    .build())

    return nix_flat_lamp, nix_flat_twilight, nix_flat_sky  # , nix_flat_sky_lss
