from edps import qc0, qc1calib, idp, calchecker

from .eris_datasources import *
from .eris_image_quality_nix import image_quality_nix
from .eris_nix_detector_calibration import detector_calibration
from .eris_nix_flat import compute_flats_nix
from .eris_nix_process_science import nix_science_reduction, nix_on_sky_calibrations_reduction

# ---------------- PROCESSING TASKS -----------------
__title__ = "ERIS NIX workflow"

# subworkflow to compute linearity correction and dark current level
linearity_nix, dark_nix = detector_calibration()

# Processes lamp flats for NIX observations
# nix_flat_lamp, nix_flat_twilight, nix_flat_sky, nix_flat_sky_lss = compute_flats_nix(linearity_nix, dark_nix)
nix_flat_lamp, nix_flat_twilight, nix_flat_sky = compute_flats_nix(linearity_nix, dark_nix)

persistence_nix, pupil_nix, pupil_monitor_nix = image_quality_nix(dark_nix, linearity_nix, nix_flat_lamp,
                                                                  nix_flat_twilight, nix_flat_sky)

# --- Reduction of NIX science exposures -----------------------------------------------------------
# Coronography.
coronagraphy = nix_science_reduction(raw_coronagraphy, linearity_nix, dark_nix, nix_flat_lamp, nix_flat_twilight,
                                     nix_flat_sky, 'coronagraphy', 'science', [qc0, calchecker])
# Sparse aperture mask (SAM)
sparse_aperture_mask = nix_science_reduction(raw_sam, linearity_nix, dark_nix, nix_flat_lamp, nix_flat_twilight,
                                             nix_flat_sky, 'sam', 'science', [qc0, calchecker])
# Cubes
cube_reduced = nix_science_reduction(raw_object_nix_ifu, linearity_nix, dark_nix, nix_flat_lamp, nix_flat_twilight,
                                     nix_flat_sky, 'cube', 'science', [qc0, calchecker])

# Long slit
long_slit_reduction = nix_science_reduction(raw_object_nix_lss, linearity_nix, dark_nix, nix_flat_lamp,
                                            nix_flat_twilight, nix_flat_sky, 'long_slit', 'science', [qc0, calchecker])
long_slit_nix = long_slit_reduction.science_reduction
long_skit_sky_subtraction = long_slit_reduction.sky_subtraction
long_slit_astrometry = long_slit_reduction.astrometry
long_slit_reduced = long_slit_reduction.photometry

# Images
image_reduction = nix_science_reduction(raw_object_nix_image, linearity_nix, dark_nix, nix_flat_lamp, nix_flat_twilight,
                                        nix_flat_sky, 'images', 'science', [qc0, idp, calchecker])
image_nix = image_reduction.science_reduction
image_subtraction = image_reduction.sky_subtraction
image_astrometry = image_reduction.astrometry
image_photometry = image_reduction.photometry
image_reduced = image_reduction.stacking

# --- Reduction of NIX on-sky calibrations (standard_star and astrometry exposures) -------------------------
# images
calib_image_reduction = nix_on_sky_calibrations_reduction(raw_on_sky_calib_nix_image, linearity_nix, dark_nix,
                                                          nix_flat_lamp, nix_flat_twilight, nix_flat_sky, 'images',
                                                          'on_sky_calib', [qc1calib, calchecker])
calib_image_subtraction = calib_image_reduction.sky_subtraction
calib_image_astrometry = calib_image_reduction.astrometry
calib_image_photometry = calib_image_reduction.photometry
calib_image_reduced = calib_image_reduction.stacking
# cubes
calib_cube_reduction = nix_on_sky_calibrations_reduction(raw_on_sky_calib_nix_cube, linearity_nix, dark_nix,
                                                         nix_flat_lamp, nix_flat_twilight, nix_flat_sky, 'cube',
                                                         'on_sky_calib', [qc1calib, calchecker])

# lss
calib_long_slit_reduction = nix_on_sky_calibrations_reduction(raw_on_sky_calib_nix_lss, linearity_nix, dark_nix,
                                                              nix_flat_lamp, nix_flat_twilight, nix_flat_sky,
                                                              'long_slit', 'on_sky_calib', [qc1calib, calchecker])
calib_long_slit_nix = calib_long_slit_reduction.science_reduction
calib_long_skit_sky_subtraction = calib_long_slit_reduction.sky_subtraction
calib_long_slit_astrometry = calib_long_slit_reduction.astrometry
calib_long_slit_reduced = calib_long_slit_reduction.photometry
