from edps import match

from . import eris_keywords as kwd


def is_calib(f):
    return f[kwd.dpr_catg] == "CALIB" and f[kwd.instrume] == "ERIS"


def is_science(f):
    return f[kwd.dpr_catg] == "SCIENCE" and f[kwd.instrume] == "ERIS"


def is_image(f):
    return f[kwd.dpr_tech] == "IMAGE"


def is_ifu(f):
    return "IFU" in f[kwd.dpr_tech]


def is_image_pt(f):
    return f[kwd.dpr_tech] == "IMAGE,PT"


def is_obj_psf(f):
    return is_calib(f) and f[kwd.seq_arm] == "SPIFFIER" and f[kwd.dpr_tech] == "IFU,NODDING" and \
        f[kwd.tpl_nexp] >= 1 and \
        (f[kwd.dpr_type] == "PSF-CALIBRATOR" or (
                f[kwd.dpr_type] == "OBJECT" and f[kwd.tpl_id] == "ERIS_ifs_cal_PSF")) and \
        f[kwd.obs_prog_id] != "60.A-9277(A)"


def is_sky_psf(f):
    return is_calib(f) and f[kwd.seq_arm] == "SPIFFIER" and f[kwd.dpr_tech] == "IFU,NODDING" and \
        f[kwd.tpl_nexp] >= 1 and \
        (f[kwd.dpr_type] == "SKY,PSF-CALIBRATOR" or (
                f[kwd.dpr_type] == "SKY" and f[kwd.tpl_id] == "ERIS_ifs_cal_PSF")) and \
        f[kwd.obs_prog_id] != "60.A-9277(A)"


def is_obj_strehl(f):
    return is_calib(f) and f[kwd.seq_arm] == "SPIFFIER" and f[kwd.dpr_tech] == "IFU,NODDING" and \
        f[kwd.tpl_nexp] >= 1 and \
        (f[kwd.dpr_type] == "PSF-CALIBRATOR" or (
                f[kwd.dpr_type] == "OBJECT" and f[kwd.tpl_id] == "ERIS_ifs_cal_PSF")) and \
        f[kwd.obs_prog_id] == "60.A-9277(A)"


def is_sky_strehl(f):
    return is_calib(f) and f[kwd.seq_arm] == "SPIFFIER" and f[kwd.dpr_tech] == "IFU,NODDING" and \
        f[kwd.tpl_nexp] >= 1 and \
        (f[kwd.dpr_type] == "SKY,PSF-CALIBRATOR" or (
                f[kwd.dpr_type] == "SKY" and f[kwd.tpl_id] == "ERIS_ifs_cal_PSF")) and \
        f[kwd.obs_prog_id] == "60.A-9277(A)"


def is_short_narrow(f):
    return f[kwd.seq_arm] == "NIX" and f[kwd.ins2_nxfw_name] not in ["L-Broad", "Mp", "Short-Lp", "Lp", "Br-a",
                                                                     "Br-a-cont", "J", "H", "Ks"]


def is_long(f):
    return f[kwd.ins2_nxfw_name] in ["Br-a", "Br-a-cont", "L-Broad", "Mp", "Short-Lp", "Lp", "Br-g"]


def is_short_broad(f):
    return f[kwd.seq_arm] == "NIX" and f[kwd.ins2_nxfw_name] in ["J", "H", "Ks"]


def is_nix_std_image(f):
    return is_calib(f) and is_image(f) and f[kwd.dpr_type] in ["STD", "OBJECT"] and \
        f[kwd.det_fram_format] == 'single'


def is_nix_sky_image(f):
    c1 = ((is_calib(f) and f[kwd.dpr_type] == "SKY,STD") or (is_science(f) and f[kwd.dpr_type] == "SKY"))
    return c1 and (is_image(f) or is_image_pt(f)) and f[kwd.det_fram_format] == 'single'


def is_nix_std_cube(f):
    return is_calib(f) and is_image(f) and f[kwd.dpr_type] in ["STD", "OBJECT"] and \
        f[kwd.det_fram_format] == 'cube'


def is_nix_sky_cube(f):
    c1 = ((is_calib(f) and f[kwd.dpr_type] == "SKY,STD") or (is_science(f) and f[kwd.dpr_type] == "SKY"))
    return c1 and (is_image(f) or is_image_pt(f)) and f[kwd.det_fram_format] == 'cube'


def is_std_jitter_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and is_nix_std_image(f)


def is_std_astrometry_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and is_calib(f) and is_image(f) and f[kwd.dpr_type] == "ASTROMETRY"


def is_sky_jitter_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and is_nix_sky_image(f)


def is_sky_astrometry_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and is_calib(f) and is_image(f) and f[
        kwd.dpr_type] == "SKY,ASTROMETRY"


def is_std_astrometry_long(f):
    return is_long(f) and is_calib(f) and is_image(f) and f[kwd.dpr_type] == "ASTROMETRY"


def is_sky_jitter_long(f):
    return is_long(f) and is_nix_sky_image(f)


def is_sky_astrometry_long(f):
    return is_long(f) and is_calib(f) and is_image(f) and f[kwd.dpr_type] == "SKY,ASTROMETRY"


def is_std_cube_jitter_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and is_nix_std_cube(f)


def is_std_cube_astrometry_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and f[kwd.dpr_type] == "ASTROMETRY" and f[
        kwd.det_fram_format] == 'cube'


def is_sky_cube_jitter_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and is_nix_sky_cube(f)


def is_sky_cube_astrometry_short(f):
    return (is_short_narrow(f) or is_short_broad(f)) and f[kwd.dpr_type] == "SKY,ASTROMETRY" and f[
        kwd.det_fram_format] == 'cube'


def is_std_cube_jitter_long(f):
    return is_long(f) and is_nix_std_cube(f)


def is_std_cube_astrometry_long(f):
    return is_long(f) and f[kwd.dpr_type] == "ASTROMETRY" and f[kwd.det_fram_format] == 'cube'


def is_sky_cube_jitter_long(f):
    return is_long(f) and is_nix_sky_cube(f)


def is_sky_cube_astrometry_long(f):
    return is_long(f) and f[kwd.dpr_type] == "SKY,ASTROMETRY" and f[kwd.det_fram_format] == 'cube'


def is_persistence_spiffier(f):
    return f[kwd.dpr_type] == "PERSISTENCE" and f[kwd.seq_arm] == "SPIFFIER"


def is_persistence_spiffier_calib(f):
    c1 = is_persistence_spiffier(f) and (is_image(f) or is_ifu(f))
    c2 = is_calib(f) or (f[kwd.dpr_catg] == "TECHNICAL" and f[kwd.obs_prog_id] == "60.A-9277(A)")
    return c1 and c2


def is_persistence_spiffier_science(f):
    c1 = is_persistence_spiffier(f) and is_image(f)
    c2 = is_science(f) or (f[kwd.dpr_catg] == "TECHNICAL" and f[kwd.obs_prog_id] != "60.A-9277(A)")
    return c1 and c2


# ASSOCIATION RULES
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)


def is_assoc_ref_line_arc(ref, f):
    return match(ref, f, [kwd.instrume]) and f[kwd.drs_id] == "SPIFFIER"


def is_assoc_spiffier_dark_persistence(ref, f):
    return match(ref, f, [kwd.det_read_curname, kwd.seq_arm]) and f[kwd.det_ndit] == 1 and \
        1.644 < f[kwd.det_seq1_dit] < 1.645


def is_assoc_spiffier_dark_flat(ref, f):
    return match(ref, f, [kwd.det_read_curname, kwd.seq_arm]) and f[kwd.det_ndit] == 1 and \
        9.9 < f[kwd.det_seq1_dit] < 10.1


def is_assoc_twflat_dit(ref, f):
    c1 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c2 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c3 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm, kwd.det_seq1_dit]) and (c1 or c2 or c3)


def is_assoc_twflat(ref, f):
    c1 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c2 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c3 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm]) and (c1 or c2 or c3)


def is_assoc_twflat_short_dit(ref, f):
    c1 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c2 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c3 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm, kwd.det_seq1_dit]) and (c1 or c2 or c3)


def is_assoc_twflat_short(ref, f):
    c1 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c2 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c3 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm]) and (c1 or c2 or c3)


def is_assoc_twflat_short_broad_dit(ref, f):
    c1 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c2 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c3 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm, kwd.ins2_nxfw_name, kwd.det_seq1_dit]) and (c1 or c2 or c3)


def is_assoc_twflat_short_broad(ref, f):
    c1 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c2 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c3 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm]) and (c1 or c2 or c3)


def is_assoc_flat_to_LM_short(ref, f):
    # General criterion:
    c1 = f[kwd.ins2_nxcw_name] == "13mas-JHK"

    # Match skyflat:
    c2 = match(ref, f, [kwd.seq_arm, kwd.ins2_nxfw_name, kwd.det_read_curname])
    c3 = (f[kwd.dpr_type] in ["FLAT,LAMP", "FLAT,DARK"]) or (
            "MASTER_FLAT_LAMP" in f[kwd.pro_catg] or "MASTER_BPM_LAMP" in f[kwd.pro_catg])

    # match twilight flat:
    c4 = ref[kwd.ins2_nxfw_name] == "Pa-b" and f[kwd.ins2_nxfw_name] == "J"
    c5 = ref[kwd.ins2_nxfw_name] == "Fe-II" and f[kwd.ins2_nxfw_name] == "H"
    c6 = ref[kwd.ins2_nxfw_name] not in ["Pa-b", "Fe-II"] and f[kwd.ins2_nxfw_name] == "Ks"
    c7 = match(ref, f, kwd.seq_arm)
    c8 = (f[kwd.dpr_type] in ["FLAT,TWILIGHT", "FLAT,TWLIGHT"]) or ("MASTER_FLAT_TWILIGHT" in f[kwd.pro_catg])

    return (c1 and c2 and c3) or (c1 and c7 and c8 and (c4 or c5 or c6))


def is_assoc_flat_to_LM_short_dit(ref, f):
    return is_assoc_flat_to_LM_short(ref, f) and match(ref, f, kwd.det_seq1_dit)


def match_long_bra(ref, f):
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm]) and \
        f[kwd.ins2_nxfw_name] == "Lp" and f[kwd.dpr_tech] not in ["IMAGE,APP", "CORONAGRAPHY,APP"]


def match_long_bra_dit(ref, f):
    return match_long_bra(ref, f) and match(ref, f, [kwd.det_seq1_dit])


def match_coronography_flat(ref, f):
    return match(ref, f, [kwd.ins2_nxcw_name, kwd.seq_arm, kwd.det_seq1_dit]) and \
        f[kwd.dpr_tech] in ["IMAGE,APP", "CORONAGRAPHY,APP"]


def match_nix_skyflat(ref, f):
    match_nix = [kwd.seq_arm, kwd.ins2_nxfw_name, kwd.ins2_nxcw_name]
    return match(ref, f, match_nix) and f[kwd.dpr_tech] not in ["IMAGE,APP", "CORONAGRAPHY,APP"] and f[
        kwd.ins1_mode] != "nixLSS"


def match_nix_skyflat_dit(ref, f):
    return match_nix_skyflat(ref, f) and match(ref, f, [kwd.det_seq1_dit])


def match_nix_lss_flat(ref, f):
    return match(ref, f, [kwd.seq_arm]) and f[kwd.ins2_nxfw_name] == "L-Broad"


def match_nix_lss_flat_nocurname(ref, f):
    return match(ref, f, [kwd.seq_arm]) and f[kwd.ins2_nxfw_name] == "L-Broad"


def match_nix_lss_flat_dit(ref, f):
    return match_nix_lss_flat(ref, f) and match(ref, f, [kwd.det_seq1_dit])


def is_assoc_flux_standard_same_night(ref, f):
    c1 = "J" in ref[kwd.ins3_spgw_name] and f[kwd.ins3_spgw_name] == "J_low"
    c2 = "H" in ref[kwd.ins3_spgw_name] and f[kwd.ins3_spgw_name] == "H_low"
    c3 = "K" in ref[kwd.ins3_spgw_name] and f[kwd.ins3_spgw_name] == "K_low"
    return f[kwd.night] == ref[kwd.night] and (c1 or c2 or c3)


def is_assoc_flux_standard(ref, f):
    c1 = "J" in ref[kwd.ins3_spgw_name] and f[kwd.ins3_spgw_name] == "J_low"
    c2 = "H" in ref[kwd.ins3_spgw_name] and f[kwd.ins3_spgw_name] == "H_low"
    c3 = "K" in ref[kwd.ins3_spgw_name] and f[kwd.ins3_spgw_name] == "K_low"
    return c1 or c2 or c3


def is_assoc_nix_dark(ref, f):
    c1 = match(ref, f, [kwd.det_seq1_dit, kwd.det_read_curname, kwd.det_seq1_win_name, kwd.seq_arm])
    c2 = ref[kwd.det_fram_format] == "single" and match(ref, f, [kwd.det_ndit])
    c3 = ref[kwd.det_fram_format] == "cube" and f[kwd.det_ndit] == 1
    return c1 and (c2 or c3)


def is_assoc_nix_dark_persistence_fast(ref, f):
    c1 = match(ref, f, [kwd.seq_arm, kwd.det_read_curname]) and f[kwd.det_seq1_win_name] == "windowF" and \
         f[kwd.det_ndit] == 1
    c2 = 0.0335 <= f[kwd.det_seq1_dit] <= 0.0336
    return c1 and c2


def is_assoc_nix_dark_persistence_slow(ref, f):
    c1 = match(ref, f, [kwd.seq_arm, kwd.det_read_curname]) and f[kwd.det_seq1_win_name] == "windowF" and \
         f[kwd.det_ndit] == 1
    c2 = 1.969 <= f[kwd.det_seq1_dit] <= 1.97
    return c1 and c2


def is_assoc_wavelength_windows(ref, f):
    c1 = f[kwd.ins3_spgw_id] == "J_low" and "J" in ref[kwd.ins3_spgw_id]
    c2 = f[kwd.ins3_spgw_id] == "H_low" and "H" in ref[kwd.ins3_spgw_id]
    c3 = f[kwd.ins3_spgw_id] == "K_low" and "K" in ref[kwd.ins3_spgw_id]
    return c1 or c2 or c3
