/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2020-07-01 15:13:41 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_CTE_H
#define ESPDR_CTE_H

/*----------------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------------*/

/* Utility fonctions */
#include <math.h>

/* DRL functions*/
#include <espdr_sigma_clipping.h>
#include <espdr_dfs.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_instrument.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_keywords.h>

/* Library */
#include <cpl.h>
#include <assert.h>

/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

#define SAVE_DEBUG_PRODUCT_CTE 0

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_cte_compute(const cpl_imagelist *input_iml,
                                 double *RON,
                                 const espdr_CCD_geometry *CCD_geom,
                                 espdr_inst_config *inst_config,
                                 cpl_imagelist *cte_iml_RE);

cpl_error_code espdr_cte_one_output(const cpl_image *input_image,
                                    double RON,
                                    int ext_no,
                                    int out_x,
                                    int out_y,
                                    const espdr_CCD_geometry *CCD_geom,
                                    espdr_inst_config *inst_config,
                                    cpl_image *cte_image_RE);

#endif /* ESPDR_CTE_H */
