/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2014-10-28 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_FLAT_H
#define ESPDR_FLAT_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_keywords.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_orders.h>
#include <espdr_detector_signature.h>

/* Library */
#include <cpl.h>
#include <assert.h>

/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define SAVE_DEBUG_PRODUCT_FLAT 1
#define SAVE_DEBUG_CCD_CLEANED_FLAT 0

#define POLY_DEG_MIN 1
#define POLY_DEG_MAX 5
#define SLIDE_BOX_MIN 100
#define SLIDE_BOX_MAX 256
#define CLIP_FACTOR_MIN 1.0
#define CLIP_FACTOR_MAX 10.0


/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_mflat(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_FLAT_create(const char* recipe_id,
                                            cpl_parameterlist *list,
                                            espdr_FLAT_param *p);

cpl_error_code espdr_parameters_FLAT_delete(espdr_FLAT_param* p);

cpl_error_code espdr_parameters_FLAT_get(const char* recipe_id, 
                                         cpl_parameterlist* list,
                                         espdr_FLAT_param *FLAT_param);

cpl_error_code espdr_parameters_FLAT_print(espdr_FLAT_param *FLAT_param);

espdr_FLAT_param *espdr_FLAT_param_init(const char *recipe_id,
                                        cpl_parameterlist *parameters);

cpl_error_code espdr_process_flat(cpl_frameset *frameset,
                                  espdr_CCD_geometry *CCD_geom,
                                  espdr_inst_config *inst_config,
                                  int **physical_orders_id,
                                  cpl_frameset *used_frames,
                                  int remove_bias_res,
                                  char *bkgr_sw,
                                  cpl_parameterlist *parameters);

cpl_error_code espdr_check_flat_saturation(cpl_frameset *flat_frames,
                                           espdr_CCD_geometry *CCD_geom,
                                           espdr_inst_config *inst_config,
                                           cpl_propertylist *keywords,
                                           cpl_imagelist *pixels_mask,
                                           double *max_flux,
                                           cpl_imagelist **sat_mask_RE);

cpl_error_code espdr_get_master_flat(cpl_frameset *flat_frames,
                                     cpl_imagelist *master_dark_iml,
                                     cpl_imagelist *orders_mask_iml,
                                     espdr_CCD_geometry *CCD_geom,
                                     espdr_inst_config *inst_config,
                                     cpl_propertylist *keywords,
                                     cpl_propertylist *keywords_HP,
                                     cpl_propertylist *keywords_BP,
                                     espdr_qc_keywords *qc_kws,
                                     int remove_bias_res,
                                     double *GAIN_FLAT,
                                     double *DARK_FLAT,
                                     double *DARK_RON_FLAT,
                                     double *RON_FLAT,
                                     cpl_imagelist **master_flat_RE);

cpl_error_code espdr_compute_flat_rel_error(cpl_image *extracted_spectrum_table,
                                            cpl_image *spectrum_error_table,
                                            cpl_image *spectrum_error_relative);

cpl_error_code espdr_flat_QC(espdr_CCD_geometry *CCD_geom,
                             espdr_inst_config *inst_config,
                             espdr_qc_keywords *qc_kws,
                             int nset,
                             double *max_flux,
                             cpl_imagelist *bkgr_measured,
                             int *cosmics_nb,
                             int orders_nb,
                             cpl_image *extracted_spectrum_table,
                             cpl_image *spectrum_error_table,
                             cpl_image *flat_spectrum,
                             cpl_propertylist **keywords_RE);

#endif /* ESPDR_FLAT_H */
