/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2021-08-25 15:13:41 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_PREPROCESSING_H
#define ESPDR_PREPROCESSING_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_background.h>

/* Library */
#include <cpl.h>
#include <assert.h>
#include <math.h>

/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define SAVE_DEBUG_PRODUCT_PREPROCESSING 0

#define BOX_SIZE 128
#define MEDIAN_WINDOW 7
#define NEGATIVE_PXL_LIMIT -1000.0

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_preprocess(const cpl_frameset *raw_frameset,
                                const cpl_imagelist *flat_mask_iml,
                                espdr_CCD_geometry *CCD_geom,
                                espdr_inst_config *inst_config,
                                cpl_frameset **preprocessed_set);

cpl_error_code espdr_preprocess_iml(cpl_imagelist *raw_iml,
                                    const cpl_imagelist *flat_mask_iml,
                                    const espdr_CCD_geometry *CCD_geom,
                                    espdr_inst_config *inst_config,
                                    double exposure_time,
                                    double conad,
                                    cpl_imagelist **preprocessed_iml);

cpl_error_code espdr_preprocess_img(cpl_image *raw_img,
                                    const cpl_image *flat_mask_img,
                                    cpl_propertylist *keywords,
                                    const espdr_CCD_geometry *CCD_geom,
                                    espdr_inst_config *inst_config,
                                    double *ron_RE,
                                    double *conad_RE,
                                    cpl_image **preprocessed_img);

cpl_error_code espdr_top_bottom_correction(cpl_image *img,
                                           int ppscan_ny,
                                           int poscan_ny);

cpl_error_code espdr_left_right_correction(cpl_image *img,
                                           int pscan_nx,
                                           int oscan_nx);

cpl_error_code espdr_xtalk(cpl_image *img,
                           const cpl_image *mask_img,
                           espdr_inst_config *inst_config);

cpl_error_code espdr_corr_amp(cpl_image *img);

cpl_error_code espdr_update_bad_pixel_mask(cpl_frameset *raw_frameset,
                                           espdr_CCD_geometry *CCD_geom,
                                           cpl_image *mask);

cpl_error_code espdr_remove_nans(cpl_image *img);

double espdr_get_median_off_nans(double *data, int data_size);

cpl_error_code espdr_get_running_median_off_nans(cpl_vector *input_vector,
                                                 int median_window,
                                                 cpl_vector *median_vector);

cpl_error_code espdr_measure_background_prep(const cpl_image *input_image,
                                             const int bkgr_grid_size_x,
                                             const int bkgr_grid_size_y,
                                             cpl_image **image_background_measured_RE,
                                             cpl_image **image_background_substracted_RE);
#endif /* ESPDR_PREPROCESSING_H */
