/* $Id: espdr_bp_detect-test.c,v 1.2 2013-07-26 11:44:44 amodigli Exp $
 *
 * This file is part of the ESPDR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2013-07-26 11:44:44 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include <cpl.h>
#include <math.h>
#include <espdr_sigma_clipping.h>
#include <espdr_pixels.h>
#include <espdr_utils.h>
/*----------------------------------------------------------------------------*/
/**
 * @defgroup espdr_bp_verify_test count false positive and negatives
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/


cpl_error_code
test_bp_verify(int argc, char* argv[])
{

    const char* r_name=NULL;
    const char* c_name=NULL;
    cpl_image* r_image=NULL;
    cpl_image* c_image=NULL;
    cpl_image* d_image=NULL;
    cpl_image* o_image=NULL;
    double* pr;
    double* pc;
    //double* pd;
    double* po;
    char o_name[256];
    const char* f_name;

    int r_nx, r_ny;
    int c_nx, c_ny;
    int i, size;
    espdr_msg_debug("argc=%d",argc);
    if((size_t)argc!=3){
       return cpl_error_get_code();
    }

    r_name=argv[1];
    c_name=argv[2];
    espdr_msg_debug("r_name=%s",r_name);
    espdr_msg_debug("c_name=%s",c_name);

    r_image=cpl_image_load(r_name,CPL_TYPE_DOUBLE,0,0);
    c_image=cpl_image_load(c_name,CPL_TYPE_DOUBLE,0,0);

    r_nx=cpl_image_get_size_x(r_image);
    r_ny=cpl_image_get_size_y(r_image);

    c_nx=cpl_image_get_size_x(c_image);
    c_ny=cpl_image_get_size_y(c_image);
    espdr_msg_debug("r_nx=%d r_ny=%d",r_nx,r_ny);
    espdr_msg_debug("c_nx=%d c_ny=%d",c_nx,c_ny);
    espdr_ensure(c_nx != r_nx, CPL_ERROR_ILLEGAL_INPUT,"Illegal input");
    espdr_ensure(c_ny != r_ny, CPL_ERROR_ILLEGAL_INPUT,"Illegal input");

    o_image=cpl_image_duplicate(r_image);
    cpl_image_multiply_scalar(o_image,0);
    cpl_image_add_scalar(o_image,3);

    d_image=cpl_image_duplicate(r_image);
    cpl_image_subtract(d_image,c_image);

    pr=cpl_image_get_data_double(r_image);
    //pd=cpl_image_get_data_double(d_image);
    pc=cpl_image_get_data_double(c_image);
    po=cpl_image_get_data_double(o_image);

    f_name=espdr_get_basename(r_name);
    size=r_nx*r_ny;
    espdr_msg_debug("ok1");
    sprintf(o_name,"dif_%s",f_name);
    //cpl_image_save(d_image,o_name,CPL_TYPE_FLOAT,NULL,CPL_IO_CREATE);
    sprintf(o_name,"ref_%s",f_name);
    //cpl_image_save(r_image,o_name,CPL_TYPE_FLOAT,NULL,CPL_IO_CREATE);
    for(i=0;i<size;i++) {
               if (pc[i]==0 && pr[i]==0) {
            po[i]=0; // no bp no flag
        } else if (pc[i]>0 && pr[i]>0) {
            po[i]=1; // bp, flagged
        } else if (pc[i]>0 && pr[i]==0) {
            po[i]=2; //false positive
        } else if (pc[i]==0 && pr[i]>0) {
            po[i]=-1;//false negative
        }
    }
    espdr_msg_debug("ok4");

    sprintf(o_name,"ver_%s",f_name);
    //cpl_image_save(o_image,o_name,CPL_TYPE_FLOAT,NULL,CPL_IO_CREATE);

    espdr_msg_debug("ok5");
    cpl_image_delete(r_image);
    cpl_image_delete(d_image);
    cpl_image_delete(c_image);
    cpl_image_delete(o_image);
    espdr_msg_debug("ok6");
    return cpl_error_get_code();
}

/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of espdr_bp_detect module
 */
/*----------------------------------------------------------------------------*/

int main(int argc, char* argv[])
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);
    test_bp_verify(argc,argv);

    return cpl_test_end(0);
}

/**@}*/
