/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/


#include <stdio.h>
#include "bepop.h"

int main ( void )
{
  /* pointer to a derived type containing the parameters of the model */
  typeParamBEPOP * ptrBEPOP = NULL ; /* must be initialized at NULL */
  /* Arguments for the BEPOP_compute routine */
  double RightAscension,Declinaison,ProperMotionRightAscension,ProperMotionDeclinaison;
  int year, month, day, hour, minute ;
  double second;
  double TimeToMidExposure ;
  double StationLongitude, StationLatitude, StationAltitude ;
  typeOutBEPOP resBEPOP ; /* structure containing the output of BEPOP_compute routine */


  /* Allocates memory for a typeParamBEPOP object */
  ptrBEPOP=BEPOP_initAllocate(ptrBEPOP);

  /* initializes the ephemeris */
  BEPOP_initEphemeris("./data/ephemerides/inpop13c_TDB_m100_p100_tt.dat",        /* file */
                      2,                          /* method to switch between TT and TDB */
                      ptrBEPOP);
  /* Initializes the Earth Orientation Parameters */
  BEPOP_initEOP("./data/eop/eopc04_IAU2000.62-now.20161125",
                 6,                           /* degree for the lagrangian interpolation */
                 7,              /* =4+2+1, all EOP's corrections are taken into account */
                 ptrBEPOP);
  /* Defines the ellipsoid */
  BEPOP_initEllipsoid(1, ptrBEPOP); /*1: WGS80 ellipsoid */

  /* Defines the model for the Celestial Intermediate Pole */
  BEPOP_initCIPmodel("CIP/2006/2006A", ptrBEPOP) ;

  /* checks if all fields of ptrBEPOP are correctly initialized */
  BEPOP_checkInit(ptrBEPOP) ;


  /* Initialize input arguments */
    /* Star coordinates */
    RightAscension = 6.31 ;              /* in decimal hour */
    Declinaison = 20.4 ;                 /* in degree */
    ProperMotionRightAscension = 0.001 ; /* in arscecond/year */
    ProperMotionDeclinaison = 0.003 ;    /* in arscecond/year */
    /* Date and time of observation */
    year = 2007 ; month = 5 ; day = 17 ;
    hour = 23 ; minute = 41 ; second = 43.66 ;
    TimeToMidExposure = 600.0 ;
    /* Coordinates of the station */
    StationLongitude = 10.0 ;            /* in degree */
    StationLatitude = 41.5 ;             /* in degree */
    StationAltitude = 2300.4 ;           /* in meters */

  /* Computes the quantities used for the radial velocities data reductions */
  BEPOP_compute( RightAscension, Declinaison,                       /* source coordinates */
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second,           /*   date and time    */
                 TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,/* station position   */
                 ptrBEPOP,                                          /*  model parameters  */
                 &resBEPOP);                                        /*     results        */
  /* Prints some results */
  printf("Barycentric Earth Radial Velocity (in km/s)          : %10.6f\n",resBEPOP.BERV) ;
  printf("Barycentric Time of Light Arrival, in julian day TDB : %20.12f\n",resBEPOP.BTLA) ;

  /* Change the arguments, for another target, date, ... */
  printf("After change of some arguments:\n") ;
    RightAscension = 7.28 ;               /* in decimal hour */
    Declinaison = 30.8 ;                  /* in degree */
    ProperMotionRightAscension = -0.001 ; /* in arscecond/year */
    ProperMotionDeclinaison = 0.005 ;     /* in arscecond/year */
    /* Date and time of observation */
    year = 2009 ; month = 2 ; day = 20 ;
    hour = 14 ; minute = 50 ; second = 25.00 ;
    TimeToMidExposure = 500.0 ;
    /* Coordinates of the station */
    StationLongitude = -60.7 ;           /* in degree */
    StationLatitude = 30.8 ;             /* in degree */
    StationAltitude = 800.4 ;            /* in meters */

  /* Computes the quantities used for the radial velocities data reductions */
  BEPOP_compute( RightAscension, Declinaison,
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second, TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,
                 ptrBEPOP, &resBEPOP);
  printf("Barycentric Earth Radial Velocity (in km/s)          : %10.6f\n",resBEPOP.BERV) ;


  /* Change the method to switch between TT and TDB */
  BEPOP_initMethodTTTDB(0, ptrBEPOP); /* no TT-TDB differences */
  printf("After change of the method to compute TT-TDB::\n") ;
  BEPOP_compute( RightAscension, Declinaison,
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second, TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,
                 ptrBEPOP, &resBEPOP);
  printf("Barycentric Earth Radial Velocity (in km/s)          : %10.6f\n",resBEPOP.BERV) ;

  /* Change the ephemeris */
  BEPOP_initEphemeris("./data/ephemerides/inpop10b_TDB_m100_p100_littleendian.dat", /* file */
                      1,                   /* method to switch between TT and TDB */
                      ptrBEPOP);
  printf("After change of the ephemeris:\n") ;
  BEPOP_compute( RightAscension, Declinaison,
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second, TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,
                 ptrBEPOP, &resBEPOP);
  printf("Barycentric Earth Radial Velocity (in km/s)          : %10.6f\n",resBEPOP.BERV) ;

  /* Change of the CIP model */
  BEPOP_initCIPmodel("CIP/2000/2000B", ptrBEPOP) ;
  printf("After change of the CIP model:\n") ;
  BEPOP_compute( RightAscension, Declinaison,
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second, TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,
                 ptrBEPOP, &resBEPOP);
  printf("Barycentric Earth Radial Velocity (in km/s)          : %10.6f\n",resBEPOP.BERV) ;


  /* Change of the Earth Orientation Parameters */
  BEPOP_initEOP("",                       /* when no file is available or not up to date */
                 6,                           /* degree for the lagrangian interpolation */
                 0,                       /* no EOP taken into account */
                 ptrBEPOP);
  printf("After change of the EOP's:\n") ;
  BEPOP_compute( RightAscension, Declinaison,
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second, TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,
                 ptrBEPOP, &resBEPOP);
  printf("Barycentric Earth Radial Velocity (in km/s)          : %10.6f\n",resBEPOP.BERV) ;






  /* close the pointer and free memory */
  ptrBEPOP=BEPOP_close(ptrBEPOP) ;
  return (0);
}

