# import the needed modules
from __future__ import absolute_import
from __future__ import print_function
try:
  import reflex
  import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")


# import the needed modules
try:
#  import sys
  import numpy
  try:
    from astropy.io import fits as pyfits
  except ImportError:
    import pyfits
    
  import espdr_plot_common
  import espdr_parameters_common
#  import wx
#  import matplotlib
  import reflex
  #from xsh_plot_common import *
  from reflex import parseSofJson,RecipeParameter
  from reflex_interactive_app import PipelineInteractiveApp
  import reflex_plot_widgets

  from pipeline_product import PipelineProduct
  from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay
#  matplotlib.use('WXAgg')
  import_sucess = 'true'
  import warnings
  warnings.simplefilter('ignore',UserWarning)

#NOTE for developers: 
# -If you want to modify the current script to cope
#  with different parameters, this is the function to modify:
#  setInteractiveParameters()
# -If you want to modify the current script to read different data from
#  the input FITS, these are the functions (class DataPlotterManager) to modify:
#  readFitsData()    to indicate what are the FITS input to plot
#  plotTable()       to control 1D table product layout
#  oplotTable()      to control 1D table product overplots
#  setRecId()        to set rec id (used in parameter prefix)
#  getArmId()        to get arm id FITS header info
#
# -If you want to modify the current script to modify the plots (using the same
#  data),  this is the function to modify:
#  plotProductsGraphics()          (from class DataPlotterManager)
# -If you want to modify the text that appears in the "Help" button,
#  this is the function to modify:
#  setWindowHelp()
# -If you want to modify the title of the window, modify this function:
#  setWindowTitle()


  #This class deals with the specific details of data reading and final plotting.
  class DataPlotterManager:

    # This function will read all the columns, images and whatever is needed
    # from the products. The variables , self.plot_x, self.plot_y, etc...
    # are used later in function plotProductsGraphics().
    # Add/delete these variables as you need (only that plotProductsGraphics()
    # has to use the same names).
    # You can also create some additional variables (like statistics) after
    # reading the files.
    # If you use a control variable (self.xxx_found), you can modify 
    # later on the layout of the plotting window based on the presence of 
    # given input files. 
    # sof contains all the set of frames


    def readFitsData(self, fitsFiles):
      #Control variable to check if the interesting files where at the input
      #print fitsFiles
      
      self.led_ff_found = False
      self.nima = 0
      self.binx = 1
      self.biny = 1
      self.arm_id=0
      self.qc_id='BAD_PIXEL_MASK'
      self.ext_ima=1
      
      self.product_id = 'BAD_PIXEL_MASK'
      self.labels_prod=['BAD_PIXEL_MASK']
      self.labels_qc=['CONAD']
      self.labels_arm=['BLUE','RED']
      #Read all the products
      frames = dict()
      for frame in fitsFiles:
        if frame == '' :
          continue

        header = pyfits.open(frame.name)
        #Make sure to have only products from the same recipe
        #that used this (common) script 
        if 'ESO PRO REC1 ID' in header[0].header :
           rec_id = header[0].header['ESO PRO REC1 ID']
           #print "rec_id=", rec_id
           if rec_id == self.rec_id :
              category = frame.category
              frames[category] = frame
              #print("frame name:", frame.name)

# For any arm search a list of input frames
      #print frames
      key = "BAD_PIXEL_MASK"
      if key in frames :
        self.led_ff_found = True
        hdulist = frames[key]
        self.led_ff = PipelineProduct(hdulist)
        #print("found", key)
        self.rop = list()
        self.conad = list()
        key = 'INSTRUME'
        instrume = self.led_ff.readKeyword(key)
        if instrume == 'ESPRESSO':
          x_max = 8
          y_max = 2
        else:
          x_max = 0
          y_max = 0
        port = 0
        for x in range (0, x_max):
             for y in range (0, y_max):
                 key = 'ESO QC EXT%#.1d ROX%#.1d ROY%#.1d CONAD'% (self.arm_id,x,y) 
                 self.rop.append(port)
                 port = port+1
                 self.conad.append(self.led_ff.readKeyword(key))
        key = 'ESO QC LEDFF CHECK'
        self.qc_ledff_check =  self.led_ff.readKeyword(key)   

    #Set rec id (to have proper recipe parameters prefix)
    def setRecId(self, rec_id):
      #Recipe ID variable to properly define params
      self.rec_id = rec_id

    #Get arm setting
    def getArmId(self, sof):
      #Recipe ID variable to properly define params
      self.rec_id = "espdr_led_ff"
      nf = 0

      frames = dict()
      files = sof.files
      for f in files:
        frame=f.name
        if frame == '' :
          continue
        else :
           nf += 1
           hdulist = pyfits.open(frame)
           rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
      if nf != 0 :
         self.rec_id = rec_id_list[0:]

      if self.rec_id == "espdr_led_ff" :
         self.rec_subtitle = "Linearity Computation. "
            
    # This function creates all the subplots. It is responsible for the plotting 
    # layouts. 
    # There can different layouts, depending on the availability of data
    # Note that subplot(I,J,K) means the Kth plot in a IxJ grid 
    # Note also that the last one is actually a box with text, no graphs.
    def addSubplots(self, figure):
      nrows=self.nima
      row=1;

      if self.led_ff_found == True : 
        self.subplot_image  = figure.add_subplot(2,1,1)
        self.subplot_scatter  = figure.add_subplot(2,1,2)
        row +=1
        #self.product_selector = figure.add_axes([0.05, 0.93, 0.23, 0.07],aspect='equal')
        self.arm_selector = figure.add_axes([0.85, 0.93, 0.20, 0.07],aspect='equal')
        #self.qc_selector = figure.add_axes([0.05, 0.43, 0.16, 0.07],aspect='equal')

      else : 
        self.subtext_nodata    = figure.add_subplot(1,1,1)

    def plotWidgets(self) :
        widgets = list()

        #labels_prod = self.labels_prod
        #self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector, self.setProductSelectCallBack, labels_prod, 0, title="")
        #widgets.append(self.radiobutton_pro)

        labels_arm = self.labels_arm
        self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.arm_selector, self.setArmSelectCallBack, labels_arm, 0, title="")
        widgets.append(self.radiobutton_pro)

        #labels_qc = self.labels_qc
        #self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.qc_selector, self.setQCSelectCallBack, labels_qc, 0, title="")
        #widgets.append(self.radiobutton_pro)

        return widgets

    def setArmSelectCallBack(self, arm_id) :
        if arm_id == 'RED':
           self.arm_id = 2
           self.ext_ima = 2
        else :
           self.arm_id = 1
           self.ext_ima = 1
        self.displayProducts()
        self.plotQC()
        
    def setQCSelectCallBack(self, qc_id) :
        self.qc_id = qc_id
        #print("qc_id:", qc_id)
        self.subplot_scatter.cla()
        self.plotQC()

    def setProductSelectCallBack(self, product_id) :
        #print("Selected product id:", product_id)
        self.product_id = product_id
        self.subplot_image.cla()
        self.displayProducts()
        #print("product_id:", self.product_id)

    def preparePlotQC(self) :
        x = self.rop
        xLab = 'Read Out Port Number'
        if self.qc_id == 'BAD_PIXEL_MASK' :
          y = self.conad 
          yLab = 'CONAD [e-/ADU]'
          title = 'CONAD vs Read Out Port Number'
          tooltip = 'plot of CONAD vs Read Out Port Number'
        self.title=title
        self.tooltip=tooltip
        
        self.x=x
        self.y=y
        self.xLab=xLab
        self.yLab=yLab

    def prepTitleAndTooltipImage(self) :
        title_pref = 'Linear-extracted and Merged Spectrum.'          

        tooltip_spectrum ="""\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """
        title_spectrum   = title_pref

        #Image
        spec_frameON   = ''
        #print "Recipe ID:",self.rec_id
   
        if self.rec_id == "espdr_led_ff" :
           if self.arm_id == 0 :
              spec_frame   = 'Bad Pixel '
           else :
              spec_frame   = 'dark residuals '

           tooltip_frameON ="""\
           Dark corrected fibre dark lamp 
           image. 
           """

           tooltip_spectrum ="""\
           Spectrum corresponding to Dark corrected fibre dark lamp image.
           Select on the slider above to choose the order to display. 
           """

        self.title_frame   = spec_frame+'Image'
        self.dpm.verify_qc_check(self.subplot_image, self.qc_ledff_check,1.1)
    
        self.title_led_ff   = 'Linearaity frame'
        self.tooltip_led_ff ="""\
                Image of the bad pixel mask. Bad pixels are flagged as a red hue
                (note that the BLUE detector has very few bad pixels: you may 
                 need to know where they are and zoom in)"""
        if self.product_id == 'BAD_PIXEL_MASK' :
           self.obj = self.led_ff

        
 
    def setPlotSpectrum(self,obj,qual) :
        self.plotImageSlice(obj,qual,self.subplot_spectrum,title,tooltip,Xlab,Ylab);


    def plotImageOnly(self,obj,ext_ima,binx,biny,Xlab,Ylab,subplot,title,tooltip,cmap=None):
          img_disp = ImageDisplay()
          img_disp.cmap=cmap
          self.dpm.prepImage(img_disp,obj,ext_ima,Xlab,Ylab)
          img_disp.z_lim = 8000, 9000
          img_disp.display(subplot, title, self.dpm.paragraph(tooltip),obj.image,obj.image)


    def plotImageBP(self) :
        cmap =matplotlib.pyplot.cm.gray_r
        self.plotImageOnly(self.obj,self.ext_ima, self.binx,self.biny,'X [pix]', 'Y [pix]', self.subplot_image,self.title_frame,self.tooltip_led_ff,cmap)
    def plotQC(self) :
        if len(self.x) > 0 :
           self.dpm.scatterPlotScatter3(self.subplot_scatter,self.x,self.y,self.xLab, self.yLab, self.title, self.tooltip,1)

    def displayProducts(self):

        if self.product_id == 'BAD_PIXEL_MASK' : 
           self.plotImageBP()


    def caseNodata(self) :
        #Data not found info
        self.subtext_nodata.set_axis_off()
        self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, DARK, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
        self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c', 
                                 fontsize=18, ha='left', va='center', alpha=1.0)
        self.subtext_nodata.tooltip="""\
                                    Merged spectrum not found in the products"""
        #print "found no spectrum data"
 
      
    # This is the function that makes the plots.
    # Add new plots or delete them using the given scheme.
    # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
    # It is mandatory to add a tooltip variable to each subplot.
    # One might be tempted to merge addSubplots() and plotProductsGraphics().
    # There is a reason not to do it: addSubplots() is called only once at
    # startup, while plotProductsGraphics() is called always there is a resize.
    def plotProductsGraphics(self):
      if (self.led_ff_found == True) :
        self.dpm = espdr_plot_common.DataPlotterManager()
        self.prepTitleAndTooltipImage() 
        self.preparePlotQC()
        self.displayProducts()
        self.plotQC()
      else :
        self.caseNodata()
        
    # This function specifies which are the parameters that should be presented
    # in the window to be edited.
    # Note that the parameter has to be also in the in_sop port (otherwise it 
    # won't appear in the window) 
    # The descriptions are used to show a tooltip. They should match one to one
    # with the parameter list 
    # Note also that parameters have to be prefixed by the 'recipe name:'

    def setInteractiveParameters(self):
      paramList = list()
      rec_id=self.rec_id
      self.par = espdr_parameters_common.Parameters()

      if rec_id == "espdr_led_ff" :
        self.par.setLedFFParameters(paramList,"espdr_led_ff","all")
 
      else :
         print("recipe" ,rec_id,  "not supported")

      return paramList

    def setWindowHelp(self):
      help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
      return help_text

    def setWindowTitle(self):
      title = 'ESPRESSO Interactive Workflow: ' + self.rec_subtitle  
      return title

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")
  raise

#This is the 'main' function
if __name__ == '__main__':

  # import reflex modules
  from reflex import *
  from reflex_interactive_app import *
  from pipeline_display import *
  from pipeline_product import *

  # Create interactive application
  interactive_app = PipelineInteractiveApp(enable_init_sop=True)

  # PECULIAR XSH needs this in order to be able later to get from an input FITS
  # the ins-mode, arm (and recipe) IDs, used in titles and param setting
  # get inputs from the command line
  interactive_app.parse_args()
  inputs = interactive_app.inputs
  #(inputs, args) = interactive_app.parse_args()

  #Check if import failed or not
  #print("import_sucess=", import_sucess)
  if import_sucess == 'false' :
     interactive_app.setEnableGUI(false)
    
  #interactive_app.setEnableGUI(True)
  #Open the interactive window if enabled
  if interactive_app.isGUIEnabled() :
    #Get the specific functions for this window
    dataPlotManager = DataPlotterManager()
    #print inputs.in_sof
    #dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
    #With the following call XSH get the: ins-mode, arm (and recipe) IDs
    dataPlotManager.getArmId(inputs.in_sof)
    #Set recipe ID in order to build proper param list, display layout
    dataPlotManager.setRecId("espdr_led_ff")
    interactive_app.setPlotManager(dataPlotManager)
    interactive_app.showGUI()
  
  else :
    interactive_app.passProductsThrough()
   
  #Print outputs. This is parsed by the Reflex python actor to get the results
  #Do not remove
  interactive_app.print_outputs()
  sys.exit()
