# import the needed modules
from __future__ import absolute_import
from __future__ import print_function
try:
  import reflex
  import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")


# import the needed modules
try:
#  import sys
  import numpy

  try:
    from astropy.io import fits as pyfits
  except ImportError:
    import pyfits
  
  import espdr_parameters_common
#  import wx
#  import matplotlib
  import reflex
  #from xsh_plot_common import *
  from reflex import parseSofJson,RecipeParameter
  from reflex_interactive_app import PipelineInteractiveApp
  import reflex_plot_widgets
  from pipeline_product import PipelineProduct
  from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay
#  matplotlib.use('WXAgg')
  import_sucess = 'true'
  import warnings
  warnings.simplefilter('ignore',UserWarning)

#NOTE for developers: 
# -If you want to modify the current script to cope
#  with different parameters, this is the function to modify:
#  setInteractiveParameters()
# -If you want to modify the current script to read different data from
#  the input FITS, these are the functions (class DataPlotterManager) to modify:
#  readFitsData()    to indicate what are the FITS input to plot
#  plotSpectrum()    to control 1D image product layout
#  plotImage()       to control 2D image product layout
#  plotTable()       to control 1D table product layout
#  oplotTable()      to control 1D table product overplots
#  setRecId()        to set rec id (used in parameter prefix)
#  getArmId()        to get arm id FITS header info
#
# -If you want to modify the current script to modify the plots (using the same
#  data),  this is the function to modify:
#  plotProductsGraphics()          (from class DataPlotterManager)
# -If you want to modify the text that appears in the "Help" button,
#  this is the function to modify:
#  setWindowHelp()
# -If you want to modify the title of the window, modify this function:
#  setWindowTitle()


  #This class deals with the specific details of data reading and final plotting.
  class DataPlotterManager:

    def paragraph(self,text, width=None):
       """ wrap text string into paragraph
           text:  text to format, removes leading space and newlines
           width: if not None, wraps text, not recommended for tooltips as
                  they are wrapped by wxWidgets by default
       """
       import textwrap
       #print 'width=',width,'Text=',text
       if width is None:
           return textwrap.dedent(text).replace('\n', ' ').strip()
       else:
           return textwrap.fill(textwrap.dedent(text), width=width) 


    #1D spectrum plots
    def plotSpectrum(self,data,errs,subplot,title,tooltip):
        data.readSpectrum(0)
        errs.readSpectrum(1)
        spectrum = SpectrumDisplay()
        spectrum.setLabels('Wavelength [nm]','Total Flux ['+data.bunit+']')
        spectrum.display(subplot,title,self.paragraph(tooltip),data.wave,data.flux,errs.flux, autolimits = True) 

    #2D image display
    def plotImage(self,obj,bpm,subplot,title,tooltip):

          obj.readImage(fits_extension=0)
          obj.read2DLinearWCS(fits_extension=0)
          img_obj = ImageDisplay()

          bpm.readImage(fits_extension=2)
          img_bpm = ImageDisplay()

          img_obj.setLabels('Wavelength [nm]','Position Along Slit [arcsec]')
          y_size, x_size = obj.image.shape

          img_obj.setXLinearWCSAxis(obj.crval1,obj.cdelt1,obj.crpix1)
          img_obj.setYLinearWCSAxis(obj.crval2,obj.cdelt2,obj.crpix2)

          #img_obj.setLimits((1,x_size),(0,y_size))
          img_obj.display(subplot, title, self.paragraph(tooltip),obj.image,bpm.image)

    #2D image display
    def plotImageSlice(self,obj,bpm,subplot,title,tooltip,Xlab,Ylab):

          obj.readImage(fits_extension=1)
          obj.read2DLinearWCS(fits_extension=1)
          img_obj = ImageDisplay()

          #bpm.readImage(fits_extension=3)
          #bpm.read2DLinearWCS(fits_extension=3)
          #bpm_obj = ImageDisplay()

      

          img_obj.setLabels(Xlab,Ylab)
          y_size, x_size = obj.image.shape
          x = numpy.arange(0, x_size, 1)
          y = obj.all_hdu[1].data[self.order_id,:]
          #print y
          #print x.shape
          #print y.shape

          img_obj.setXLinearWCSAxis(0,1,0)
          img_obj.setLabels(Xlab,Ylab)
          #img_bpm = ImageDisplay()
          #imadsp.display(subplot, title, tooltip, image)
   
          subplot.plot(x, y, color='blue')
          #img_obj.setLimits((1,x_size),(0,y_size))
          #img_obj.display(subplot, title, self.paragraph(tooltip),obj.image,bpm.image)

    def oplotImageScatter(self,img,tab,ext,binx,biny,Xcol,Ycol,subplot, marker = 'o', size = 10, color = 'blue' ):
          tab.readTableXYColumns(fits_extension=ext,xcolname=Xcol, ycolname=Ycol)
 
          #print tab.x_column
          #print tab.y_column
          #print binx,biny
          #img.overplotScatterDataSet=True
          #print marker, size, color
          img.overplotScatter(tab.x_column/binx, tab.y_column/biny, marker, size, color)

    


    def oplotImageScatterTrace(self,tab,ext_ima,ext_tab,sx,binx,biny,subplot, marker = 'o', size = 10, color = 'blue' ):
          coeff_0 = tab.all_hdu[ext_tab].data.field('COEFF_0')
          coeff_1 = tab.all_hdu[ext_tab].data.field('COEFF_1')
          coeff_2 = tab.all_hdu[ext_tab].data.field('COEFF_2')
          coeff_3 = tab.all_hdu[ext_tab].data.field('COEFF_3')
          coeff_4 = tab.all_hdu[ext_tab].data.field('COEFF_4')

          #print "coeff_0=",coeff_0
          nrows=tab.all_hdu[ext_tab].data.shape[0]
          #print "nrows=",nrows,"sx=",sx
          x=numpy.linspace(1,sx,100)
          for i in range(nrows):
              #x = float(i)
              x2=x*x
              x3=x2*x
              x4=x2*x2
              y=coeff_0[i]+ \
                   coeff_1[i]*x+ \
                   coeff_2[i]*x2+ \
                   coeff_3[i]*x3+ \
                   coeff_4[i]*x4
              subplot.plot(x,y,marker=marker,color=color)
 

    def prepImageScatter(self,img_disp,obj,bpm,Xlab,Ylab):

          obj.readImage(fits_extension=0)
          obj.read2DLinearWCS(fits_extension=0)

          bpm.readImage(fits_extension=2)
          img_bpm = ImageDisplay()

          img_disp.setLabels(Xlab,Ylab)
          y_size, x_size = obj.image.shape

          img_disp.setXLinearWCSAxis(obj.crval1,obj.cdelt1,obj.crpix1)
          img_disp.setYLinearWCSAxis(obj.crval2,obj.cdelt2,obj.crpix2)

          #self.img_obj.setLimits((0,x_size),(0,y_size))

    def prepImageOrderdef(self,img_disp,obj,ext,Xlab,Ylab):

          obj.readImage(fits_extension=ext)
          obj.read2DLinearWCS(fits_extension=ext)

 
          img_disp.setLabels(Xlab,Ylab)
          y_size, x_size = obj.image.shape

          #img_disp.setXLinearWCSAxis(obj.crval1,obj.cdelt1,obj.crpix1)
          #img_disp.setYLinearWCSAxis(obj.crval2,obj.cdelt2,obj.crpix2)

          #self.img_obj.setLimits((0,x_size),(0,y_size))


    #2D image display
    def plotImageOrderdef(self,obj,ext_ima,ext_tab,binx,biny,Xlab,Ylab,Xcol1,Ycol1,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageOrderdef(img_disp,obj,ext_ima,Xlab,Ylab)

          sx = obj.all_hdu[ext_ima].header['NAXIS1']
          sy = obj.all_hdu[ext_ima].header['NAXIS2']
          x_lim = (0, sx)
          y_lim = (0, sy)
          img_disp.setLimits(x_lim,y_lim)
          #print "sx=",sx,"sy=",sy
 
          #As this image has intensities in the range 0-50 we need to rescale z
          if ext_ima == 1 :
             z_lim = (0,45)
          else :
             z_lim = (0,26)
          img_disp.setZLimits(z_lim)

          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)

          self.oplotImageScatterTrace(obj,ext_ima,ext_tab,sx,binx,biny,subplot, marker = '.', size = 1, color = 'green' )

          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])


    def plotImageWave(self,obj,tab,ext_ima,ext_tab,binx,biny,Xlab,Ylab,Xcol1,Ycol1,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageOrderdef(img_disp,obj,ext_ima,Xlab,Ylab)

          sx = obj.all_hdu[ext_ima].header['NAXIS1']
          sy = obj.all_hdu[ext_ima].header['NAXIS2']
          x_lim = (0, sx)
          y_lim = (0, sy)
          self.ima_sy=sy
          img_disp.setLimits(x_lim,y_lim)
          #print "sx=",sx,"sy=",sy
 
          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)

          #print "Xcol1=",Xcol1
          #print "Ycol1=",Ycol1

          self.oplotImageScatter(img_disp,tab,ext_tab,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'green' )


          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])



    #1D spectrum plots
    def plotSpectrum(self,data,errs,qual,subplot,title,tooltip):
        data.readSpectrum(1)
        errs.readSpectrum(2)
        nwave = len(data.flux)
        minlimwave = int(nwave*0.25)
        maxlimwave = int(nwave*0.75)

        spectrum = SpectrumDisplay()
        spectrum.setLabels('Wavelength [nm]','Total Flux ['+data.bunit+']')

        spectrum.display(subplot,title,self.paragraph(tooltip),data.wave,data.flux,errs.flux, autolimits = True) 
        #matplotlib.pyplot.tight_layout()
        if self.response_found is True and self.rec_id[16:19] != "nod":
           #in case response is available we need to reduce fonts
           subplot.set_title(title, fontsize=7)
        try:
            subplot.figure.tight_layout()
        except AttributeError:
            pass

        #Flag BP as errors
        qual.readSpectrum(2)

        bpm_all = (qual.flux == 0 ) 
        mask_a_data=numpy.ma.MaskedArray(data.flux, mask=bpm_all).compressed()
        mask_a_wave=numpy.ma.MaskedArray(data.wave,mask=bpm_all).compressed()
        size_a_err=numpy.ma.MaskedArray(errs.flux,mask=bpm_all).compressed()
        #print "size all", mask_a_data.size
        if mask_a_data.size > 0 :
           subplot.errorbar(mask_a_wave, mask_a_data, xerr=None, yerr=size_a_err, color='k', linestyle='', capsize=0)
        #print "size masked", mask_f_data.size
        #print "size spectrum", data.flux.size
        if mask_f_data.size > 0 :
           subplot.errorbar(mask_f_wave, mask_f_data, xerr=None, yerr=size_f_err, color='r', linestyle='', capsize=0)
        subplot.set_xlim(spectrum.wave_lim)
        subplot.set_ylim(spectrum.flux_lim)
       



    def plotImageFlat(self,obj,ext_ima,binx,biny,Xlab,Ylab,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageOrderdef(img_disp,obj,ext_ima,Xlab,Ylab)

          sx = obj.all_hdu[ext_ima].header['NAXIS1']
          sy = obj.all_hdu[ext_ima].header['NAXIS2']
          x_lim = (0, sx)
          y_lim = (0, sy)
          img_disp.setLimits(x_lim,y_lim)
          #print "sx=",sx,"sy=",sy
 
          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)
          #self.plotSpectrum(obj,obj,obj,subplot,title,tooltip)


          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])

    def plotImageScatter1Col(self,obj,bpm,tab,ext,binx,biny,Xlab,Ylab,Xcol1,Ycol1,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageScatter(img_disp,obj,bpm,Xlab,Ylab)

          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'green' )



          #bpm_filt = ( (bpm.image.astype(int) & self.decode_bp) != 0 )
          #img_disp.display(subplot, title, self.paragraph(tooltip),obj.image,bpm_filt)
          #img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)
          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])

    #2D image display
    def plotImageScatter2Col(self,obj,bpm,tab,ext,binx,biny,Xlab,Ylab,Xcol1,Ycol1,Xcol2,Ycol2,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageScatter(img_disp,obj,bpm,Xlab,Ylab)

          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'blue' )
          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol2,Ycol2,subplot, 'o', 10, 'yellow' )

          bpm_filt = ( (bpm.image.astype(int) & self.decode_bp) != 0 )
          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image,bpm_filt)
          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])

    #2D image display
    def plotImageScatter3Col(self,obj,bpm,tab,ext,binx,biny,Xlab,Ylab,Xcol1,Ycol1,Xcol2,Ycol2,Xcol3,Ycol3,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageScatter(img_disp,obj,bpm,Xlab,Ylab)


          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'blue' )
          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol2,Ycol2,subplot, 'o', 10, 'yellow' )
          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol3,Ycol3,subplot, 'o', 10, 'green' )

#          self.img_obj.setXLinearWCSAxis(img_obj.crval1,img_obj.cdelt1,img_obj.crpix1)

          bpm_filt = ( (bpm.image.astype(int) & self.decode_bp) != 0 )
          img_disp.display(subplot, title,self.paragraph(tooltip),obj.image,bpm_filt)
          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])


    #1D spectrum table plots
    def plotTable(self,tab,Xcol,Ycol,Xlab,Ylab,subplot,title,tooltip,
    wave = None):

        tab.readTableXYColumns(fits_extension=1,xcolname=Xcol, ycolname=Ycol)
        spectrum = SpectrumDisplay()
        flux_plotmax = 1.2 * numpy.nanmax(tab.y_column)
        flux_plotmin = 0.0
        spectrum.setLabels(Xlab,Ylab)
        spectrum.flux_lim = flux_plotmin, flux_plotmax
        if wave is not None:
           spectrum.setWaveLimits((wave[0], wave[len(wave)-1]))

        spectrum.display(subplot,title,self.paragraph(tooltip),tab.x_column,tab.y_column) 

    #1D spectrum table over-plots
    def oplotTable(self,tab,Xcol,Ycol,Xlab,Ylab,subplot,color):

        tab.readTableXYColumns(fits_extension=1,xcolname=Xcol, ycolname=Ycol)
        spectrum = SpectrumDisplay()
        spectrum.overplot(subplot,tab.x_column,tab.y_column,color)


    def scatterPlotScatter(self, subplot, x, y):
        subplot.scatter(x, y, s=0.4, color='blue')
        subplot.ticklabel_format(style='sci',scilimits=(0,3))

    def scatterPlotLabels(self, subplot, x_label, y_label):
        subplot.set_xlabel(x_label, fontsize=12)
        subplot.set_ylabel(y_label, fontsize=12)

    def finalSetup(self, subplot, title, tooltip):
        subplot.grid(True)
        subplot.set_title(title, fontsize=12)
        subplot.tooltip = self.paragraph(tooltip)


    def scatterPlot(self, subplot, x, y, x_label, y_label, title, tooltip):

        self.scatterPlotScatter(subplot, x, y)
        self.scatterPlotLabels(subplot, x_label, y_label)
        self.scatterPlotLimits(subplot, x, y)
        self.finalSetup(subplot, title, self.paragraph(tooltip))

    def scatterPlotLimits(self, subplot, x, y):
        subplot.set_xlim(numpy.nanmin(x)-1, numpy.nanmax(x) + 1.)
        subplot.set_ylim(1.05 * numpy.nanmin(y), 1.05 * numpy.nanmax(y))



    #1D table scatter plots
    def plotTableScatter(self,tab,Xcol,Ycol,Xlab,Ylab,subplot,title,tooltip,ext_no=None):
        extno=1
        if ext_no != None :
           extno=ext_no

        tab.readTableXYColumns(fits_extension=extno,xcolname=Xcol,ycolname=Ycol)
        self.scatterPlotScatter(subplot, tab.x_column, tab.y_column)
        self.scatterPlotLabels(subplot, Xlab, Ylab)
        self.scatterPlotLimits(subplot, tab.x_column, tab.y_column)
        self.finalSetup(subplot, title, self.paragraph(tooltip))
        self.scatterPlot(subplot, tab.x_column, tab.y_column, Xlab, Ylab, title, tooltip)


    # This function will read all the columns, images and whatever is needed
    # from the products. The variables , self.plot_x, self.plot_y, etc...
    # are used later in function plotProductsGraphics().
    # Add/delete these variables as you need (only that plotProductsGraphics()
    # has to use the same names).
    # You can also create some additional variables (like statistics) after
    # reading the files.
    # If you use a control variable (self.xxx_found), you can modify 
    # later on the layout of the plotting window based on the presence of 
    # given input files. 
    # sof contains all the set of frames
    def readFitsData(self, fitsFiles):
      #Control variable to check if the interesting files where at the input
      #print fitsFiles
      self.fibre_id = 'fib A'
      self.resid_tab_found   = False
      self.edges_tab_found   = False
      self.order_tab_found = False
      self.fspectrum_a_found = True
      self.wave_found = False
      self.cleaned_wave_found = True
      self.frameON_found      = False
      self.grid_back_found      = False
      self.sub_back_found   = False
      self.obj_sky2D_found   = False
      self.bpm_found   = False
      self.nima = 0
      self.binx = 1
      self.biny = 1
      self.fibre_id = 'fib A'
      self.order_id = 10
      self.product_id = 'S2D_THAR_THAR_A'
      self.labels_fib= ['fib A','fib B']
      self.labels_prod=['S2D_THAR_THAR_A','WAVE_MATRIX_THAR_THAR_A','DLL_MATRIX_THAR_THAR_A','RES_MAP_THAR_THAR_A']

      #Read all the products
      frames = dict()
      for frame in fitsFiles:
        if frame == '' :
          continue

        header = pyfits.open(frame.name)
        #Make sure to have only products from the same recipe
        #that used this (common) script 
        if 'ESO PRO REC1 ID' in header[0].header :
           rec_id = header[0].header['ESO PRO REC1 ID']
           #print "rec_id=", rec_id
           if rec_id == self.rec_id :
              category = frame.category
              frames[category] = frame
              #print "frame name:", frame.name


      #print "rec id:",rec_id
      #print frames.keys()
 
 
# For any arm search a list of input frames
      #print frames
      key = "TEST_PRODUCT"
      if key in frames :
        hdulist = frames[key]
        #pfile= hdulist[0].header['PIPEFILE']
        #print "pfile=",pfile
        pfile = "HARPS_cleaned_wave.fits"
        if pfile == "HARPS_cleaned_wave.fits" :
          self.cleaned_wave_found = True
          self.cleaned_wave = PipelineProduct(hdulist)
          print("found", key)
          self.frameON_found = True
          self.wave_found = True


      key = "S2D_THAR_THAR_A"
      if key in frames :
        self.s2d_thar_thar_a_found = True
        hdulist = frames[key]
        self.s2d_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True
        self.wave_found = True

      key = "S2D_THAR_THAR_B"
      if key in frames :
        self.s2d_thar_thar_b_found = True
        hdulist = frames[key]
        self.s2d_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


      key = "WAVE_MATRIX_THAR_THAR_A"
      if key in frames :
        self.wave_matrix_thar_thar_a_found = True
        hdulist = frames[key]
        self.wave_matrix_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "WAVE_MATRIX_THAR_THAR_B"
      if key in frames :
        self.wave_matrix_thar_thar_b_found = True
        hdulist = frames[key]
        self.wave_matrix_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "DLL_MATRIX_THAR_THAR_A"
      if key in frames :
        self.dll_matrix_thar_thar_a_found = True
        hdulist = frames[key]
        self.dll_matrix_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "DLL_MATRIX_THAR_THAR_B"
      if key in frames :
        self.dll_matrix_thar_thar_b_found = True
        hdulist = frames[key]
        self.dll_matrix_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "RES_MAP_THAR_THAR_A"
      if key in frames :
        self.res_map_thar_thar_a_found = True
        hdulist = frames[key]
        self.res_map_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "RES_MAP_THAR_THAR_B"
      if key in frames :
        self.res_map_thar_thar_b_found = True
        hdulist = frames[key]
        self.res_map_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


      key = "LINE_TABLE_THAR_THAR_A"
      if key in frames :
        self.line_table_thar_thar_a_found = True
        hdulist = frames[key]
        self.line_table_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "LINE_TABLE_THAR_THAR_B"
      if key in frames :
        self.line_table_thar_thar_b_found = True
        hdulist = frames[key]
        self.line_table_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True



      key = "LINE_TABLE_RAW_THAR_THAR_A"
      if key in frames :
        self.line_table_raw_thar_thar_a_found = True
        hdulist = frames[key]
        self.line_table_raw_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "LINE_TABLE_RAW_THAR_THAR_B"
      if key in frames :
        self.line_table_raw_thar_thar_b_found = True
        hdulist = frames[key]
        self.line_table_raw_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


    #Set rec id (to have proper recipe parameters prefix)
    def setRecId(self, rec_id):
      #Recipe ID variable to properly define params
      self.rec_id = rec_id

    #Get arm setting
    def getArmId(self, sof):
      #Recipe ID variable to properly define params
      self.rec_id = "espdr_mbias"
      nf = 0

      frames = dict()
      files = sof.files
      for f in files:
        frame=f.name
        if frame == '' :
          continue
        else :
           nf += 1
           hdulist = pyfits.open(frame)
           rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
      if nf != 0 :
         self.rec_id = rec_id_list[0:]

      #print "self.rec_id", self.rec_id
      if self.rec_id == "espdr_wave" or self.rec_id == "wave":
         self.rec_subtitle = "Wavelength Calibration. "
            
    # This function creates all the subplots. It is responsible for the plotting 
    # layouts. 
    # There can different layouts, depending on the availability of data
    # Note that subplot(I,J,K) means the Kth plot in a IxJ grid 
    # Note also that the last one is actually a box with text, no graphs.
    def addSubplots(self, figure):
      nrows=self.nima
      row=1;
      print("self.wave_found=",self.wave_found)
      print("self.cleaned_wave_found=",self.cleaned_wave_found)

      if self.wave_found == True and self.cleaned_wave_found == True:
        #wave recipe
        #self.subplot_mflat  = figure.add_subplot(nrows,1,row)
        #self.subplot_arc  = figure.add_subplot(2,1,1)
        self.subplot_image = figure.add_subplot(2,1,1)
        self.subplot_spectrum  = figure.add_subplot(2,1,2)
        self.fibre_selector = figure.add_axes([0.85, 0.44, 0.10, 0.10])
        self.product_selector = figure.add_axes([0.10, 0.44, 0.37, 0.10])
        self.order_selector = figure.add_axes([0.50, 0.44, 0.25, 0.02])
        row +=1

      else : 
        self.subtext_nodata    = figure.add_subplot(1,1,1)
        #print "found no spectrum data"
      #print "nrows=",nrows,row

          

    def plotData(self,fibre_id):
        self.plotProductsGraphics()

    def plotWidgets(self) :
        widgets = list()

        labels_fib = self.labels_fib
        self.radiobutton_fib = reflex_plot_widgets.InteractiveRadioButtons(self.fibre_selector, self.setFibreSelectCallBack, labels_fib, 0, title="")
        widgets.append(self.radiobutton_fib)

        labels_prod = self.labels_prod
        self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector, self.setProductSelectCallBack, labels_prod, 0, title="")
        widgets.append(self.radiobutton_pro)

        min=0
        val=self.order_id

        max=self.ima_sy
        title_slider="Select order id by clicking with mouse left button"
        self.slider =reflex_plot_widgets.InteractiveSlider(self.order_selector,self.setOrderSelectCallBack,min,max,val,0)
        widgets.append(self.slider)

        return widgets

    def setOrderSelectCallBack(self, order_id) :
        
        self.order_id = int(order_id)
        self.subplot_spectrum.cla()
        #print "order_id:", self.order_id
        self.plotData(self.fibre_id)


    def setProductSelectCallBack(self, product_id) :
        #print "Selected product id:", product_id
        self.product_id = product_id
        self.subplot_image.cla()
        self.subplot_spectrum.cla()
        #print "product_id:", self.product_id
        #print "Product id:",self.product_id[-1]
        #self.setDisplayCubeSlice(product_id)
        p_len=len(self.product_id)
        if self.fibre_id == 'fib A' and self.product_id[-1] == 'B' :
           self.product_id = self.product_id[0:p_len-1]+'A'
           self.labels_prod=['S2D_THAR_THAR_A','WAVE_MATRIX_THAR_THAR_A','DLL_MATRIX_THAR_THAR_A','RES_MAP_THAR_THAR_A']

           #print "New product id:",self.product_id
        elif self.fibre_id == 'fib B' and self.product_id[-1] == 'A' :
           self.product_id = self.product_id[0:p_len-1]+'B'
           self.labels_prod=['S2D_THAR_THAR_B','WAVE_MATRIX_THAR_THAR_B','DLL_MATRIX_THAR_THAR_B','RES_MAP_THAR_THAR_B']
           #print "New product id:",self.product_id

        self.plotData(self.fibre_id)

    def setFibreSelectCallBack(self, fibre_id) :
        #fibre_id = fibre_id
        #print "Fibre id:",fibre_id
        #print "Product id:",self.product_id[-1]
        self.fibre_id = fibre_id
        p_len=len(self.product_id)
        #print "String len:",p_len
        if self.fibre_id == 'fib A' and self.product_id[-1] == 'B' :
           self.product_id = self.product_id[0:p_len-1]+'A'
           #print "New product id:",self.product_id
        elif self.fibre_id == 'fib B' and self.product_id[-1] == 'A' :
           self.product_id = self.product_id[0:p_len-1]+'B'
           #print "New product id:",self.product_id
     
           

        self.subplot_image.cla()
        self.subplot_spectrum.cla()
        self.plotData(fibre_id)
         


    # This is the function that makes the plots.
    # Add new plots or delete them using the given scheme.
    # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
    # It is mandatory to add a tooltip variable to each subplot.
    # One might be tempted to merge addSubplots() and plotProductsGraphics().
    # There is a reason not to do it: addSubplots() is called only once at
    # startup, while plotProductsGraphics() is called always there is a resize.
    def plotProductsGraphics(self):
      if (self.wave_found == True): 
        title_pref = 'Linear-extracted and Merged Spectrum.'          

        tooltip_spectrum ="""\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """

        title_spectrum   = title_pref

        #Image
        spec_frameON   = ''
        #print "Recipe ID:",self.rec_id
        if self.rec_id == "wave" :
           if self.fibre_id == 'fib A' :
             spec_frame   = 'Arc Lamp fib A '
           else :
             spec_frame   = 'Arc Lamp fib B '
           tooltip_frameON ="""\
           2D Image (wavelength,order) corresponding to the pipeline 
           product indicated in the 
           checked bottom from the list at the left hand side central panel. 
           Green points trace each detected lines. 
           Red points trace not well detected lines 
           """

           tooltip_spectrum ="""\
           Extracted spectrum corresponding to the
           Bias corrected fibre arc lamp image 
           traced at the order position indicated by the image slicer.
           Green points trace each detected lines. 
           Red points trace not well detected lines 
           """
         
        title_frame   = spec_frame+'Image'




        #2D frame PRE format (predict/orderpos/2dmap/wavecal/flexcomp)
        if self.product_id == 'S2D_THAR_THAR_A' :
           self.obj = self.s2d_thar_thar_a
           self.spc = self.s2d_thar_thar_a
        elif self.product_id == 'S2D_THAR_THAR_B' :
           self.obj = self.s2d_thar_thar_b
           self.spc = self.s2d_thar_thar_b
        elif self.product_id == 'WAVE_MATRIX_THAR_THAR_A' :
           self.obj = self.wave_matrix_thar_thar_a
           self.spc = self.wave_matrix_thar_thar_a
        elif self.product_id == 'WAVE_MATRIX_THAR_THAR_B' :
           self.obj = self.wave_matrix_thar_thar_b
           self.spc = self.wave_matrix_thar_thar_b
        elif self.product_id == 'DLL_MATRIX_THAR_THAR_A' :
           self.obj = self.dll_matrix_thar_thar_a
           self.spc = self.dll_matrix_thar_thar_a
        elif self.product_id == 'DLL_MATRIX_THAR_THAR_B' :
           self.obj = self.dll_matrix_thar_thar_b
           self.spc = self.dll_matrix_thar_thar_b
        elif self.product_id == 'RES_MAP_THAR_THAR_A' :
           self.obj = self.res_map_thar_thar_a
           self.spc = self.res_map_thar_thar_a
        elif self.product_id == 'RES_MAP_THAR_THAR_B' :
           self.obj = self.res_map_thar_thar_b
           self.spc = self.res_map_thar_thar_b



        #print "Recipe ID:",self.rec_id
        if (self.wave_found == True) and \
            self.frameON_found == True:

           if self.rec_id == "wave" :
              print("do wave plot")
              self.plotImageWave(self.obj,self.line_table_raw_thar_thar_a,1,1, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X0', 'Y0', self.subplot_image,title_frame,tooltip_frameON)

              self.plotImageSlice(self.spc,self.spc,self.subplot_spectrum,title_frame,tooltip_spectrum,'X [pix]','ADU')

              #self.plotImageWave(self.cleaned_wave,self.line_table_raw_thar_thar_a,1,1, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X0', 'Y0', self.subplot_arc,title_frame,tooltip_frameON)

      else :
        #Data not found info
        self.subtext_nodata.set_axis_off()
        self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
        self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c', 
                                 fontsize=18, ha='left', va='center', alpha=1.0)
        self.subtext_nodata.tooltip="""\
                                    Merged spectrum not found in the products"""
        #print "found no spectrum data"
 
  
    # This function specifies which are the parameters that should be presented
    # in the window to be edited.
    # Note that the parameter has to be also in the in_sop port (otherwise it 
    # won't appear in the window) 
    # The descriptions are used to show a tooltip. They should match one to one
    # with the parameter list 
    # Note also that parameters have to be prefixed by the 'recipe name:'

    def setInteractiveParameters(self):
      paramList = list()
      rec_id=self.rec_id
      self.par = espdr_parameters_common.Parameters()
      #self.par.setGeneralCalibParameters(paramList,rec_id)
      if rec_id == "wave" :
         self.par.setWaveCalParameters(paramList,"espdr_wave","all")
 
      else :
         print("recipe" ,rec_id,  "not supported")

      return paramList

    def setWindowHelp(self):
      help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
      return help_text

    def setWindowTitle(self):
      title = 'ESPRESSO Interactive ' + self.rec_subtitle  
      return title

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")
  raise


#This is the 'main' function
if __name__ == '__main__':

  # import reflex modules
  from reflex import *
  from reflex_interactive_app import *
  from pipeline_display import *
  from pipeline_product import *

  # Create interactive application
  interactive_app = PipelineInteractiveApp(enable_init_sop=True)

  # PECULIAR XSH needs this in order to be able later to get from an input FITS
  # the ins-mode, arm (and recipe) IDs, used in titles and param setting
  # get inputs from the command line
  interactive_app.parse_args()
  inputs = interactive_app.inputs
  #(inputs, args) = interactive_app.parse_args()

  #Check if import failed or not
  if import_sucess == 'false' :
     interactive_app.setEnableGUI(false)

  #interactive_app.setEnableGUI(True)
  #Open the interactive window if enabled
  if interactive_app.isGUIEnabled() :
    #Get the specific functions for this window
    dataPlotManager = DataPlotterManager()
    #print inputs.in_sof
    #dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
    #With the following call XSH get the: ins-mode, arm (and recipe) IDs
    dataPlotManager.getArmId(inputs.in_sof)
    #Set recipe ID in order to build proper param list, display layout
    dataPlotManager.setRecId("wave")


    interactive_app.setPlotManager(dataPlotManager)
    interactive_app.showGUI()
  else :
    interactive_app.passProductsThrough()
   
  #Print outputs. This is parsed by the Reflex python actor to get the results
  #Do not remove
  interactive_app.print_outputs()
  sys.exit()
