from adari_core.plots.panel import Panel
from adari_core.plots.images import ImagePlot
from adari_core.plots.cut import CutPlot
from adari_core.report import AdariReportBase
from adari_core.utils.utils import fetch_kw_or_default
from adari_core.plots.text import TextPlot
from adari_core.plots.histogram import HistogramPlot

import os

from .espresso_utils import EspressoReportMixin


class EspressoSkyflatEffReport(EspressoReportMixin, AdariReportBase):
    def __init__(self):
        # raise NotImplementedError("This report has not been updated to "
        #                           "use the new structure yet!")
        super().__init__("espresso_skyflat_eff")

    # FIXME update to use new report inheritance schema correctly

    def parse_sof(self):
        raw = None
        eff_ab = None
        for filename, catg in self.inputs:
            if catg == "EFF_AB" and raw is None:
                raw = filename
            if catg == "REL_EFF_B" and eff_ab is None:
                eff_ab = filename

        file_lists = []
        if raw is not None and eff_ab is not None:
            file_lists.append(
                {
                    "raw": raw,
                    "eff_ab": eff_ab,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}

        for file_lists in self.hdus:
            raw = file_lists["raw"]
            eff_ab = file_lists["eff_ab"]

            p = Panel(4, 3, height_ratios=[1, 4, 4])

            # extensions
            bext = "CCD290blue"
            rext = "CCD290red"

            # Blue side
            # Full frame & CutPlot
            # Setup the ImagePlots that we need.
            blue_full = ImagePlot(title="Blue detector")
            blue_full.add_data(raw[bext].data)

            blue_full_cen = ImagePlot(title="Blue detector center")
            blue_full_cen.add_data(raw[bext].data)

            red_full = ImagePlot(title="Red detector")
            red_full.add_data(raw[rext].data)

            red_full_cen = ImagePlot(title="Red detector center")
            red_full_cen.add_data(raw[rext].data)

            rel_eff = ImagePlot(title="REL_EFF_B")
            rel_eff.add_data(eff_ab[1].data)

            # Metadata
            px = 0
            py = 0
            vspace = 0.3
            t1 = TextPlot(columns=1, v_space=vspace)
            fname = os.path.basename(str(eff_ab.filename()))
            col1 = (
                str(eff_ab["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + str(eff_ab["PRIMARY"].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(eff_ab["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(eff_ab["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")),
            )
            t1.add_data(col1)
            p.assign_plot(t1, px, py, xext=2)

            px = px + 2
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = (
                "INS.MODE: "
                + str(eff_ab["PRIMARY"].header.get("HIERARCH ESO INS MODE")),
                "DET.BINX: "
                + str(eff_ab["PRIMARY"].header.get("HIERARCH ESO DET BINX")),
                "DET.BINY: "
                + str(eff_ab["PRIMARY"].header.get("HIERARCH ESO DET BINY")),
                "OCS.ENABLED.FE: "
                + str(eff_ab["PRIMARY"].header.get("HIERARCH ESO OCS ENABLED FE")),
            )
            t2.add_data(col2)
            p.assign_plot(t2, px, py, xext=1)

            # Cut plot Y
            cutpos = blue_full.get_data_coord(blue_full.data.shape[0] // 4, "y")
            blue_raw_cutY = CutPlot(
                "y",
                title="{} raw row @ Y {}".format(bext, cutpos),
                x_label="x",
                y_label=fetch_kw_or_default(eff_ab["PRIMARY"], "BUNIT", default="ADU"),
            )
            px = 0
            py = py + 1
            blue_raw_cutY.add_data(blue_full, cutpos, color="black", label="raw")
            p.assign_plot(blue_raw_cutY, px, py)

            # Cut plot Y CENTER
            blue_raw_cutY_cen = CutPlot(
                "y",
                title="{} raw row center @ Y {}".format(bext, cutpos),
                x_label="x",
                y_label=fetch_kw_or_default(eff_ab["PRIMARY"], "BUNIT", default="ADU"),
                x_min=blue_full_cen.get_data_coord(
                    blue_full_cen.data.shape[1] * 0.25 - 200, "x"
                ),
                x_max=blue_full_cen.get_data_coord(
                    blue_full_cen.data.shape[1] * 0.25 + 200, "x"
                ),
            )
            py = py + 1
            blue_raw_cutY_cen.add_data(
                blue_full_cen, cutpos, color="black", label="raw center"
            )
            p.assign_plot(blue_raw_cutY_cen, px, py)

            px = 1
            py = 1

            # Histogram of full raw blue file
            blue_full_hist = HistogramPlot(
                title="{} raw data".format(bext), bins=50, v_min=-5000, v_max=70000
            )
            blue_full_hist.add_data(raw[bext].data, label="raw data counts")
            p.assign_plot(blue_full_hist, px, py)

            #       4. Cut in y direction of product REL_EFF_B, 1st extension, at x = 1/2 * NAXIS1. X axis label 'Order No', y axis label 'Relative efficiency'.
            # Cut plot X of
            cutpos = rel_eff.get_data_coord(rel_eff.data.shape[1] // 2, "x")
            raw_cutX = CutPlot(
                "x",
                title="REL_EFF_B[1] raw column @ X {}".format(cutpos),
                x_label="Order No",
                y_label="Relative efficiency",
            )
            raw_cutX.add_data(
                rel_eff, cutpos, color="black", label="relative efficiency"
            )

            py = py + 1
            p.assign_plot(raw_cutX, px, py)

            # RED EXTENSION
            # Cut plot Y
            cutpos = red_full.get_data_coord(red_full.data.shape[0] // 4, "y")
            red_raw_cutY = CutPlot(
                "y",
                title="{} raw row @ Y {}".format(rext, cutpos),
                x_label="x",
                y_label=fetch_kw_or_default(eff_ab["PRIMARY"], "BUNIT", default="ADU"),
            )
            px = 2
            py = 1
            red_raw_cutY.add_data(red_full, cutpos, color="black", label="raw")
            p.assign_plot(red_raw_cutY, px, py)

            # Cut plot Y CENTER
            red_raw_cutY_cen = CutPlot(
                "y",
                title="{} raw row center @ Y {}".format(rext, cutpos),
                x_label="x",
                y_label=fetch_kw_or_default(eff_ab["PRIMARY"], "BUNIT", default="ADU"),
                x_min=red_full_cen.get_data_coord(
                    red_full_cen.data.shape[1] * 0.25 - 200, "x"
                ),
                x_max=red_full_cen.get_data_coord(
                    red_full_cen.data.shape[1] * 0.25 + 200, "x"
                ),
            )
            py = py + 1
            red_raw_cutY_cen.add_data(
                red_full_cen, cutpos, color="black", label="raw center"
            )
            p.assign_plot(red_raw_cutY_cen, px, py)

            px = 3
            py = 1

            # Histogram of full raw blue file
            red_full_hist = HistogramPlot(
                title=" {} raw data".format(rext), bins=50, v_min=-5000, v_max=70000
            )
            red_full_hist.add_data(raw[rext].data, label="raw data counts")
            p.assign_plot(red_full_hist, px, py)

            input_files = [raw.filename(), eff_ab.filename()]

            panels[p] = {
                "report_name": "espresso_skyflat_eff",
                "report_description": "ESPRESSO skyflatt efficiency panel",
                "report_tags": [],
                "input_files": input_files,
            }

        return panels


rep = EspressoSkyflatEffReport()
