class EspressoReportMixin(object):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._version = "3.1.0"


class EspressoSetupInfo:
    @staticmethod
    def bias(hdul):
        metadata = [
            "INS.MODE: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS MODE")),
            "DET.BINX: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET BINX")),
            "DET.BINY: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET BINY")),
        ]
        return metadata

    @staticmethod
    def dark(hdul):
        metadata = EspressoSetupInfo.bias(hdul)
        metadata.append(
            "DET.BINY: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET EXPTIME"))
        )
        return metadata

    @staticmethod
    def led_ff(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def detmon(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def orderdef(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def flat(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def contam_thar(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def contam_fp(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def wave_fp_fp(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def wave_thar_fp(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def wave_fp_thar(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def wave_lfc_fp(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def wave_fp_lfc(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def eff_ab(hdul):
        return EspressoSetupInfo.bias(hdul)

    @staticmethod
    def flux(hdul):
        return EspressoSetupInfo.bias(hdul)
