/*
 * espdr_sigma_clipping.h
 *
 *  Created on: Mar 29, 2012
 *      Author: danuta
 */

/*
 * $Author: dsosnows $
 * $Date: 2013-07-18 16:24:42 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_SIGMA_CLIPPING_H
#define ESPDR_SIGMA_CLIPPING_H

/*---------------------------------------------------------------------------*/
/**
 * sigma_clipping
 *
 * sigma clipping functions header
 */


/*----------------------------------------------------------------------------
                                Includes
 ----------------------------------------------------------------------------*/

/* Utility fonctions */
#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* Library */
#include <cpl.h>

/* espdr functions */
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>

/*----------------------------------------------------------------------------
								Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
                            Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_sig_clip (cpl_vector *data_vector,
                               double ksig_low,
                               double ksig_high,
                               const char *method,
                               int maxiter,
                               int reject_zeroMAD,
                               double forced_MAD,
                               double *CoD_RE,
                               double *sigma_RE,
                               int *cosmics_RE,
                               double *mean_RE,
                               double *stddev_RE,
                               double *reject_low_RE,
                               double *reject_high_RE);

cpl_error_code espdr_sig_clip_method_mean (cpl_vector *data_vector,
                               double ksig_low,
                               double ksig_high,
                               int maxiter,
                               int reject_zeroMAD,
                               double forced_MAD,
                               double *CoD_RE,
                               double *sigma_RE,
                               int *cosmics_RE,
                               double *mean_RE,
                               double *stddev_RE,
                               double *reject_low_RE,
                               double *reject_high_RE);



cpl_error_code espdr_sig_clip_method_median (cpl_vector *data_vector,
                               double ksig_low,
                               double ksig_high,
                               int maxiter,
                               int reject_zeroMAD,
                               double forced_MAD,
                               double *CoD_RE,
                               double *sigma_RE,
                               int *cosmics_RE,
                               double *mean_RE,
                               double *stddev_RE,
                               double *reject_low_RE,
                               double *reject_high_RE);

cpl_error_code espdr_sig_clip_fast_method_mean (cpl_vector *data_vector,
                               double ksig_low,
                               double ksig_high,
                               int maxiter,
                               int reject_zeroMAD,
                               double forced_MAD,
                               double *CoD_RE,
                               double *sigma_RE,
                               int *cosmics_RE,
                               double *mean_RE,
                               double *stddev_RE,
                               double *reject_low_RE,
                               double *reject_high_RE);



cpl_error_code espdr_sig_clip_fast_method_median (cpl_vector *data_vector,
                               double ksig_low,
                               double ksig_high,
                               int maxiter,
                               int reject_zeroMAD,
                               double forced_MAD,
                               double *CoD_RE,
                               double *sigma_RE,
                               int *cosmics_RE,
                               double *mean_RE,
                               double *stddev_RE,
                               double *reject_low_RE,
                               double *reject_high_RE);


cpl_error_code espdr_master_frame_method_mean(cpl_imagelist *raw_bias_imagelist,
                                            espdr_CCD_geometry *CCD_geom,
                                            espdr_inst_config *inst_config,
                                            int nx,
                                            int ny,
                                            int ext_no,
                                            int out_x,
                                            int out_y,
                                            cpl_image **master_bias_image_RE,
                                            double *RON_RE,
                                            double *mean_RE,
                                            int *totalCosmics_RE);

cpl_error_code espdr_master_frame_method_median(cpl_imagelist *raw_bias_imagelist,
                                            espdr_CCD_geometry *CCD_geom,
                                            espdr_inst_config *inst_config,
                                            int nx,
                                            int ny,
                                            int ext_no,
                                            int out_x,
                                            int out_y,
                                            cpl_image **master_bias_image_RE,
                                            double *RON_RE,
                                            double *mean_RE,
                                            int *totalCosmics_RE);

cpl_error_code
espdr_get_master_and_cosmics_parallel(double ** images_table,
		const int frames_nb,
		const int nx, const int ny,
		const double ksig_low,
		const double ksig_high,
		const char* method,
		cpl_image **master_image_RE,int *totalCosmics_RE);

cpl_error_code
espdr_get_master_and_cosmics_parallel_mean(const cpl_imagelist* images_table,
		const int frames_nb,
		const int nx, const int ny,
		const double ksig_low,
		const double ksig_high,
		cpl_image **master_image_RE,int *totalCosmics_RE);


cpl_error_code
espdr_get_master_and_cosmics_parallel_median(const cpl_imagelist* images_table,
		const int frames_nb,
		const int nx, const int ny,
		const double ksig_low,
		const double ksig_high,
		cpl_image **master_image_RE,int *totalCosmics_RE);


cpl_error_code espdr_quicksort(double *array, int array_size);

#endif /* ESPDR_SIGMA_CLIPPING_H */
