/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/

#include "bepopconfig.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>



#include "bepopinternal.h"
#include "bepop.h"
#include "erfa.h"
#include "erfam.h"
#include "checkerror.h"


int main ( void )
{

  /* Local variables */
  typeParamBEPOP * ptrBEPOP = NULL ; /* important to initialize at NULL to avoid errors */

  char *ephemerisFileFullName ; /* Full name (/location/ of the ephemeris file */
  char *resultsFileFullName ; /* Full name (/location/ of the results file */

  /* Time variable*/
  int year, month, day, hour, minute ;
  double second ;
  double TimeToMidExposure ;

  double RightAscension,Declinaison ;
  double ProperMotionRightAscension,ProperMotionDeclinaison ;
  double StationLongitude,StationLatitude,StationAltitude ;

  double BERV ;
  double BOV ;
  double BTLA;
  double BERVMX ;
  double SED ;

  int Nerrors ; /* Number of errors detected */
  const int Nerrors_lim = 3 ; /* maximum number of errors before exit the test */
  int res ;

  FILE *referenceFile;

  const char * dir_ephem = "%s/ephemerides/%s" ;
  const char * file_check = "%s/checkfiles/check1.txt" ;

  /* structure containing the output of BEPOP_compute routine */
  typeOutBEPOP resBEPOP ;



  res = 0 ;
  /* Location of the default ephemeris file */
  ephemerisFileFullName = (char*)malloc(sizeof(char)*( strlen(_DATA_TARGZ_DIRECTORY)
                                                      +strlen(dir_ephem)
                                                      +strlen(_DEFAULT_EPHEMERIS_FILE_NAME)
                                                      +1 ));
  sprintf(ephemerisFileFullName,dir_ephem, _DATA_TARGZ_DIRECTORY, _DEFAULT_EPHEMERIS_FILE_NAME);

  /* Initialisation of the pointer */
  ptrBEPOP=BEPOP_initDefault2(ephemerisFileFullName,"eopc04_IAU2000.62-now",1,ptrBEPOP) ;
  BEPOP_checkInit( ptrBEPOP);

  /* Open the file containing the results */
  resultsFileFullName = (char*)malloc(sizeof(char)*( strlen(_DATA_TARGZ_DIRECTORY)
                                                            +strlen(file_check)+1 ));
  sprintf(resultsFileFullName,file_check, _DATA_TARGZ_DIRECTORY);
  if (  (referenceFile = fopen(resultsFileFullName,"r"))==NULL  )
  {
    printf("Error: cannot open file '%s'\n",resultsFileFullName);
    abort() ;
  }



  Nerrors=0 ;
  while (!feof(referenceFile))
  {
    fscanf(referenceFile, "%d %d %d %d %d %lf", &year, &month, &day, &hour, &minute, &second);
    fscanf(referenceFile, "%lf", &TimeToMidExposure);
    fscanf(referenceFile, "%lf %lf %lf %lf", &RightAscension,&Declinaison,
                                             &ProperMotionRightAscension,&ProperMotionDeclinaison);
    fscanf(referenceFile, "%lf %lf %lf", &StationLongitude,&StationLatitude,&StationAltitude);
    fscanf(referenceFile, "%lf %lf %lf %lf %lf", &BERV, &BERVMX, &BTLA, &BOV, &SED);
    if (feof(referenceFile))
    {
      break;
    }
    BEPOP_compute( RightAscension, Declinaison,
                   ProperMotionRightAscension,  ProperMotionDeclinaison,
                   year, month, day, hour, minute , second , TimeToMidExposure,
                   StationLongitude,StationLatitude,StationAltitude ,
                   ptrBEPOP,
                   &resBEPOP);
#if 0
    printf("%4d %02d %02d %02d %02d %05.2f",year, month,day, hour, minute, second ) ;
    printf("  %10.2f",TimeToMidExposure ) ;
    printf("  %6.2f %6.2f",RightAscension,Declinaison) ;
    printf(" %6.3f %6.3f",ProperMotionRightAscension,ProperMotionDeclinaison) ;
    printf("  %7.2f %6.2f %7.1f",StationLongitude,StationLatitude,StationAltitude );
    printf("  %23.16e %23.16e",BERV,BERVMX) ;
    printf("  %23.16e %10.6f",BTLA,BOV) ;
    printf("  %13.3f",SED) ;
    printf("\n");

    printf("%4d %02d %02d %02d %02d %05.2f",year, month,day, hour, minute, second ) ;
    printf("  %10.2f",TimeToMidExposure ) ;
    printf("  %6.2f %6.2f",RightAscension,Declinaison) ;
    printf(" %6.3f %6.3f",ProperMotionRightAscension,ProperMotionDeclinaison) ;
    printf("  %7.2f %6.2f %7.1f",StationLongitude,StationLatitude,StationAltitude );
    printf("  %23.16e %23.16e",resBEPOP.BERV,resBEPOP.BERVMX) ;
    printf("  %23.16e %10.6f",resBEPOP.BTLA,resBEPOP.BOV) ;
    printf("  %13.3f",resBEPOP.SED) ;
    printf("\n");
#endif




    if ( CheckIfErrorTest(BERV, BERVMX, BTLA, BOV, SED, resBEPOP)==1 )
    {
      Nerrors+=1;
      res=1 ;
      printf("Entries: %4d %02d %02d %02d %02d %05.2f",year, month,day, hour, minute, second ) ;
      printf("  %10.2f",TimeToMidExposure ) ;
      printf("  %6.2f %6.2f",RightAscension,Declinaison) ;
      printf(" %6.3f %6.3f",ProperMotionRightAscension,ProperMotionDeclinaison) ;
      printf("  %7.2f %6.2f %7.1f\n",StationLongitude,StationLatitude,StationAltitude );
      printf("  Error on BERV:   %23.16e %23.16e %9.2e\n",BERV,resBEPOP.BERV,fabs(resBEPOP.BERV-BERV) );
      printf("           BERVMX: %23.16e %23.16e %9.2e\n",BERVMX,resBEPOP.BERVMX,fabs(resBEPOP.BERVMX-BERVMX) );
      printf("           BTLA:   %23.16e %23.16e %9.2e\n",BTLA,resBEPOP.BTLA,fabs(resBEPOP.BTLA-BTLA) );
      printf("           BOV:    %23.16e %23.16e %9.2e\n",BOV,resBEPOP.BOV,fabs(resBEPOP.BOV-BOV) );
      printf("           SED:    %23.16e %23.16e %9.2e\n",SED,resBEPOP.SED,fabs(resBEPOP.SED-SED) );
      if (Nerrors>=Nerrors_lim)
      {
        printf("There might be other errors...\n");
        break ;
      }
    };
  }



  fclose(referenceFile);

  ptrBEPOP=BEPOP_close(ptrBEPOP) ;
  return (res);
}
