/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2014-10-28 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_SCI_RED_H
#define ESPDR_SCI_RED_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_keywords.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_orders.h>
#include <espdr_bepop.h>
#include <espdr_flux.h>
#include <espdr_pfits.h>
#include <espdr_sdp_spectrum.h>
#include <espdr_drift.h>
#include <espdr_tellurics.h>
#include <espdr_OH_correction.h>

/* Library */
#include <cpl.h>
#include <assert.h>
#include <math.h>

/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

#define SAVE_DEBUG_PRODUCT_SCIENCE 0
#define SAVE_DEBUG_CCD_CLEANED_SCIENCE 0
#define spectrum_flux_unit  "erg.s**(-1).cm**(-2).angstrom**(-1)"
/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_sci_red(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_SCI_RED_create(const char* recipe_id,
                                               cpl_parameterlist *list,
                                               espdr_SCI_RED_param *p);

cpl_error_code espdr_parameters_SCI_RED_delete(espdr_SCI_RED_param* p);

cpl_error_code espdr_parameters_SCI_RED_get(const char* recipe_id,
                                            cpl_parameterlist* list,
                                            espdr_SCI_RED_param *SCI_RED_param);

cpl_error_code espdr_parameters_SCI_RED_print(espdr_SCI_RED_param *SCI_RED_param);

espdr_SCI_RED_param *espdr_SCI_RED_param_init(const char *recipe_id,
                                              cpl_parameterlist *parameters);

cpl_error_code espdr_get_spectral_type(espdr_inst_config *inst_config,
                                       cpl_propertylist *keywords,
                                       char *sp_type);

cpl_error_code espdr_get_science_params(espdr_inst_config *inst_config,
                                        cpl_propertylist *keywords,
                                        cpl_parameterlist *parameters,
                                        espdr_SCI_RED_param *SCI_RED_param,
                                        char *fibre_b,
                                        double *log_lambda_ini,
                                        double *log_lambda_end,
                                        double *delta_log_lambda,
                                        double *mask_width,
                                        char *mask_table_id,
                                        int *mask_changed,
                                        double *rv_center,
                                        double *rv_range,
                                        double *rv_step,
                                        double *ksigma_cosmic,
                                        int *remove_bias_res_flag,
                                        char *wave_cal_source,
                                        char *extraction_method,
                                        char *background_sw,
                                        char *bias_res_removal_sw,
                                        char *flux_correction_type,
                                        char *drift_correction_sw,
                                        int *drift_set,
                                        char *sky_subtraction_method,
                                        int *sky_subtraction_slidebox,
                                        double *slit_loss,
                                        int *lacosmic_flag,
                                        int *tell_corr_flag);

cpl_error_code espdr_science_get_static_tables(cpl_frameset *frameset,
                                               cpl_frameset *used_frames,
                                               cpl_propertylist *keywords,
                                               espdr_inst_config *inst_config,
                                               cpl_image **rel_eff,
                                               cpl_table **abs_eff_table,
                                               cpl_table **extinction_table,
                                               int mask_changed,
                                               const char *mask_table_id,
                                               const char **mask_id,
                                               cpl_table **mask_table,
                                               char *flux_correction_type,
                                               char *spec_type,
                                               cpl_table **flux_table);

cpl_error_code espdr_get_berv_params(espdr_inst_config *inst_config,
                                     espdr_qc_keywords *qc_kws,
                                     cpl_propertylist *keywords,
                                     cpl_frame *raw_frame,
                                     double *exp_time,
                                     double *ra_ft,
                                     double *dec_ft,
                                     double *pm_ra,
                                     double *pm_dec,
                                     int *year,
                                     int *month,
                                     int *day,
                                     int *hour,
                                     int *minutes,
                                     double *seconds,
                                     double *time_to_mid_exposure,
                                     double *airm);

cpl_error_code espdr_get_seeing(espdr_inst_config *inst_config,
                                cpl_propertylist *keywords,
                                double *seeing,
                                int *seeing_kw_qc);

cpl_error_code espdr_process_raw_till_extraction(cpl_frameset *frameset,
                                                 cpl_parameterlist *parameters,
                                                 const char *RECIPE_ID,
                                                 cpl_frame *raw_frame,
                                                 cpl_frameset *used_frames,
                                                 espdr_inst_config *inst_config,
                                                 espdr_CCD_geometry *CCD_geom,
                                                 espdr_qc_keywords *qc_kws,
                                                 cpl_propertylist *keywords,
                                                 int remove_bias_res_flag,
                                                 char *wave_cal_source,
                                                 char *fibre_b,
                                                 int lacosmic_flag,
                                                 char *background_sw,
                                                 char *extraction_method,
                                                 double *lamp_offset_ar,
                                                 double *lamp_offset_ar1,
                                                 double *lamp_offset_ar2,
                                                 double *ron,
                                                 int **cosmics_nb,
                                                 double **snr_per_fibre,
                                                 double *mjd_obs_delta_time_wave,
                                                 cpl_image **blaze_table,
                                                 cpl_image **wave_matrix,
                                                 cpl_image **wave_matrix_air,
                                                 cpl_image **dll_matrix,
                                                 cpl_image **dll_matrix_air,
                                                 cpl_image **s2d_ref_image,
                                                 cpl_image **flat_corr_flux_RE,
                                                 cpl_image **flat_corr_err_RE,
                                                 cpl_image **flat_corr_qual_RE);

cpl_error_code espdr_create_wavelength_grid(double log_lambda_ini,
                                            double log_lambda_end,
                                            double delta_log_lambda,
                                            cpl_image **wavelenght_grid_pow_10,
                                            cpl_image **wavelenght_air_grid_pow_10);

cpl_error_code espdr_process_sky(cpl_image *flat_corr_flux_table,
                                 cpl_image *flat_corr_err_table,
                                 cpl_image *flat_corr_qual_table,
                                 cpl_image **wave_matrix,
                                 cpl_image **dll_matrix,
                                 cpl_image *rel_eff,
                                 espdr_inst_config *inst_config,
                                 espdr_CCD_geometry *CCD_geom,
                                 int **physical_orders_id,
                                 cpl_image **flux_RE,
                                 cpl_image **err_RE,
                                 cpl_image **qual_RE);

cpl_error_code espdr_scale_sky(cpl_image *s2d_b_input_image_flux,
                               cpl_image *s2d_b_input_image_error,
                               cpl_image *s2d_b_input_image_quality_map,
                               cpl_image *rel_eff,
                               cpl_image **s2d_a_image_flux_RE,
                               cpl_image **s2d_a_image_error_RE,
                               cpl_image **s2d_a_image_quality_map_RE);

cpl_error_code espdr_select_orders_and_create_rebin_image(cpl_image *scaled_flux,
                                                          cpl_image *scaled_error,
                                                          cpl_image *scaled_quality,
                                                          cpl_image **wave_matrix,
                                                          cpl_image **dll_matrix,
                                                          int **physical_orders_id,
                                                          espdr_inst_config *inst_config,
                                                          espdr_CCD_geometry *CCD_geom,
                                                          cpl_image **rebined_image_RE,
                                                          cpl_image **error_image_RE,
                                                          cpl_image **qual_image_RE);

cpl_error_code espdr_subtract_sky(espdr_inst_config *inst_config,
                                  char *sky_subtraction_method,
                                  int slidingbox_size,
                                  cpl_image *flux_obj,
                                  cpl_image *error_obj,
                                  cpl_image *quality_obj,
                                  cpl_image *flux_sky,
                                  cpl_image *error_sky,
                                  cpl_image *quality_sky,
                                  cpl_image **flux_RE,
                                  cpl_image **error_RE,
                                  cpl_image **quality_RE /*science fibre*/);

cpl_error_code espdr_smooth_flux(cpl_image *flux,
                                 int slidingbox_size,
                                 cpl_image *flux_RE);

cpl_error_code espdr_s1d_wavelenght_grid(double log_lambda_0,
                                         double delta_log_lambda,
                                         int grid_length,
                                         cpl_image **s1d_wavelenght_RE);

cpl_error_code espdr_shift_wavelength_solution(
                                    double berv_factor,
                                    cpl_image *wave_matrix,
                                    cpl_image *dll_matrix,
                                    cpl_image **wave_matrix_shifted_RE,
                                    cpl_image **dll_matrix_shifted_RE);

cpl_error_code espdr_rebin_and_merge_orders(
                                    cpl_image *s1d_grid,
                                    cpl_image *s1d_grid_air,
                                    cpl_image *wave_s2d,
                                    cpl_image *dll_s2d,
                                    cpl_image *flux_s2d,
                                    cpl_image *error_s2d,
                                    cpl_image *qual_s2d,
                                    cpl_table **s1d_RE);

cpl_error_code espdr_rebin(cpl_image *flux,
                           cpl_image *error,
                           cpl_image *quality,
                           cpl_image *wave, /*science fibre*/
                           cpl_image *dll,
                           cpl_image *wave_rebinned,
                           cpl_image *dll_rebinned,
                           cpl_image **flux_RE,
                           cpl_image **error_RE,
                           cpl_image **quality_RE);

cpl_error_code espdr_merge_orders(cpl_image *intermediate_rebin_flux,
                                  cpl_image *intermediate_rebin_error,
                                  cpl_image *intermediate_rebin_quality,
                                  cpl_table **s1d_table_merged_RE);

cpl_error_code espdr_calibrate_flux(double airmass,
                                    double seeing,
                                    double slit_loss,
                                    int slit_loss_flag,
                                    espdr_inst_config *inst_config,
                                    cpl_table *s1d_table,
                                    cpl_table *ext_table,
                                    cpl_table *abs_eff,
                                    cpl_table **s1d_fluxcal_RE);

cpl_error_code espdr_compute_rv_table(double RV_range,
                                      double RV_step,
                                      double RV_center,
                                      cpl_array **RV_table_RE);

cpl_error_code espdr_correct_flux(cpl_image *s2d_blaze,
                                  cpl_image *wave_matrix,
                                  cpl_table *flux_template,
                                  cpl_table *mask_table,
                                  char *spec_type,
                                  cpl_image *s2d_blaze_flux_corr_RE,
                                  double *flux_corr);

cpl_error_code espdr_remove_cosmics_via_histogram(cpl_image *flux,
                                                  cpl_image *err,
                                                  cpl_image *flux_RE,
                                                  int *cosmics_RE);

cpl_error_code espdr_sci_red_QC(espdr_CCD_geometry *CCD_geom,
                                espdr_inst_config *inst_config,
                                espdr_qc_keywords *qc_kws,
                                char *fibre_src,
                                char *fibre_B_src,
                                double berv,
                                double bjd,
                                double bervmax,
                                double sed,
                                double vtot,
                                double berv_factor,
                                double lamp_offset_ar,
                                double lamp_offset_ar1,
                                double lamp_offset_ar2,
                                int *cosmics_nb,
                                int *cosmics_nb_2,
                                double *snr,
                                int order_nr,
                                espdr_ngauss_result *g_res,
                                const char *ccf_mask_id,
                                cpl_table *drift_results,
                                char *fibre_B_tag,
                                double asym,
                                double asym_error,
                                double bispan,
                                double bispan_error,
                                double *ron_RE,
                                double *flux_correction,
                                cpl_propertylist **keywords_RE);

cpl_error_code espdr_save_science_products(cpl_frameset *frameset,
                                           cpl_parameterlist *parameters,
                                           const char *RECIPE_ID,
                                           cpl_frameset *used_frames,
                                           cpl_propertylist **keywords_fibre,
                                           cpl_propertylist *keywords_skysub,
                                           cpl_propertylist *keywords_tell_corr,
                                           cpl_propertylist *telluric_keywords,
                                           cpl_propertylist *keywords_oh_corr,
                                           double *mjd_obs_delta_time_wave,
                                           espdr_inst_config *inst_config,
                                           int ext_nb,
                                           int fibres_processed,
                                           char *token,
                                           const char *tag,
                                           char *sky_correction_method,
                                           int tell_corr_flag,
                                           cpl_table *residuals,
                                           cpl_image *drift_matrix,
                                           cpl_image **flat_corr_flux_table,
                                           cpl_image **flat_corr_err_table,
                                           cpl_image **flat_corr_qual_table,
                                           cpl_image **flux_s2d,
                                           cpl_image **error_s2d,
                                           cpl_image **qual_s2d,
                                           cpl_image *flux_sky_sub_s2d_blaze,
                                           cpl_image *error_sky_sub_s2d_blaze,
                                           cpl_image *qual_sky_sub_s2d_blaze,
                                           cpl_image *flux_sky_sub_s2d,
                                           cpl_image *error_sky_sub_s2d,
                                           cpl_image *qual_sky_sub_s2d,
                                           cpl_image **wave_shifted,
                                           cpl_image **wave_air_shifted,
                                           cpl_image **dll_shifted,
                                           cpl_image **dll_air_shifted,
                                           cpl_image **wave_shifted_drift_corr,
                                           cpl_image **wave_air_shifted_drift_corr,
                                           cpl_image **dll_shifted_drift_corr,
                                           cpl_image **dll_air_shifted_drift_corr,
                                           cpl_image **wave_matrix,
                                           cpl_image **dll_matrix,
                                           cpl_image **wave_matrix_air,
                                           cpl_image **dll_matrix_air,
                                           cpl_image **wave_matrix_drift_corr,
                                           cpl_image **wave_matrix_air_drift_corr,
                                           cpl_table **s1d_table_merged,
                                           cpl_table *s1d_table_merged_skysub,
                                           cpl_table *s1d_fluxcal_skysub,
                                           cpl_table *s1d_fluxcal,
                                           cpl_table *s1d_table_merged_tell_corr,
                                           cpl_table *s1d_fluxcal_tell_corr,
                                           cpl_image **CCF_flux,
                                           cpl_image **CCF_error,
                                           cpl_image **CCF_quality,
                                           cpl_image *CCF_flux_sky_sub,
                                           cpl_image *CCF_error_sky_sub,
                                           cpl_image *CCF_quality_sky_sub,
                                           cpl_image *CCF_flux_tell_corr,
                                           cpl_image *CCF_error_tell_corr,
                                           cpl_image *CCF_quality_tell_corr,
                                           cpl_image *tell_spectrum,
                                           cpl_image *flux_tell_corr_s2d_blaze,
                                           cpl_image *error_tell_corr_s2d_blaze,
                                           cpl_image *qual_tell_corr_s2d_blaze,
                                           cpl_image *flux_tell_corr_s2d,
                                           cpl_image *error_tell_corr_error,
                                           cpl_image *qual_tell_corr_qual);

#endif /* ESPDR_SCI_RED_H */

