!/*-----------------------------------------------------------------*/
!/*! 
!  \file f2003version.f 
!  \brief  Check if calceph_getversion_str works with fortran 2003 compiler.
!
!  \author  M. Gastineau 
!           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris. 
!
!   Copyright, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, CNRS
!   email of the author : gastineau@imcce.fr
!
!*/
!/*-----------------------------------------------------------------*/

!/*-----------------------------------------------------------------*/
!/* License  of this file :
!  This file is "triple-licensed", you have to choose one  of the three licenses 
!  below to apply on this file.
!  
!     CeCILL-C
!     	The CeCILL-C license is close to the GNU LGPL.
!     	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )
!  
!  or CeCILL v2.0
!       The CeCILL license is compatible with the GNU GPL.
!       ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )
!  
! 
! This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under 
! French law and abiding by the rules of distribution of free software.  
! You can  use, modify and/ or redistribute the software under the terms 
! of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA  
! at the following URL "http://www.cecill.info". 
!
! As a counterpart to the access to the source code and  rights to copy,
! modify and redistribute granted by the license, users are provided only
! with a limited warranty  and the software's author,  the holder of the
! economic rights,  and the successive licensors  have only  limited
! liability. 
!
! In this respect, the user's attention is drawn to the risks associated
! with loading,  using,  modifying and/or developing or reproducing the
! software by the user in light of its specific status of free software,
! that may mean  that it is complicated to manipulate,  and  that  also
! therefore means  that it is reserved for developers  and  experienced
! professionals having in-depth computer knowledge. Users are therefore
! encouraged to load and test the software's suitability as regards their
! requirements in conditions enabling the security of their systems and/or 
! data to be ensured and,  more generally, to use and operate it in the 
! same conditions as regards security. 
!
! The fact that you are presently reading this means that you have had
! knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
!*/
!/*-----------------------------------------------------------------*/

!/*-----------------------------------------------------------------*/
!/* main program */
!/*-----------------------------------------------------------------*/
       program f2003sgetconstantindex
           USE, INTRINSIC :: ISO_C_BINDING
           use calceph
           implicit none
           integer res
           character(len=CALCEPH_MAX_CONSTANTNAME) nameconstant
           
           character(len=CALCEPH_MAX_CONSTANTNAME) version
           character(len=CALCEPH_MAX_CONSTANTNAME) buildversion
           character(len=CALCEPH_MAX_CONSTANTNAME) smajor
           character(len=CALCEPH_MAX_CONSTANTNAME) sminor
           character(len=CALCEPH_MAX_CONSTANTNAME) spatch
           
           call calceph_getversion_str(version)
           write(smajor,*) CALCEPH_VERSION_MAJOR
           write(sminor,*) CALCEPH_VERSION_MINOR
           write(spatch,*) CALCEPH_VERSION_PATCH
           write(buildversion,'(A,A,A,A,A)') trim(adjustl(smajor)),               &
     &        '.', trim(adjustl(sminor)),'.', trim(adjustl(spatch))      
           res = 1

!           write(*,*) 'library version is ', version
!           write(*,*) 'string library version is ', buildversion
!           write(*,*) CALCEPH_VERSION_STRING
           if (trim(version).ne.trim(buildversion)) then
               res = 0
               write(*,*) "Error: header and library do not match\n"
               write(*,*) 'Error: header version is "',  trim(version),            &
     &                  '"'
               write(*,*) 'Error: library version is "',                           &
     &                   trim(buildversion),'"'
               write(*,*) 'Error: string header version is "',                     &
     &                   trim(CALCEPH_VERSION_STRING),'"'
           endif

           if (trim(version).ne.trim(CALCEPH_VERSION_STRING)) then
               res = 0
               write(*,*) "Error: header and library do not match\n"
               write(*,*) 'Error: header version is "',  trim(version),            &
     &                  '"'
               write(*,*) 'Error: library version is "',                           &
     &                   trim(buildversion),'"'
               write(*,*) 'Error: string header version is "',                     &
     &                   trim(CALCEPH_VERSION_STRING),'"'
           endif

           ! stop on sucess
           if (res.eq.1) then 
            stop
           endif
           ! stop on error
           stop 2
       end
