/*-----------------------------------------------------------------*/
/*!
  \file bepop.h
  \brief header file for bepop.c

  \author  H. Manche
           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris.

   Copyright 2014, 2015, 2016, CNRS
   email of the author : herve.manche@obspm.fr

  last revision: 05/06/2014

  History:
  \note H. Manche 05/06/2014 : creation
 */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/


#ifndef BEPOP_H
#define BEPOP_H


/*----------------------------------------------------------------------------------------------*/
/* definition of the BePOP library version */
/*----------------------------------------------------------------------------------------------*/
/*! version : major number of BePOP library */
#define BEPOP_VERSION_MAJOR 0
/*! version : minor number of BePOP library */
#define BEPOP_VERSION_MINOR 0
/*! version : patch number of BePOP library */
#define BEPOP_VERSION_PATCH 20161125



typedef struct strucParamBEPOPprivate typeParamBEPOP;


typedef struct {
    double BERV; /* Barycentric Earth Radial Velocity (in km/s) (more rigorously: projection of the barycentric observer velocity along the target's direction) */
    double BOV; /* Barycentric Observer Velocity (in km/s)  */
    double BTLA; /* Barycentric Time of Light Arrival, in julian day (TDB) */
    double BERVMX; /* maximum value of BERVMX (in km/s) (approximation, depends only on target position) */
    double SED; /* Sun-Earth distance (in km) */
} typeOutBEPOP ;


typeParamBEPOP* BEPOP_initAllocate(typeParamBEPOP *ptrBEPOP);
typeParamBEPOP* BEPOP_initDefault(const int typeInit,typeParamBEPOP *ptrBEPOP);

void BEPOP_initEphemeris(const char *FileName,const int iMethod_TTmTDB,
                               typeParamBEPOP *ptrBEPOP) ;
void BEPOP_initMethodTTTDB(const int iMethod_TTmTDB, typeParamBEPOP *ptrBEPOP);
void BEPOP_initEOP(const char *FileName, const int InterpolationDegree,
                 const int EOP_Active,
                 typeParamBEPOP *ptrBEPOP);
void BEPOP_initEllipsoid(const int EllipsoidId, typeParamBEPOP *ptrBEPOP);
void BEPOP_initCIPmodel(const char *ModelName, typeParamBEPOP *ptrBEPOP);

void BEPOP_checkInit( const typeParamBEPOP *ptrBEPOP);

void BEPOP_compute( const double alpha_2000, const double delta_2000,
                    const double mua, const double mud,
                    const int year, const int month, const int day,
                    const int hour, const int minute, const double second,
                    const double TimeToMidExposure,
                    const double StationLongitude, const double StationLatitude,
                    const double StationAltitude,
                    const typeParamBEPOP *ptrBEPOP,
                    typeOutBEPOP *outBEPOP);
void BEPOP_compute_viaJD( const double alpha_2000, const double delta_2000,
                          const double mua, const double mud,
                          const double JulianDay_TT[2],
                          const double StationLongitude, const double StationLatitude,
                          const double StationAltitude,
                          const typeParamBEPOP *ptrBEPOP,
                          typeOutBEPOP *outBEPOP);

typeParamBEPOP* BEPOP_close(typeParamBEPOP *ptrBEPOP) ;
double BEPOP_getGMSun(const typeParamBEPOP *ptrBEPOP);
double BEPOP_getGMEarth(const typeParamBEPOP *ptrBEPOP);
void BEPOP_closeEphemeris(struct strucParamBEPOPprivate *ptrBEPOP);
void BEPOP_printVersions(void);



#endif



