/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2014-10-28 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_CAL_EFF_AB_H
#define ESPDR_CAL_EFF_AB_H

/* DFS functions */
#include <espdr_instrument.h>
#include <espdr_dfs.h>
#include <espdr_keywords.h>

/* DRL functions*/
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_orders.h>
#include <espdr_background.h>
#include <espdr_contam.h>

/* Library */
#include <cpl.h>
#include <assert.h>

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

int espdr_cal_eff_ab(cpl_parameterlist *parameters, cpl_frameset *frameset, 
                    const char* recipe_id);
cpl_error_code espdr_parameters_CAL_EFF_AB_create(const char* recipe_id,
                                            cpl_parameterlist *list,
                                            espdr_CAL_EFF_AB_param *p);

cpl_error_code espdr_parameters_CAL_EFF_AB_delete(espdr_CAL_EFF_AB_param* p);

cpl_error_code espdr_parameters_CAL_EFF_AB_get(const char* recipe_id, 
                                         cpl_parameterlist* list,
                                         espdr_CAL_EFF_AB_param *CAL_EFF_AB_param);

cpl_error_code espdr_parameters_CAL_EFF_AB_print(espdr_CAL_EFF_AB_param *CAL_EFF_AB_param);

espdr_CAL_EFF_AB_param *espdr_CAL_EFF_AB_param_init(const char *recipe_id,
                                        cpl_parameterlist *parameters);

cpl_error_code espdr_CAL_EFF_AB_read_parameters(cpl_frameset *frameset,
                                                espdr_CCD_geometry *CCD_geom,
                                                espdr_inst_config *inst_config);

cpl_error_code espdr_relative_efficiency(int pol_deg,
                                         int **physical_orders_id,
                                         espdr_inst_config *inst_config,
                                         espdr_CCD_geometry *CCD_geom,
                                         cpl_image **s2d_flux,
                                         cpl_image **s2d_eff_flux_RE);

cpl_error_code espdr_cal_eff_ab_QC(espdr_CCD_geometry *CCD_geom,
                                   espdr_inst_config *inst_config,
                                   espdr_qc_keywords *qc_kws,
                                   int *cosmics_nb,
                                   double *snr,
                                   int orders_nr,
                                   cpl_propertylist *keywords_RE);

cpl_error_code espdr_rel_eff_QC(espdr_inst_config *inst_config,
                                espdr_qc_keywords *qc_kws,
                                cpl_image *eff_s2d,
                                cpl_propertylist *keywords_RE);

#endif /* ESPDR_CAL_EFF_AB_H */
