/*
 * esp_keywords.h
 *
 *  Modified on: Oct 28, 2014. Added qc_*_flat_* entries
 *  Created  on: Dec 21, 2011
 *      Author: Danuta Sosnowska
 */

#ifndef ESPDR_KEYWORDS_H
#define ESPDR_KEYWORDS_H

#include <espdr_instrument.h>

/* DRS primary header keywords */

#define PRO_CATG_KW				"ESO PRO CATG"
#define PRODCATG_KW                "PRODCATG" // For SDP products


/* Structure holding all the DRS QC KWs */

typedef struct {
    char pro_catg_kw[KEYWORD_LENGTH];
    
    char qc_max_flux_kw[KEYWORD_LENGTH];
    char qc_saturation_check_kw[KEYWORD_LENGTH];
    
    char qc_bias_outliers_kw[KEYWORD_LENGTH];
    char qc_ovsc_outliers_kw[KEYWORD_LENGTH];
    char qc_res_test_kw[KEYWORD_LENGTH];
    char qc_bias_ron_check_kw[KEYWORD_LENGTH];
    char qc_bias_mean_check_kw[KEYWORD_LENGTH];
    char qc_bias_check_kw[KEYWORD_LENGTH];
    //char qc_bias_method_kw[KEYWORD_LENGTH];
    
    char qc_out_bias_ron_kw[KEYWORD_LENGTH];
    char qc_out_ovsc_ron_kw[KEYWORD_LENGTH];
    char qc_out_bias_mean_kw[KEYWORD_LENGTH];
    char qc_out_res_mean_kw[KEYWORD_LENGTH];
    char qc_out_res_stdev_kw[KEYWORD_LENGTH];
    char qc_out_res_test_kw[KEYWORD_LENGTH];
    char qc_out_bias_ron_kw_part[KEYWORD_LENGTH];
    char qc_out_ovsc_ron_kw_part[KEYWORD_LENGTH];
    char qc_out_bias_mean_kw_part[KEYWORD_LENGTH];
    char qc_out_res_mean_kw_part[KEYWORD_LENGTH];
    char qc_out_res_stdev_kw_part[KEYWORD_LENGTH];
    char qc_out_res_test_kw_part[KEYWORD_LENGTH];
    
    char qc_out_bias_ron_e_kw[KEYWORD_LENGTH];
    char qc_out_ovsc_ron_e_kw[KEYWORD_LENGTH];
    char qc_out_bias_mean_e_kw[KEYWORD_LENGTH];
    char qc_out_res_mean_e_kw[KEYWORD_LENGTH];
    char qc_out_res_stdev_e_kw[KEYWORD_LENGTH];
    char qc_out_bias_ron_e_kw_part[KEYWORD_LENGTH];
    char qc_out_ovsc_ron_e_kw_part[KEYWORD_LENGTH];
    char qc_out_bias_mean_e_kw_part[KEYWORD_LENGTH];
    char qc_out_res_mean_e_kw_part[KEYWORD_LENGTH];
    char qc_out_res_stdev_e_kw_part[KEYWORD_LENGTH];
    
    char qc_out_structx_kw_part[KEYWORD_LENGTH];
    char qc_out_structy_kw_part[KEYWORD_LENGTH];
    
    char qc_dark_mean_check_kw[KEYWORD_LENGTH];
    char qc_dark_cosmic_check_kw[KEYWORD_LENGTH];
    char qc_dark_hotpix_check_kw[KEYWORD_LENGTH];
    char qc_dark_check_kw[KEYWORD_LENGTH];
    char qc_cosmic_rate_pix_kw_first[KEYWORD_LENGTH];
    char qc_cosmic_rate_cm2_kw_first[KEYWORD_LENGTH];
    char qc_cosmic_rate_pix_kw_last[KEYWORD_LENGTH];
    char qc_cosmic_rate_cm2_kw_last[KEYWORD_LENGTH];
    char qc_out_dark_mean_kw[KEYWORD_LENGTH];
    char qc_out_hotpix_nb_kw[KEYWORD_LENGTH];
    char qc_out_dark_ron_kw[KEYWORD_LENGTH];
    char qc_out_dark_mean_kw_part[KEYWORD_LENGTH];
    char qc_out_hotpix_nb_kw_part[KEYWORD_LENGTH];
    char qc_out_dark_ron_kw_part[KEYWORD_LENGTH];
    
    char qc_ledff_min_flux_kw[KEYWORD_LENGTH];
    char qc_ledff_max_flux_kw[KEYWORD_LENGTH];
    char qc_ledff_gain_check_kw[KEYWORD_LENGTH];
    char qc_ledff_badpix_check_kw[KEYWORD_LENGTH];
    char qc_ledff_flux_check_kw[KEYWORD_LENGTH];
    char qc_ledff_check_kw[KEYWORD_LENGTH];
    char qc_out_gain_kw[KEYWORD_LENGTH];
    char qc_out_mean_flux_kw[KEYWORD_LENGTH];
    char qc_out_min_flux_kw[KEYWORD_LENGTH];
    char qc_out_max_flux_kw[KEYWORD_LENGTH];
    char qc_out_badpix_nb_kw[KEYWORD_LENGTH];
    char qc_out_gain_kw_part[KEYWORD_LENGTH];
    char qc_out_mean_flux_kw_part[KEYWORD_LENGTH];
    char qc_out_min_flux_kw_part[KEYWORD_LENGTH];
    char qc_out_max_flux_kw_part[KEYWORD_LENGTH];
    char qc_out_badpix_nb_kw_part[KEYWORD_LENGTH];
    
    char qc_order_nb_kw[KEYWORD_LENGTH];
    char qc_order_pos_kw_first[KEYWORD_LENGTH];
    char qc_order_pos_kw_last[KEYWORD_LENGTH];
    char qc_order_stdev_kw_first[KEYWORD_LENGTH];
    char qc_order_stdev_kw_last[KEYWORD_LENGTH];
    char qc_order_min_kw_first[KEYWORD_LENGTH];
    char qc_order_min_kw_last[KEYWORD_LENGTH];
    char qc_order_max_kw_first[KEYWORD_LENGTH];
    char qc_order_max_kw_last[KEYWORD_LENGTH];
    char qc_order_phys_nb_kw_first[KEYWORD_LENGTH];
    char qc_order_phys_nb_kw_last[KEYWORD_LENGTH];
    char qc_orderdef_satur_check_kw[KEYWORD_LENGTH];
    char qc_orderdef_order_check_kw[KEYWORD_LENGTH];
    char qc_orderdef_stdev_check_kw[KEYWORD_LENGTH];
    char qc_orderdef_min_check_kw[KEYWORD_LENGTH];
    char qc_orderdef_max_check_kw[KEYWORD_LENGTH];
    char qc_orderdef_check_kw[KEYWORD_LENGTH];
    char qc_orderdef_max_flux_kw_first[KEYWORD_LENGTH];
    char qc_orderdef_max_flux_kw_last[KEYWORD_LENGTH];
    
    char qc_flat_max_flux_kw_first[KEYWORD_LENGTH];
    char qc_flat_max_flux_kw_last[KEYWORD_LENGTH];
    char qc_flat_bkgr_mean_kw_first[KEYWORD_LENGTH];
    char qc_flat_bkgr_mean_kw_last[KEYWORD_LENGTH];
    char qc_flat_bkgr_min_kw_first[KEYWORD_LENGTH];
    char qc_flat_bkgr_min_kw_last[KEYWORD_LENGTH];
    char qc_flat_bkgr_max_kw_first[KEYWORD_LENGTH];
    char qc_flat_bkgr_max_kw_last[KEYWORD_LENGTH];
    char qc_flat_order_cosmic_nb_kw_first[KEYWORD_LENGTH];
    char qc_flat_order_cosmic_nb_kw_last[KEYWORD_LENGTH];
    char qc_flat_order_snr_kw_first[KEYWORD_LENGTH];
    char qc_flat_order_snr_kw_last[KEYWORD_LENGTH];
    char qc_flat_order_flat_rms_kw_first[KEYWORD_LENGTH];
    char qc_flat_order_flat_rms_kw_last[KEYWORD_LENGTH];
    char qc_flat_darkpix_nb_kw_first[KEYWORD_LENGTH];
    char qc_flat_darkpix_nb_kw_last[KEYWORD_LENGTH];
    char qc_flat_satur_check_kw[KEYWORD_LENGTH];
    char qc_flat_bkgr_check_kw[KEYWORD_LENGTH];
    char qc_flat_snr_check_kw[KEYWORD_LENGTH];
    char qc_flat_rms_check_kw[KEYWORD_LENGTH];
    char qc_flat_darkpix_check_kw[KEYWORD_LENGTH];
    char qc_flat_check_kw[KEYWORD_LENGTH];
    
    char qc_wave_order_cosmic_nb_kw_first[KEYWORD_LENGTH];
    char qc_wave_order_cosmic_nb_kw_last[KEYWORD_LENGTH];
    char qc_wave_cosmic_nb_kw[KEYWORD_LENGTH];
    char qc_wave_order_lines_nb_kw_first[KEYWORD_LENGTH];
    char qc_wave_order_lines_nb_kw_last[KEYWORD_LENGTH];
    char qc_wave_max_flux_kw_first[KEYWORD_LENGTH];
    char qc_wave_max_flux_kw_last[KEYWORD_LENGTH];
    char qc_wave_lines_nb_kw[KEYWORD_LENGTH];
    char qc_wave_order_lines_min_check_kw[KEYWORD_LENGTH];
    char qc_wave_lines_order_check_kw[KEYWORD_LENGTH];
    char qc_wave_lines_tot_check_kw[KEYWORD_LENGTH];
    char qc_wave_satur_lines_check_kw[KEYWORD_LENGTH];
    char qc_wave_thar_rejected_lines_kw[KEYWORD_LENGTH];
    char qc_wave_thar_valid_lines_nb_kw[KEYWORD_LENGTH];
    char qc_wave_order_fit_wave_kw_first[KEYWORD_LENGTH];
    char qc_wave_order_fit_wave_kw_last[KEYWORD_LENGTH];
    char qc_wave_thar_flux_ratio_kw[KEYWORD_LENGTH];
    char qc_wave_thar_global_shift_kw[KEYWORD_LENGTH];
    char qc_wave_order_chisq_kw_first[KEYWORD_LENGTH];
    char qc_wave_order_chisq_kw_last[KEYWORD_LENGTH];
    char qc_wave_order_rms_kw_first[KEYWORD_LENGTH];
    char qc_wave_order_rms_kw_last[KEYWORD_LENGTH];
    char qc_wave_wavecal_error_kw[KEYWORD_LENGTH];
    char qc_wave_order_res_kw_first[KEYWORD_LENGTH];
    char qc_wave_order_res_kw_last[KEYWORD_LENGTH];
    char qc_wave_order_resol_mean_kw[KEYWORD_LENGTH];
    char qc_wave_order_resol_median_kw[KEYWORD_LENGTH];
    char qc_wave_thar_offset_kw[KEYWORD_LENGTH];
    char qc_wave_thar_satur_lines_nb_kw[KEYWORD_LENGTH];
    char qc_wave_thar_flux_ratio_median_kw[KEYWORD_LENGTH];
    char qc_wave_thar_rv_diff_median_kw[KEYWORD_LENGTH];
    char qc_wave_res_mad_kw_first[KEYWORD_LENGTH];
    char qc_wave_res_mad_kw_last[KEYWORD_LENGTH];
    char qc_wave_res_mad2_kw_first[KEYWORD_LENGTH];
    char qc_wave_res_mad2_kw_last[KEYWORD_LENGTH];
    char qc_wave_res_rms_kw_first[KEYWORD_LENGTH];
    char qc_wave_res_rms_kw_last[KEYWORD_LENGTH];
    char qc_wave_res_rms2_kw_first[KEYWORD_LENGTH];
    char qc_wave_res_rms2_kw_last[KEYWORD_LENGTH];
    char qc_wave_reject_lines_nb_kw_first[KEYWORD_LENGTH];
    char qc_wave_reject_lines_nb_kw_last[KEYWORD_LENGTH];
    char qc_wave_fit_chi2_kw_first[KEYWORD_LENGTH];
    char qc_wave_fit_chi2_kw_last[KEYWORD_LENGTH];
    char qc_wave_reject_lines_fraction_kw_first[KEYWORD_LENGTH];
    char qc_wave_reject_lines_fraction_kw_last[KEYWORD_LENGTH];
    //char qc_wave_d_offset_kw[KEYWORD_LENGTH];
    //char qc_wave_d_offset_err_kw[KEYWORD_LENGTH];
    //char qc_wave_d_offset_rms_kw[KEYWORD_LENGTH];
    char qc_wave_fp_d_mean_kw[KEYWORD_LENGTH];
    char qc_wave_fp_d_mean_error_kw[KEYWORD_LENGTH];
    char qc_wave_fp_d_residuals_rms_kw[KEYWORD_LENGTH];
    char qc_wave_fp_d_residuals_min_kw[KEYWORD_LENGTH];
    char qc_wave_fp_d_residuals_max_kw[KEYWORD_LENGTH];
    char qc_wave_fp_d_zone_kw_first[KEYWORD_LENGTH];
    char qc_wave_fp_d_zone_mean_kw_last[KEYWORD_LENGTH];
    char qc_wave_fp_d_zone_mean_error_kw_last[KEYWORD_LENGTH];
    char qc_wave_fp_d_zone_wave_kw_last[KEYWORD_LENGTH];
    char qc_wave_drift_mean_kw[KEYWORD_LENGTH];
    char qc_wave_drift_error_kw[KEYWORD_LENGTH];
    char qc_wave_drift_rejected_pxls_kw[KEYWORD_LENGTH];
    char qc_wave_drift_flux_ratio_kw[KEYWORD_LENGTH];
    char qc_wave_thar_lamp_offset_ar_kw[KEYWORD_LENGTH];
    char qc_wave_thar_lamp_offset_ar1_kw[KEYWORD_LENGTH];
    char qc_wave_thar_lamp_offset_ar2_kw[KEYWORD_LENGTH];
    char qc_wave_thar_lines_min_check_kw[KEYWORD_LENGTH];
    char qc_wave_thar_lines_tot_check_kw[KEYWORD_LENGTH];
    char qc_wave_thar_flux_check_kw[KEYWORD_LENGTH];
    char qc_wave_thar_chi2_check_kw[KEYWORD_LENGTH];
    char qc_wave_thar_rms_check_kw[KEYWORD_LENGTH];
    char qc_wave_thar_flux_ratio_check_kw[KEYWORD_LENGTH];
    char qc_wave_wavecal_error_check_kw[KEYWORD_LENGTH];
    char qc_wave_resol_check_kw[KEYWORD_LENGTH];
    char qc_wave_satur_check_kw[KEYWORD_LENGTH];
    char qc_wave_drift_chi2_check_kw[KEYWORD_LENGTH];
    char qc_wave_sol_qual_check_kw[KEYWORD_LENGTH];
    char qc_wave_res_mad_check_kw[KEYWORD_LENGTH];
    char qc_wave_res_rms_check_kw[KEYWORD_LENGTH];
    char qc_wave_reject_lines_fraction_check_kw[KEYWORD_LENGTH];
    char qc_wave_check_kw[KEYWORD_LENGTH];
    
    char qc_lfc_order_lines_nb_kw_first[KEYWORD_LENGTH];
    char qc_lfc_order_lines_nb_kw_last[KEYWORD_LENGTH];
    char qc_lfc_lines_nb_kw[KEYWORD_LENGTH];
    char qc_lfc_order_lines_min_check_kw[KEYWORD_LENGTH];
    char qc_lfc_lines_tot_check_kw[KEYWORD_LENGTH];
    char qc_lfc_order_fit_wave_kw_first[KEYWORD_LENGTH];
    char qc_lfc_order_fit_wave_kw_last[KEYWORD_LENGTH];
    char qc_lfc_order_chisq_kw_first[KEYWORD_LENGTH];
    char qc_lfc_order_chisq_kw_last[KEYWORD_LENGTH];
    char qc_lfc_order_rms_kw_first[KEYWORD_LENGTH];
    char qc_lfc_order_rms_kw_last[KEYWORD_LENGTH];
    char qc_lfc_drift_mean_kw[KEYWORD_LENGTH];
    char qc_lfc_drift_error_kw[KEYWORD_LENGTH];
    char qc_lfc_drift_rejected_pxls_kw[KEYWORD_LENGTH];
    char qc_lfc_drift_flux_ratio_kw[KEYWORD_LENGTH];
    char qc_lfc_chisq_check_kw[KEYWORD_LENGTH];
    char qc_lfc_rms_check_kw[KEYWORD_LENGTH];
    char qc_lfc_check_kw[KEYWORD_LENGTH];
    
    char qc_drift_prefix_kw[KEYWORD_LENGTH];
    char qc_drift_first_order_kw[KEYWORD_LENGTH];
    char qc_drift_last_order_kw[KEYWORD_LENGTH];
    char qc_drift_flux_ratio_kw[KEYWORD_LENGTH];
    char qc_drift_flux_ratio_err_kw[KEYWORD_LENGTH];
    char qc_drift_mean_kw[KEYWORD_LENGTH];
    char qc_drift_mean_err_kw[KEYWORD_LENGTH];
    char qc_drift_slope_x_kw[KEYWORD_LENGTH];
    char qc_drift_slope_x_err_kw[KEYWORD_LENGTH];
    char qc_drift_slope_o_kw[KEYWORD_LENGTH];
    char qc_drift_slope_o_err_kw[KEYWORD_LENGTH];
    char qc_drift_chisq_kw[KEYWORD_LENGTH];
    char qc_drift_rejected_kw[KEYWORD_LENGTH];
    
//------------------------------------------------------------------------
    
    char qc_cal_contam_max_flux_kw_first[KEYWORD_LENGTH];
    char qc_cal_contam_max_flux_kw_last[KEYWORD_LENGTH];
    char qc_cal_contam_min_flux_check_kw[KEYWORD_LENGTH];
    char qc_cal_contam_check_kw[KEYWORD_LENGTH];
    
//------------------------------------------------------------------------
    
    //char qc_cal_eff_ab_max_flux_kw_first[KEYWORD_LENGTH];
    //char qc_cal_eff_ab_max_flux_kw_last[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_mean_kw_first[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_mean_kw_last[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_min_kw_first[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_min_kw_last[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_max_kw_first[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_max_kw_last[KEYWORD_LENGTH];
    char qc_cal_eff_ab_order_cosmic_nb_kw_first[KEYWORD_LENGTH];
    char qc_cal_eff_ab_order_cosmic_nb_kw_last[KEYWORD_LENGTH];
    char qc_cal_eff_ab_order_snr_kw_first[KEYWORD_LENGTH];
    char qc_cal_eff_ab_order_snr_kw_last[KEYWORD_LENGTH];
    //char qc_cal_eff_ab_satur_check_kw[KEYWORD_LENGTH];
    char qc_cal_eff_ab_bkgr_check_kw[KEYWORD_LENGTH];
    //char qc_cal_eff_ab_cosmic_check_kw[KEYWORD_LENGTH];
    char qc_cal_eff_ab_snr_check_kw[KEYWORD_LENGTH];
    char qc_cal_eff_ab_check_kw[KEYWORD_LENGTH];
    char qc_rel_eff_min_kw[KEYWORD_LENGTH];
    char qc_rel_eff_max_kw[KEYWORD_LENGTH];
    char qc_rel_eff_avg_kw[KEYWORD_LENGTH];
    char qc_rel_eff_rms_kw[KEYWORD_LENGTH];
    char qc_rel_eff_min_check_kw[KEYWORD_LENGTH];
    char qc_rel_eff_max_check_kw[KEYWORD_LENGTH];
    char qc_rel_eff_avg_check_kw[KEYWORD_LENGTH];
    char qc_rel_eff_rms_check_kw[KEYWORD_LENGTH];

    
//------------------------------------------------------------------------
    char qc_cal_flux_max_flux_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_max_flux_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_flux_corr_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_flux_corr_kw_last[KEYWORD_LENGTH];

    char qc_cal_flux_bkgr_mean_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_bkgr_mean_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_bkgr_min_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_bkgr_min_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_bkgr_max_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_bkgr_max_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_order_cosmic_nb_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_order_cosmic_nb_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_order_snr_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_order_snr_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_order_cal_flux_rms_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_order_cal_flux_rms_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_darkpix_nb_kw_first[KEYWORD_LENGTH];
    char qc_cal_flux_darkpix_nb_kw_last[KEYWORD_LENGTH];
    char qc_cal_flux_snr_median_kw[KEYWORD_LENGTH];
    char qc_cal_flux_satur_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_bkgr_check_kw[KEYWORD_LENGTH];

    char qc_cal_flux_cosmic_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_drift_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_flux_corr_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_guiding_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_expmeter_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_seeing_kw_check_kw[KEYWORD_LENGTH];

    char qc_cal_flux_snr_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_rms_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_darkpix_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_check_kw[KEYWORD_LENGTH];

    char qc_cal_flux_raw_abs_eff_min_kw[KEYWORD_LENGTH];
    char qc_cal_flux_raw_abs_eff_max_kw[KEYWORD_LENGTH];
    char qc_cal_flux_raw_abs_eff_mean_kw[KEYWORD_LENGTH];
	char qc_cal_flux_extcorr_abs_eff_min_kw[KEYWORD_LENGTH];
	char qc_cal_flux_extcorr_abs_eff_max_kw[KEYWORD_LENGTH];
	char qc_cal_flux_extcorr_abs_eff_mean_kw[KEYWORD_LENGTH];
    char qc_cal_flux_abs_eff_min_kw[KEYWORD_LENGTH];
    char qc_cal_flux_abs_eff_max_kw[KEYWORD_LENGTH];
    char qc_cal_flux_abs_eff_mean_kw[KEYWORD_LENGTH];
    char qc_cal_flux_abs_eff_min_check_kw[KEYWORD_LENGTH];
    char qc_cal_flux_abs_eff_max_check_kw[KEYWORD_LENGTH];

//------------------------------------------------------------------------

    char qc_sci_red_max_flux_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_max_flux_kw_last[KEYWORD_LENGTH];

    char qc_sci_ccf_rv[KEYWORD_LENGTH];
    char qc_sci_ccf_rv_error[KEYWORD_LENGTH];
    char qc_sci_ccf_fwhm[KEYWORD_LENGTH];
    char qc_sci_ccf_fwhm_error[KEYWORD_LENGTH];
    char qc_sci_ccf_contrast[KEYWORD_LENGTH];
    char qc_sci_ccf_contrast_error[KEYWORD_LENGTH];
    char qc_sci_ccf_continuum[KEYWORD_LENGTH];
    char qc_sci_ccf_mask[KEYWORD_LENGTH];
    char qc_sci_asym[KEYWORD_LENGTH];
    char qc_sci_asym_error[KEYWORD_LENGTH];
    char qc_sci_bis_span[KEYWORD_LENGTH];
    char qc_sci_bis_span_error[KEYWORD_LENGTH];
    char qc_sci_guiding_error[KEYWORD_LENGTH];
    char qc_sci_expmeter_lowflux_time[KEYWORD_LENGTH];
    char qc_sci_tmmean_used[KEYWORD_LENGTH];

    char qc_sci_red_berv[KEYWORD_LENGTH];
    char qc_sci_red_bjd[KEYWORD_LENGTH];
    char qc_sci_red_bervmax[KEYWORD_LENGTH];
    char qc_sci_red_sed[KEYWORD_LENGTH];
    char qc_sci_red_vtot[KEYWORD_LENGTH];
    char qc_sci_red_berv_factor[KEYWORD_LENGTH];

    char qc_sci_red_cosmic_nb2_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_cosmic_nb2_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_flux_corr_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_flux_corr_kw_last[KEYWORD_LENGTH];

    char qc_sci_red_bkgr_mean_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_bkgr_mean_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_bkgr_min_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_bkgr_min_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_bkgr_max_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_bkgr_max_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_order_cosmic_nb_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_order_cosmic_nb_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_order_snr_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_order_snr_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_order_sci_red_rms_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_order_sci_red_rms_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_darkpix_nb_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_darkpix_nb_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_satur_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_bkgr_check_kw[KEYWORD_LENGTH];
    
    char qc_sci_red_oh_corr_oh_lines_nb_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_oh_lines_nb_norm_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_oh_lines_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_median_ratio_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_median_ratio_norm_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_median_ratio_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_ratio_rms_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_ratio_rms_norm_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_ratio_mad_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_ratio_mad_norm_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_ratio_mad_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_oh_corr_check_kw[KEYWORD_LENGTH];
    
    char qc_sci_red_order_flux_corr_kw_first[KEYWORD_LENGTH];
    char qc_sci_red_order_flux_corr_kw_last[KEYWORD_LENGTH];
    char qc_sci_red_flux_corr_min_kw[KEYWORD_LENGTH];
    char qc_sci_red_flux_corr_max_kw[KEYWORD_LENGTH];
    
    char qc_sci_red_cosmic_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_flux_corr_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_guiding_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_expmeter_check_kw[KEYWORD_LENGTH];

    //char qc_sci_red_snr_check_kw[KEYWORD_LENGTH];
    //char qc_sci_red_rms_check_kw[KEYWORD_LENGTH];
    //char qc_sci_red_darkpix_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_drift_chi2_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_drift_flux_ratio_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_drift_mean_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_drift_mean_err_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_drift_check_kw[KEYWORD_LENGTH];
    char qc_sci_red_check_kw[KEYWORD_LENGTH];
    
//------------------------------------------------------------------------
    
    char qc_shifted_extraction_offset_kw[KEYWORD_LENGTH];
    char qc_shifted_extraction_check_kw[KEYWORD_LENGTH];
    
    char crval1[KEYWORD_LENGTH];
    char cdelt1[KEYWORD_LENGTH];
    

} espdr_qc_keywords;


/*----------------------------------------------------------------------------
 Prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_fill_qc_keywords(espdr_inst_config *inst_config,
                                      espdr_qc_keywords *qc_kws);

cpl_error_code espdr_print_qc_keywords(espdr_qc_keywords *qc_kws);
    

#endif /* ESPDR_KEYWORDS_H */
