/* $Id: espdr_inst_config_reduce-test.c,v 1.2 2013-07-26 11:44:44 amodigli Exp $
 *
 * This file is part of the ESPDR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2013-07-26 11:44:44 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include <cpl.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup espdr_inst_config_reduce_test remove table columns for Reflex usage
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/


cpl_error_code
test_inst_config_reduce(int argc, char* argv[])
{


    cpl_table* table = NULL;
    char t_name[128];
    char o_name[256];
    
    cpl_propertylist* plist = NULL;

    cpl_msg_info(cpl_func,"argc=%d",argc);
    if((size_t)argc!=2){
       return cpl_error_get_code();
    }

    sprintf(t_name,argv[1]);

    cpl_msg_info(cpl_func,"t_name=%s",t_name);

    plist = cpl_propertylist_load(t_name, 0);
    
    table = cpl_table_load(t_name, 1, 0);
    
    cpl_table_erase_column(table,"OVSC_SIGMA_CLIPPING_METHOD");
    cpl_table_erase_column(table,"OVSC_KSIGMA");
    cpl_table_erase_column(table,"OVSC_MAX_ITER");
    
    cpl_table_erase_column(table,"BIAS_SIGMA_CLIPPING_METHOD");
    cpl_table_erase_column(table,"BIAS_KSIGMA");
    
    cpl_table_erase_column(table,"DARK_SIGMA_CLIPPING_METHOD");
    cpl_table_erase_column(table,"DARK_KSIGMA");
    
    cpl_table_erase_column(table,"HOTPIXELS_SIGMA_CLIPPING_METHOD");
    cpl_table_erase_column(table,"HOTPIXELS_KSIGMA");
    cpl_table_erase_column(table,"HOTPIXELS_MAX_ITER");
    
    cpl_table_erase_column(table,"LED_FF_SIGMA_CLIPPING_METHOD");
    cpl_table_erase_column(table,"LED_FF_KSIGMA");
      
    cpl_table_erase_column(table,"BADPIXELS_KSIGMA");
    cpl_table_erase_column(table,"BADPIXELS_MAX_ITER");
    
    cpl_table_erase_column(table,"FLAT_SIGMA_CLIPPING_METHOD");
    cpl_table_erase_column(table,"FLAT_KSIGMA");
    
    cpl_table_erase_column(table,"FLAT_EXTRACTION_METHOD");
    cpl_table_erase_column(table,"FLAT_EXTRACTION_KSIGMA");
  
    cpl_table_erase_column(table,"D_FIT_POLY_DEG");
    cpl_table_erase_column(table,"WAVE_SOL_POLY_DEG");
    
    cpl_table_erase_column(table,"LFC_EXTRACTION_METHOD");
    cpl_table_erase_column(table,"LFC_EXTRACTION_KSIGMA");
   
    cpl_table_erase_column(table,"EFF_AB_EXTRACTION_METHOD");
    cpl_table_erase_column(table,"EFF_AB_EXTRACTION_KSIGMA");
    cpl_table_erase_column(table,"EFF_AB_POLY_DEG");
    
    cpl_table_erase_column(table,"FLUX_EXTRACTION_METHOD");
    cpl_table_erase_column(table,"FLUX_EXTRACTION_KSIGMA");
    cpl_table_erase_column(table,"FLUX_POLY_DEG");
   
    //cpl_table_erase_column(table,"DRIFT_METHOD_FP");
    //cpl_table_erase_column(table,"DRIFT_SPACE");
    //cpl_table_erase_column(table,"DRIFT_KSIGMA");
    

    sprintf(o_name,"reduced_%s",t_name);
    cpl_msg_info(cpl_func,"o_name=%s",o_name);
    //cpl_table_save(table,NULL,NULL,o_name,CPL_IO_CREATE);
    cpl_table_save(table,plist,NULL,o_name,CPL_IO_CREATE);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);

    return cpl_error_get_code();
}

/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of espdr_bp_detect module
 */
/*----------------------------------------------------------------------------*/

int main(int argc, char* argv[])
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_DEBUG);
    test_inst_config_reduce(argc,argv);

    return cpl_test_end(0);
}

/**@}*/
