/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/

#ifndef COMPUTEANDPRINT_H
#define COMPUTEANDPRINT_H

#include "bepop.h"


void compute_and_print( const double RightAscension, const double Declinaison,
              const double ProperMotionRightAscension, const double ProperMotionDeclinaison,
              const int year, const int month, const int day,
              const int hour, const int minute , const double second,
              const double TimeToMidExposure,
              const double StationLongitude, const double StationLatitude, const double StationAltitude ,
              const typeParamBEPOP *ptrBEPOP );
void compute_and_print_jd( const double RightAscension, const double Declinaison,
              const double ProperMotionRightAscension, const double ProperMotionDeclinaison,
              const double JulianDay_TT[2],
              const double StationLongitude, const double StationLatitude, const double StationAltitude ,
              const typeParamBEPOP *ptrBEPOP );


void compute_and_print( const double RightAscension, const double Declinaison,
              const double ProperMotionRightAscension, const double ProperMotionDeclinaison,
              const int year, const int month, const int day,
              const int hour, const int minute , const double second ,
              const double TimeToMidExposure,
              const double StationLongitude, const double StationLatitude, const double StationAltitude ,
              const typeParamBEPOP *ptrBEPOP )
{

  /* structure containing the output of BEPOP_compute routine */
  typeOutBEPOP resBEPOP ;

  BEPOP_compute( RightAscension, Declinaison,
                 ProperMotionRightAscension,  ProperMotionDeclinaison,
                 year, month, day, hour, minute , second, TimeToMidExposure,
                 StationLongitude,StationLatitude,StationAltitude ,
                 ptrBEPOP, &resBEPOP);

  printf("%4d %02d %02d %02d %02d %05.2f",year, month,day, hour, minute, second ) ;
  printf("  %7.2f ", TimeToMidExposure) ;
  printf("  %7.3f %7.3f",RightAscension,Declinaison) ;
  printf(" %6.3f %6.3f",ProperMotionRightAscension,ProperMotionDeclinaison) ;
  printf("  %7.2f %6.2f %7.1f",StationLongitude,StationLatitude,StationAltitude );
  printf("  %23.16e %23.16e",resBEPOP.BERV,resBEPOP.BERVMX) ;
  printf("  %18.10f %19.15f",resBEPOP.BTLA,resBEPOP.BOV) ;
  printf("  %18.8f",resBEPOP.SED) ;
  printf("\n");
}


void compute_and_print_jd( const double RightAscension, const double Declinaison,
              const double ProperMotionRightAscension, const double ProperMotionDeclinaison,
              const double JulianDay_TT[2],
              const double StationLongitude, const double StationLatitude, const double StationAltitude ,
              const typeParamBEPOP *ptrBEPOP )
{

  /* structure containing the output of BEPOP_compute routine */
  typeOutBEPOP resBEPOP ;

  BEPOP_compute_viaJD( RightAscension, Declinaison,
                       ProperMotionRightAscension,  ProperMotionDeclinaison,
                       JulianDay_TT ,
                       StationLongitude,StationLatitude,StationAltitude ,
                       ptrBEPOP, &resBEPOP);

  printf("%9.1f %10.7f",JulianDay_TT[0],JulianDay_TT[1] ) ;
  printf("  %7.3f %7.3f",RightAscension,Declinaison) ;
  printf(" %6.3f %6.3f",ProperMotionRightAscension,ProperMotionDeclinaison) ;
  printf("  %7.2f %6.2f %7.1f",StationLongitude,StationLatitude,StationAltitude );
  printf("  %23.16e %23.16e",resBEPOP.BERV,resBEPOP.BERVMX) ;
  printf("  %18.10f %19.15f",resBEPOP.BTLA,resBEPOP.BOV) ;
  printf("  %18.8f",resBEPOP.SED) ;
  printf("\n");
}

#endif

