/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>



#include "bepop.h"
#include "erfa.h"
#include "erfam.h"
#include "computeandprint.h"

#ifndef _iModel
#define _iModel 1
#endif


int main ( void )
{

  /* pointer to a derived type containing the parameters of the model */
  typeParamBEPOP * ptrBEPOP = NULL ; /* important to initialize at NULL to avoid errors */

  /* Parameters for the "pseudo-random" numbers generator */
  const long long a = 16807LL ;
  const long long c = 0LL ;
  const long long m= INT32_MAX ; /* 2^31 -1 */
  long long x = 1LL ;

  /* Limits in time for the test */
  const int mjd_begin = -10000 ,mjd_end = 5000 ;

  /* Time variable*/
  int year, month, day, hour, minute ;
  double second ;
  double fd; /* fraction of day, output variable for eraJd2cal routine, unused */
  double TimeToMidExposure ;

  double RightAscension,Declinaison ;
  double ProperMotionRightAscension,ProperMotionDeclinaison ;
  double StationLongitude,StationLatitude,StationAltitude ;

  int mjd ; /* do loop index */


  /* Initialisation of the pointer */
  ptrBEPOP=BEPOP_initDefault(_iModel,ptrBEPOP) ;
  BEPOP_checkInit( ptrBEPOP);


  for (mjd=mjd_begin;mjd<=mjd_end;mjd+=1)
  {
    (void) eraJd2cal( ERFA_DJ00, (double) mjd, &year, &month, &day, &fd) ;
    x = (a*x+c) % m ; hour = x % 24 ;
    x = (a*x+c) % m ; minute = x % 60 ;
    x = (a*x+c) % m ; second = (double)(x % 600)/10.0 ;
    x = (a*x+c) % m ; TimeToMidExposure = (double)(x % 12000)/10.0 ;
    x = (a*x+c) % m ; RightAscension = (double)(x % 2400)/100.0 ;
    x = (a*x+c) % m ; Declinaison = (double)(  x % 17998 +1  )/100.0 -90.0 ;
    x = (a*x+c) % m ; ProperMotionRightAscension = (double)(x % 200)/100.0 -1.0;
    x = (a*x+c) % m ; ProperMotionDeclinaison = (double)(x % 200)/100.0 -1.0;

    x = (a*x+c) % m ; StationLongitude = (double)(x % 3600)/10.0 -180.0 ;
    x = (a*x+c) % m ; StationLatitude = (double)(x % 1800)/10.0 -90.0 ;
    x = (a*x+c) % m ; StationAltitude = (double)(x % 6000)/1.0 -500.0 ;

    compute_and_print(RightAscension, Declinaison,
                    ProperMotionRightAscension,  ProperMotionDeclinaison,
                    year, month, day, hour, minute , second , TimeToMidExposure,
                    StationLongitude,StationLatitude,StationAltitude ,
                    ptrBEPOP);

  }

  ptrBEPOP=BEPOP_close(ptrBEPOP) ;
  return (0);
}

