from edps import (
    task, ReportInput, SCIENCE, QC1_CALIB, QC0, CALCHECKER
)

from .espresso_datasources import *
from .espresso_detector_properties import detector_properties
from .espresso_flats_and_tracing import flats_and_tracing
from .espresso_job_processing import n_inputs, combination_limit
from .espresso_science import science_reduction
from .espresso_wavelength import wavelength_calibration

__title__ = "ESPRESSO workflow"

IDP = "idp"

bias, dark, detmon = detector_properties()
led_ff, orderdef, flat = flats_and_tracing(dark)

# --- Tasks to compute the mutual contamination and relative efficiencies between fibers -------------------------------
contam_thar = (task('contam_thar')
               .with_recipe('espdr_cal_contam')
               .with_report('espresso_rawdisp', ReportInput.RECIPE_INPUTS)
               .with_report('espresso_contamination', ReportInput.RECIPE_INPUTS_OUTPUTS)
               .with_main_input(raw_contam_thar)
               .with_associated_input(bias, [MASTER_BIAS_RES])
               .with_associated_input(dark, [HOT_PIXEL_MASK])
               .with_associated_input(led_ff, [BAD_PIXEL_MASK])
               .with_associated_input(orderdef, [ORDER_TABLE_A, ORDER_TABLE_B])
               .with_associated_input(flat, [ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B])
               .with_associated_input(ccd_geom)
               .with_associated_input(inst_config)
               .with_input_filter(MASTER_BIAS_RES, HOT_PIXEL_MASK, BAD_PIXEL_MASK, ORDER_TABLE_A, ORDER_TABLE_B,
                                  ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B, inst_config_class,
                                  ccd_geom_class)
               .with_meta_targets([QC1_CALIB])
               .build())

contam_fp = (task('contam_fp')
             .with_recipe('espdr_cal_contam')
             .with_report('espresso_rawdisp', ReportInput.RECIPE_INPUTS)
             .with_report('espresso_contamination', ReportInput.RECIPE_INPUTS_OUTPUTS)
             .with_main_input(raw_contam_fp)
             .with_associated_input(bias, [MASTER_BIAS_RES])
             .with_associated_input(dark, [HOT_PIXEL_MASK])
             .with_associated_input(led_ff, [BAD_PIXEL_MASK])
             .with_associated_input(orderdef, [ORDER_TABLE_A, ORDER_TABLE_B])
             .with_associated_input(flat, [ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B])
             .with_associated_input(ccd_geom)
             .with_associated_input(inst_config)
             .with_input_filter(MASTER_BIAS_RES, HOT_PIXEL_MASK, BAD_PIXEL_MASK, ORDER_TABLE_A, ORDER_TABLE_B,
                                ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B, inst_config_class,
                                ccd_geom_class)
             .with_meta_targets([QC1_CALIB])
             .build())

eff_ab = (task('eff_ab')
          .with_recipe('espdr_cal_eff_ab')
          .with_report('espresso_rawdisp', ReportInput.RECIPE_INPUTS)
          .with_report('espresso_skyflat_eff', ReportInput.RECIPE_INPUTS_OUTPUTS)
          .with_main_input(raw_eff_ab)
          .with_associated_input(dark, [HOT_PIXEL_MASK])
          .with_associated_input(led_ff, [BAD_PIXEL_MASK])
          .with_associated_input(orderdef, [ORDER_TABLE_A, ORDER_TABLE_B])
          .with_associated_input(flat, [ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B])
          .with_associated_input(ccd_geom)
          .with_associated_input(inst_config)
          .with_input_filter(MASTER_BIAS_RES, HOT_PIXEL_MASK, BAD_PIXEL_MASK, ORDER_TABLE_A, ORDER_TABLE_B,
                             ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B, inst_config_class,
                             ccd_geom_class)
          .with_meta_targets([QC1_CALIB, CALCHECKER])
          .build())
# ----------------------------------------------------------------------------------------------------------------------

# --- Tasks for wavelength calibration ---------------------------------------------------------------------------------
wave_fp_fp, wave_thar_fp, wave_fp_thar, wave_lfc_fp, wave_fp_lfc = wavelength_calibration(dark, led_ff, orderdef, flat)

# --- Flux calibration
flux = (task('flux')
        .with_recipe('espdr_cal_flux')
        .with_report('espresso_rawdisp', ReportInput.RECIPE_INPUTS)
        .with_report('espresso_specphot_std', ReportInput.RECIPE_INPUTS_OUTPUTS)
        .with_main_input(raw_std_flux)
        .with_associated_input(dark, [HOT_PIXEL_MASK])
        .with_associated_input(led_ff, [BAD_PIXEL_MASK])
        .with_associated_input(orderdef, [ORDER_TABLE_A, ORDER_TABLE_B])
        .with_associated_input(flat, [ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B,
                                      BLAZE_A, BLAZE_B])
        .with_associated_input(wave_thar_fp, [WAVE_MATRIX_THAR_FP_A, DLL_MATRIX_THAR_FP_A])
        .with_associated_input(wave_fp_thar, [WAVE_MATRIX_FP_THAR_B, DLL_MATRIX_FP_THAR_B])
        .with_associated_input(ccd_geom)
        .with_associated_input(inst_config)
        .with_associated_input(std_table)
        .with_input_filter(MASTER_BIAS_RES, HOT_PIXEL_MASK, BAD_PIXEL_MASK, ORDER_TABLE_A, ORDER_TABLE_B,
                           ORDER_PROFILE_A, ORDER_PROFILE_B, FSPECTRUM_A, FSPECTRUM_B, BLAZE_A, BLAZE_B,
                           WAVE_MATRIX_THAR_FP_A, WAVE_MATRIX_FP_THAR_B, DLL_MATRIX_THAR_FP_A, DLL_MATRIX_FP_THAR_B,
                           ext_table_class, std_table_class)
        .with_associated_input(ext_table)
        .with_meta_targets([QC1_CALIB])
        .build())

# --- Reduction of science data and radial velocity stars
rv_stars, science = science_reduction(radial_velocity_star, 'rv_stars', [QC1_CALIB, CALCHECKER], raw_science, 'object',
                                      [QC0, SCIENCE, CALCHECKER, IDP], bias, dark, led_ff, orderdef, flat, wave_thar_fp,
                                      wave_fp_thar, wave_lfc_fp,
                                      wave_fp_lfc, eff_ab, flux, contam_thar, contam_fp)

# - Task to combine science exposures from the same Observing Block.
# For technical reasons, if the workflow parameter set "idp_parameters" is used, the combination
# is done only if the input number of files is lower than 250.
combine_science = (task("combine_science")
                   .with_condition(combination_limit)
                   .with_recipe("esotk_spectrum1d_combine")
                   .with_report('espresso_science', ReportInput.RECIPE_INPUTS_OUTPUTS)
                   .with_main_input(science)
                   .with_dynamic_parameter("n_inputs", n_inputs)
                   .with_input_filter(S1D_FINAL_A)
                   .with_input_map({S1D_FINAL_A: SPECTRUM_1D})
                   .with_meta_targets([SCIENCE, IDP])
                   .build())
