/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2014-10-28 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_BKGR_H
#define ESPDR_BKGR_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_keywords.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_fit.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define BKGR_X_MIN 16
#define BKGR_X_MAX 10000
#define BKGR_Y_MIN 16
#define BKGR_Y_MAX 10000

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_measure_background_science(const cpl_image *input_image,
		const cpl_image *orderdef,
		const double ccdgain,
		const double ccdsigdet,
		const int bkgr_grid_size_x,
		const int bkgr_grid_size_y,
		cpl_image **image_background_measured_RE,
		cpl_image **image_background_substracted_RE);

cpl_error_code espdr_measure_background_science_by_ext(
		const cpl_imagelist *input_image_list,
		const cpl_imagelist *orderdef_image_list,
		const double *ccdgain,
		const double *ccdsigdet,
		const int bkgr_grid_size_x,
		const int bkgr_grid_size_y,
		const espdr_CCD_geometry *CCD_geom,
		cpl_imagelist *imagelist_background_measured_RE,
		cpl_imagelist *imagelist_background_substracted_RE);

cpl_error_code espdr_measure_background_ff(const cpl_image *input_image,
		const int bkgr_grid_size_x,
		const int bkgr_grid_size_y,
		const int minlevel_factor,
		cpl_image **image_background_measured_RE,
		cpl_image **image_background_substracted_RE);

cpl_error_code espdr_measure_background_ff_by_ext(const cpl_imagelist *input_image_list,
		const espdr_CCD_geometry *CCD_geom,
		const int bkgr_grid_size_x,
		const int bkgr_grid_size_y,
		const int minlevel_factor,
		cpl_imagelist *imagelist_background_measured_RE,
		cpl_imagelist *imagelist_background_substracted_RE);

cpl_error_code remove_inter_order_background(const double *input_image,
		const double *bkgr_measurement_image,
		const int image_size_x,
		const int image_size_y,
		cpl_image **image_background_substracted_RE);
#endif /* ESPDR_BKGR_H */


