/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_DARK_H
#define ESPDR_DARK_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_keywords.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dfs.h>
#include <espdr_preprocessing.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

#define SAVE_STATIC_PRODUCT_DARK 0

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_mdark(cpl_parameterlist *parameters,
                       cpl_frameset *frameset,
					   const char* recipe_id);

cpl_error_code espdr_parameters_DARK_create(const char* recipe_id,
                                            cpl_parameterlist *list,
                                            espdr_DARK_param *p);

cpl_error_code espdr_parameters_DARK_delete(espdr_DARK_param* p);

cpl_error_code espdr_parameters_DARK_get(const char* recipe_id, 
                                         cpl_parameterlist* list,
                                         espdr_DARK_param *DARK_param);

cpl_error_code espdr_parameters_DARK_print(espdr_DARK_param *DARK_param);

/* AMO added */
espdr_DARK_param *espdr_DARK_param_init(const char *recipe_id,
                                        cpl_parameterlist *parameters);
/*************/

cpl_error_code espdr_dark_read_parameters(cpl_frameset *frameset,
                                          espdr_CCD_geometry *CCD_geom,
                                          espdr_inst_config *inst_config);

cpl_error_code espdr_verify_texp(const cpl_frameset *dark_frameset,
                                 const char *Texp_KW,
                                 const double tolerance,
                                 int *Texp_flag);



cpl_error_code espdr_stack_sigma(const cpl_frameset *input_set,
                                 const espdr_CCD_geometry *CCD_geom,
                                 const double ksigma,
                                 const char *sigma_clipping_method,
                                 const int max_iter,
                                 cpl_imagelist **master_imagelist_RE,
                                 double *master_mean_RE,
                                 double *RON_RE,
                                 int *total_cosmics_RE,
                                 const int use_hdrl);

cpl_error_code espdr_stack_sigma_with_pxl_nb(const cpl_frameset *input_set,
                                 const espdr_CCD_geometry *CCD_geom,
                                 const double ksigma,
                                 const char *sigma_clipping_method,
                                 const int max_iter,
                                 cpl_imagelist **master_imagelist_RE,
                                 cpl_imagelist **master_pxl_nb_imagelist_RE,
                                 double *master_mean_RE,
                                 double *RON_RE,
                                 int *total_cosmics_RE,
                                 const int use_hdrl);

cpl_error_code espdr_stack_sigma_one_output(const cpl_imagelist *input_images_list,
                                            const int nx,
                                            const int ny,
                                            const double ksigma,
                                            const char *sigma_clipping_method,
                                            const int max_iter,
                                            cpl_image **master_image_RE,
                                            double *RON_RE,
                                            int *totalCosmics_RE);


cpl_error_code espdr_stack_sigma_one_output_mean(const cpl_imagelist *input_imagelist,
                                            const int nx,
                                            const int ny,
                                            const double ksigma,
                                            const int max_iter,
                                            cpl_image **master_image_RE,
                                            double *RON_RE,
                                            int *totalCosmics_RE);

cpl_error_code espdr_stack_sigma_one_output_mean_with_pxl_nb(const cpl_imagelist *input_imagelist,
                                            const int nx,
                                            const int ny,
                                            const double ksigma,
                                            const int max_iter,
                                            cpl_image **master_image_RE,
                                            cpl_image **master_pxl_nb_image_RE,
                                            double *RON_RE,
                                            int *totalCosmics_RE);

cpl_error_code espdr_stack_sigma_one_output_median(const cpl_imagelist *input_imagelist,
                                            const int nx,
                                            const int ny,
                                            const double ksigma,
                                            const int max_iter,
                                            cpl_image **master_image_RE,
                                            double *RON_RE,
                                            int *totalCosmics_RE);

cpl_error_code espdr_stack_sigma_one_output_median_with_pxl_nb(const cpl_imagelist *input_imagelist,
                                            const int nx,
                                            const int ny,
                                            const double ksigma,
                                            const int max_iter,
                                            cpl_image **master_image_RE,
                                            cpl_image **master_pxl_nb_image_RE,
                                            double *RON_RE,
                                            int *totalCosmics_RE);

cpl_error_code espdr_cosmics_rates_prepare(const int *total_cosmics_nb,
                                           const espdr_CCD_geometry *CCD_geom,
                                           espdr_qc_keywords *qc_kws,
                                           const int frames_nb,
                                           const double exposure_time,
                                           cpl_propertylist **keywords_RE);

cpl_error_code espdr_cosmics_rates(const int total_cosmics_nb,
                                   const int nx, const int ny,
								   const int pixel_size,
                                   const int frames_nb,
                                   const double Texp,
                                   double *rate_hit_pixel_RE,
                                   double *rate_hit_cm2_RE);

cpl_error_code espdr_hot_pixels_prepare(cpl_imagelist *master_dark_list,
                                        espdr_CCD_geometry *CCD_geom,
                                        espdr_qc_keywords *qc_kws,
                                        espdr_inst_config *inst_config,
                                        const double exposure_time,
                                        double *RON_DARK,
                                        cpl_imagelist **hot_pixel_mask_list_RE,
                                        cpl_propertylist **keywords_RE,
                                        const int use_hdrl);

cpl_error_code espdr_hot_pixels(cpl_imagelist *master_dark_list,
                                espdr_CCD_geometry *CCD_geom,
                                espdr_inst_config *inst_config,
                                double *mean_RE,
                                int *hot_pixels_RE,
                                double *sigma_RE,
                                cpl_imagelist **hot_pixel_mask_list_RE);
	
cpl_error_code espdr_dark_QC(const espdr_CCD_geometry *CCD_geom,
                             const double exposure_time,
                             espdr_inst_config *inst_config,
                             espdr_qc_keywords *qc_kws,
                             cpl_propertylist **keywords_RE);

#endif /* ESPDR_DARK_H */
