/*                                                                           a
 *   This file is part of the ESO X-shooter Pipeline                         *
 *   Copyright (C) 2006 European Southern Observatory                        *
 *                                                                           *
 *   This library is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the Free Software             *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA    *
 *                                                                           */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-06 14:49:56 $
 * $Revision: 1.5 $
 * $Name: not supported by cvs2svn $
 */
#ifndef ESPDR_PIXELS_H
#define ESPDR_PIXELS_H

/*----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include <string.h>
#include <cpl.h>

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/

#define COSMIC_RAY_REMOVED      16
#define LOW_QE_PIXEL            64
#define CALIBRATION_DEFECT      128
#define HOT_PIXEL               256
#define DARK_PIXEL              512
#define DETECTOR_SATURATION     2048
#define AD_CONVERTER_SATURATION 4096
#define PERMANENT_CCD_DEFECT    8192
#define OTHER_BAD_PIXEL         16384

/*----------------------------------------------------------------------------
 Prototypes
 ----------------------------------------------------------------------------*/

#endif
