/* $Id: espdr_bp_detect-test.c,v 1.2 2013-07-26 11:44:44 amodigli Exp $
 *
 * This file is part of the ESPDR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2013-07-26 11:44:44 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>
#include <cpl.h>
/*----------------------------------------------------------------------------*/
/**
 * @defgroup espdr_bp_verify_test count false positive and negatives
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/

static cpl_frame*
espdr_test_crea_frame_ima(const char* fname)
{
   cpl_frame* frame=NULL;

   frame=cpl_frame_new();
   cpl_frame_set_type(frame,CPL_FRAME_TYPE_IMAGE);
   cpl_frame_set_group(frame,CPL_FRAME_GROUP_CALIB);
   cpl_frame_set_tag(frame,"test");
   cpl_frame_set_filename(frame,fname);
   return frame;
}

static cpl_frame*
espdr_test_crea_frame_tab(const char* fname)
{
   cpl_frame* frame=NULL;

   frame=cpl_frame_new();
   cpl_frame_set_type(frame,CPL_FRAME_TYPE_TABLE);
   cpl_frame_set_group(frame,CPL_FRAME_GROUP_CALIB);
   cpl_frame_set_tag(frame,"test");
   cpl_frame_set_filename(frame,fname);
   return frame;
}


static cpl_propertylist*
espdr_test_crea_header(void)
{
   cpl_propertylist* head=NULL;
   head=cpl_propertylist_new();
   cpl_boolean type=CPL_TRUE;
   cpl_propertylist_append_string(head,"ESO PRO CATG","TEST");
   cpl_propertylist_append_double(head,"KEY_DOUBLE",1.);
   cpl_propertylist_append_float(head,"KEY_FLOAT",1.);
   cpl_propertylist_append_int(head,"KEY_INT",1);
   cpl_propertylist_append_bool(head,"KEY_BOOL",type);
   cpl_propertylist_append_string(head,"KEY_STRING","ESPRESSO");

   return head;

}


static cpl_frameset*
espdr_test_crea_set(void)
{
   cpl_frameset* set=cpl_frameset_new();
   cpl_frame* frame=NULL;

   frame=espdr_test_crea_frame_ima("ima_int.fits");
   cpl_frameset_insert( set, cpl_frame_duplicate( frame));
   cpl_frame_delete(frame);
   frame=espdr_test_crea_frame_ima("ima_float.fits");
   cpl_frameset_insert( set, cpl_frame_duplicate( frame));
   cpl_frame_delete(frame);
   frame=espdr_test_crea_frame_ima("ima_double.fits");
   cpl_frameset_insert( set, cpl_frame_duplicate( frame));
   cpl_frame_delete(frame);

   frame=espdr_test_crea_frame_tab("tab.fits");
   cpl_frameset_insert( set, cpl_frame_duplicate( frame));
   cpl_frame_delete(frame);
   return set;
}

cpl_error_code
test_image(void)
{
   cpl_image* ima=NULL;
   cpl_size sx=100;
   cpl_size sy=100;
   cpl_propertylist* head=NULL;
   cpl_frameset* set=NULL;
   cpl_parameterlist* parlist=NULL;

   parlist=cpl_parameterlist_new();
   head=espdr_test_crea_header();
   set=espdr_test_crea_set();

   ima=cpl_image_new(sx,sy,CPL_TYPE_INT);
   cpl_image_add_scalar(ima,1);
   //cpl_image_save(ima, "ima_int.fits", CPL_TYPE_INT, head, CPL_IO_DEFAULT);
   cpl_image_delete(ima);

   ima=cpl_image_new(sx,sy,CPL_TYPE_FLOAT);
   cpl_image_add_scalar(ima,3.14159265);
   //cpl_image_save(ima, "ima_float.fits", CPL_TYPE_FLOAT, head, CPL_IO_DEFAULT);
   cpl_image_delete(ima);

   ima=cpl_image_new(sx,sy,CPL_TYPE_DOUBLE);
   cpl_image_add_scalar(ima,3.14159265358979323846264338327950288419716939937);
   //cpl_image_save(ima, "ima_double.fits", CPL_TYPE_DOUBLE, head, CPL_IO_DEFAULT);
   cpl_image_delete(ima);

/*
   cpl_dfs_save_image(set,head,parlist,set,NULL,ima,CPL_TYPE_INT,
                      "recipe_test",head,NULL,"test","ima_int.fits");
   cpl_dfs_save_image(set,head,parlist,set,NULL,ima,CPL_TYPE_FLOAT,
                      "recipe_test",head,NULL,"test","ima_float.fits");
   cpl_dfs_save_image(set,head,parlist,set,NULL,ima,CPL_TYPE_DOUBLE,
                      "recipe_test",head,NULL,"test","ima_double.fits");
*/

   cpl_propertylist_delete(head);
   cpl_frameset_delete(set);
   cpl_parameterlist_delete(parlist);

    return cpl_error_get_code();
}


cpl_error_code
test_table(void)
{
   cpl_propertylist* head=NULL;
   cpl_frameset* set=NULL;
   cpl_table* tab=NULL;
   int nrow=10;
   cpl_parameterlist* parlist=NULL;

   parlist=cpl_parameterlist_new();
   head=espdr_test_crea_header();
   set=espdr_test_crea_set();

   tab=cpl_table_new(nrow);
   cpl_table_new_column(tab, "column_int",CPL_TYPE_INT);
   cpl_table_new_column(tab, "column_float",CPL_TYPE_FLOAT);
   cpl_table_new_column(tab, "column_double",CPL_TYPE_DOUBLE);
   cpl_table_new_column(tab, "column_string",CPL_TYPE_STRING);

   cpl_table_fill_column_window_int(tab, "column_int", 0, nrow, 1);
   cpl_table_fill_column_window_float(tab, "column_float", 0, nrow, 2.);
   cpl_table_fill_column_window_double(tab, "column_double", 0, nrow, 3.);
   cpl_table_fill_column_window_string(tab, "column_string", 0, nrow, "espresso");


   //cpl_table_save(tab,head,NULL,"tab.fits",CPL_IO_DEFAULT);

   /*
   cpl_dfs_save_table(set,head,parlist,set,NULL,tab,NULL,
                      "recipe_test",head,NULL,"test","tab.fits");

   */
   cpl_table_delete(tab);
   cpl_propertylist_delete(head);
   cpl_parameterlist_delete(parlist);
   cpl_frameset_delete(set);


    return cpl_error_get_code();
}


/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of espdr_bp_detect module
 */
/*----------------------------------------------------------------------------*/

int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);
    test_image();
    test_table();

    return cpl_test_end(0);
}

/**@}*/
