/* $Id: espdr_dfs-test.c,v 1.2 2013-07-26 11:44:44 amodigli Exp $
 *
 * This file is part of the ESPDR Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2013-07-26 11:44:44 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include <cpl.h>

#include <espdr_parameters.h>
#include <espdr_utils.h>
#include <espdr_msg.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup espdr_dfs_test  Unit test of espdr_dfs
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/


/*----------------------------------------------------------------------------*/
/**
  @brief    Unit test of espdr_dfs_set_groups
 */
/*----------------------------------------------------------------------------*/
static cpl_error_code 
test_parameters(void)
{

    cpl_errorstate prestate = cpl_errorstate_get();
    espdr_msg_init();
    const char* recipe_id="test";
    cpl_parameterlist *param_list;
    int val_int=1;
    int val_double=1;
    const char* val_string="param_val";


    cpl_test_error(CPL_ERROR_NONE);
    param_list = cpl_parameterlist_new();


    /* Test with invalid input */
    espdr_parameters_new_double(NULL, param_list, "par_name", 1,"par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_int(NULL, param_list, "par_name", 1,"par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_string(NULL, param_list, "par_name", "par_value","par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);


    espdr_parameters_new_double(recipe_id, NULL, "par_name", 1,"par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_int(recipe_id, NULL, "par_name", 1,"par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_string(recipe_id, NULL, "par_name", "par_value","par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);


    espdr_parameters_new_double(recipe_id, param_list,  NULL, 1,"par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_int(recipe_id, param_list, NULL, 1,"par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_string(recipe_id, param_list, NULL, "par_value","par_help");
    cpl_test_error(CPL_ERROR_NULL_INPUT);


    espdr_parameters_new_double(recipe_id, param_list, "par_name", 1,NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_int(recipe_id, param_list, "par_name", 1,NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    espdr_parameters_new_string(recipe_id, param_list, "par_name", "par_value",NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);



    cpl_errorstate_set(prestate);

    /* Test with valid input and verify results */
    {

        espdr_parameters_new_double(recipe_id, param_list, "par_name_double", 1,"par_help");
        cpl_test_error(CPL_ERROR_NONE);
        val_double = espdr_parameters_get_double(recipe_id, param_list,"par_name_double");
        cpl_test_abs(val_double, 1, 0.0001);


        espdr_parameters_new_int(recipe_id, param_list,  "par_name_int", 1,"par_help");
        cpl_test_error(CPL_ERROR_NONE);
        val_int = espdr_parameters_get_int(recipe_id, param_list,"par_name_int");
        cpl_test_abs(val_int, 1, 0.0001);


        espdr_parameters_new_string(recipe_id, param_list, "par_name_string", "par_value","par_help");
        cpl_test_error(CPL_ERROR_NONE);

        val_string = espdr_parameters_get_string(recipe_id, param_list,"par_name_string");
        cpl_test_eq_string(val_string,"par_value");

    }
    cpl_test_abs(espdr_msg_get_warnings(), 0, 0.1);
    cpl_free(val_string);
    cpl_parameterlist_delete(param_list);
    return cpl_error_get_code();
}

/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of espdr_dfs module
 */
/*----------------------------------------------------------------------------*/

int main(void)
{

    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);
    test_parameters();
    return cpl_test_end(0);
}

/**@}*/
