# !/bin/bash
# Script to download the Earth Orientation Parameters (EOP)
# from http://hpiers.obspm.fr/iers/eop/eopc04/eopc04_IAU2000.62-now
# The script doesn't download the file if it exists already
# The script updates the symbolic link eopc04_IAU2000.62-now

# Date definition
strDate=`date '+%Y%m%d'` # && echo ${strDate}

# Download the file
fileName="eopc04_IAU2000.62-now.${strDate}"
if [ ! -e ./${fileName} ] ; then # if file doesn't exist
  wget -O ${fileName} hpiers.obspm.fr/iers/eop/eopc04/eopc04_IAU2000.62-now # Download latest values
fi

if [ -e ./${fileName} ] ; then # if file exists
  ln -fs ${fileName} eopc04_IAU2000.62-now # update the symbolic link
fi

