/*-----------------------------------------------------------------*/
/*!
  \file earth_orientation_parameters.h
  \brief header file for earth_orientation_parameters.c

  \author  H. Manche
           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris.

   Copyright 2014, 2015, 2016, CNRS
   email of the author : herve.manche@obspm.fr

  last revision: 05/06/2014

  History:
  \note H. Manche 05/06/2014 : creation
 */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/

#ifndef EARTHORIENTATIONPARAMETERS_H
#define EARTHORIENTATIONPARAMETERS_H



typedef struct
{
  /* Fields read from EOP files */
  int MJD_UTC ;     /* Modified julian date in UTC time scales;
                       values are always at 0h00 UTC -> no problem for the definition */
  double UT1mUTC ;  /* value of UT1-UTC in second at 0h00 UTC */
  double xp,yp ;    /* polar motion, in radians */
  double dX, dY ;   /* corrections to the celestial intermediate pole, in radian */

  /* Other fields derived from previous ones, more usefull in calculations */
  double JulianDay_TT[2] ; /* julian day (2-parts) in Terrestrial Time */
  double UT1mTT ;          /* UT1-TT at JulianDay_TT */

} EarthOrientationParameters_t;

typedef struct
{
  /* Fields read from EOP files */
  int N_EOP ;         /* number of dates where EOP are available */
  double ValMinTT ;  /* first julian day TT minus J2000 */
  double ValMaxTT ;  /* last julian day TT minus J2000 */

  int *MJD_UTC ;      /* Modified julian date in UTC time scales;
                         values are always at 0h00 UTC -> no problem for the definition */
  double *UT1mUTC ;   /* value of UT1-UTC in second at 0h00 UTC */
  double *xp,*yp ;    /* polar motion, in radians */
  double *dX, *dY ;   /* corrections to the celestial intermediate pole, in radian */

  /* Other fields derived from previous ones, more usefull in calculations */
  double *JulianDay_TT1 ; /* julian day (integer part) in Terrestrial Time */
  double *JulianDay_TT2 ; /* julian day (decimal part) in Terrestrial Time */
  double *UT1mTT ;        /* UT1-TT at JulianDay_TT */

} t_ArraysAllEOPs;






void extract_EOP_FromFile(const char *FileName, t_ArraysAllEOPs *ptr_EOPvalues ) ;
void interpol_EOP(const double JulianDay_TT[2], const int DegreeInterpolation,
                  const int ActiveEOPs,
                  const t_ArraysAllEOPs TabAllEOP,
                  EarthOrientationParameters_t *EOPvalue);



#endif
